/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import jspecview.source.JDXSourceStreamTokenizer;

public class JDXHeader {
    public String title = "";
    public String jcampdx = "5.01";
    public String dataType = "";
    public String dataClass = "";
    public String origin = "";
    public String owner = "PUBLIC DOMAIN";
    public String longDate = "";
    public String date = "";
    public String time = "";
    static final String[] typeNames = new String[]{"ND NMR SPECTRUM   NMR", "NMR SPECTRUM      NMR", "INFRARED SPECTRUM IR", "MASS SPECTRUM     MS", "RAMAN SPECTRUM    RAMAN", "GAS CHROMATOGRAM  GC", "UV/VIS SPECTRUM   UV/VIS"};
    private String qualifiedType;
    protected Lst<String[]> headerTable = new Lst();

    public void setTitle(String title) {
        this.title = title;
    }

    public void setJcampdx(String versionNum) {
        this.jcampdx = versionNum;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public void setDataClass(String dataClass) {
        this.dataClass = dataClass;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setLongDate(String longDate) {
        this.longDate = longDate;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public String getTitle() {
        return this.title;
    }

    static String getTypeName(String type) {
        type = type.toUpperCase();
        for (int i = 0; i < typeNames.length; ++i) {
            if (!typeNames[i].startsWith(type)) continue;
            return typeNames[i].substring(18);
        }
        return type;
    }

    public String getQualifiedDataType() {
        return this.qualifiedType == null ? (this.qualifiedType = JDXHeader.getTypeName(this.dataType)) : this.qualifiedType;
    }

    public String getJcampdx() {
        return this.jcampdx;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getLongDate() {
        return this.longDate;
    }

    public String getDate() {
        return this.date;
    }

    public String getTime() {
        return this.time;
    }

    public String getDataClass() {
        return this.dataClass;
    }

    public void setHeaderTable(Lst<String[]> table) {
        this.headerTable = table;
    }

    public Lst<String[]> getHeaderTable() {
        return this.headerTable;
    }

    public String[][] getHeaderRowDataAsArray(boolean addDataClass, int nMore) {
        String[][] rowData = new String[(addDataClass ? 6 : 5) + this.headerTable.size() + nMore][];
        int i = 0;
        rowData[i++] = new String[]{"##TITLE", this.title};
        rowData[i++] = new String[]{"##JCAMP-DX", this.jcampdx};
        rowData[i++] = new String[]{"##DATA TYPE", this.dataType};
        if (addDataClass) {
            rowData[i++] = new String[]{"##DATA CLASS", this.dataClass};
        }
        rowData[i++] = new String[]{"##ORIGIN", this.origin};
        rowData[i++] = new String[]{"##OWNER", this.owner};
        for (int j = 0; j < this.headerTable.size(); ++j) {
            rowData[i++] = this.getRow(j);
        }
        return rowData;
    }

    private String[] getRow(int j) {
        String[] s = (String[])this.headerTable.get(j);
        return s;
    }

    public static class DataLDRTable {
        Lst<String[]> table = new Lst();
        Map<String, Integer> map = new Hashtable<String, Integer>();

        public void addHeader(String label, String value) {
            Integer pt = this.map.get(label);
            if (pt == null) {
                pt = this.table.size();
                this.table.addLast(new String[]{label, value, JDXSourceStreamTokenizer.cleanLabel(label)});
                this.map.put(label, pt);
            } else {
                String[] entry = (String[])this.table.get(pt);
                entry[1] = value;
            }
        }
    }
}

