/*
 * Decompiled with CFR 0.152.
 */
package org.itk.simple;

import java.util.AbstractList;
import java.util.RandomAccess;
import org.itk.simple.SimpleITKJNI;

public class VectorInt32
extends AbstractList<Integer>
implements RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected VectorInt32(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(VectorInt32 vectorInt32) {
        return vectorInt32 == null ? 0L : vectorInt32.swigCPtr;
    }

    protected static long swigRelease(VectorInt32 vectorInt32) {
        long l = 0L;
        if (vectorInt32 != null) {
            if (!vectorInt32.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = vectorInt32.swigCPtr;
            vectorInt32.swigCMemOwn = false;
            vectorInt32.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SimpleITKJNI.delete_VectorInt32(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public VectorInt32(int[] nArray) {
        this();
        this.doReserve(nArray.length);
        for (int n : nArray) {
            this.doAdd(n);
        }
    }

    public VectorInt32(Iterable<Integer> iterable) {
        this();
        for (int n : iterable) {
            this.doAdd(n);
        }
    }

    @Override
    public Integer get(int n) {
        return this.doGet(n);
    }

    @Override
    public Integer set(int n, Integer n2) {
        return this.doSet(n, n2);
    }

    @Override
    public boolean add(Integer n) {
        ++this.modCount;
        this.doAdd(n);
        return true;
    }

    @Override
    public void add(int n, Integer n2) {
        ++this.modCount;
        this.doAdd(n, n2);
    }

    @Override
    public Integer remove(int n) {
        ++this.modCount;
        return this.doRemove(n);
    }

    @Override
    protected void removeRange(int n, int n2) {
        ++this.modCount;
        this.doRemoveRange(n, n2);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public int capacity() {
        return this.doCapacity();
    }

    public void reserve(int n) {
        this.doReserve(n);
    }

    public VectorInt32() {
        this(SimpleITKJNI.new_VectorInt32__SWIG_0(), true);
    }

    public VectorInt32(VectorInt32 vectorInt32) {
        this(SimpleITKJNI.new_VectorInt32__SWIG_1(VectorInt32.getCPtr(vectorInt32), vectorInt32), true);
    }

    @Override
    public boolean isEmpty() {
        return SimpleITKJNI.VectorInt32_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        SimpleITKJNI.VectorInt32_clear(this.swigCPtr, this);
    }

    public VectorInt32(int n, int n2) {
        this(SimpleITKJNI.new_VectorInt32__SWIG_2(n, n2), true);
    }

    private int doCapacity() {
        return SimpleITKJNI.VectorInt32_doCapacity(this.swigCPtr, this);
    }

    private void doReserve(int n) {
        SimpleITKJNI.VectorInt32_doReserve(this.swigCPtr, this, n);
    }

    private int doSize() {
        return SimpleITKJNI.VectorInt32_doSize(this.swigCPtr, this);
    }

    private void doAdd(int n) {
        SimpleITKJNI.VectorInt32_doAdd__SWIG_0(this.swigCPtr, this, n);
    }

    private void doAdd(int n, int n2) {
        SimpleITKJNI.VectorInt32_doAdd__SWIG_1(this.swigCPtr, this, n, n2);
    }

    private int doRemove(int n) {
        return SimpleITKJNI.VectorInt32_doRemove(this.swigCPtr, this, n);
    }

    private int doGet(int n) {
        return SimpleITKJNI.VectorInt32_doGet(this.swigCPtr, this, n);
    }

    private int doSet(int n, int n2) {
        return SimpleITKJNI.VectorInt32_doSet(this.swigCPtr, this, n, n2);
    }

    private void doRemoveRange(int n, int n2) {
        SimpleITKJNI.VectorInt32_doRemoveRange(this.swigCPtr, this, n, n2);
    }
}

