/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gradle.model.impl;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.pattern.PatternMatcher;
import org.gradle.api.internal.file.pattern.PatternMatcherFactory;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.gradle.model.impl.FilePattern;

public class GradleResourceFileFilter
implements FileFilter {
    private final FilePattern myFilePattern;
    private final File myRoot;
    private final Spec<RelativePath> myFileFilterSpec;

    public GradleResourceFileFilter(@NotNull File rootFile, @NotNull FilePattern filePattern) {
        if (rootFile == null) {
            GradleResourceFileFilter.$$$reportNull$$$0(0);
        }
        if (filePattern == null) {
            GradleResourceFileFilter.$$$reportNull$$$0(1);
        }
        this.myFilePattern = filePattern;
        this.myRoot = rootFile;
        this.myFileFilterSpec = this.getAsSpec();
    }

    @Override
    public boolean accept(@NotNull File file) {
        String relPath;
        if (file == null) {
            GradleResourceFileFilter.$$$reportNull$$$0(2);
        }
        return (relPath = FileUtil.getRelativePath((File)this.myRoot, (File)file)) != null && this.isIncluded(relPath);
    }

    private boolean isIncluded(@NotNull String relativePath) {
        if (relativePath == null) {
            GradleResourceFileFilter.$$$reportNull$$$0(3);
        }
        RelativePath path = new RelativePath(true, relativePath.split(Pattern.quote(File.separator)));
        return this.myFileFilterSpec.isSatisfiedBy((Object)path);
    }

    private Spec<RelativePath> getAsSpec() {
        return Specs.intersect((Spec[])new Spec[]{this.getAsIncludeSpec(true), Specs.negate(this.getAsExcludeSpec(true))});
    }

    private Spec<RelativePath> getAsExcludeSpec(boolean caseSensitive) {
        LinkedHashSet<String> allExcludes = new LinkedHashSet<String>(this.myFilePattern.excludes);
        ArrayList<MyRelativePathSpec> matchers = new ArrayList<MyRelativePathSpec>();
        for (String exclude : allExcludes) {
            PatternMatcher matcher = PatternMatcherFactory.getPatternMatcher((boolean)false, (boolean)caseSensitive, (String)exclude);
            matchers.add(new MyRelativePathSpec(matcher));
        }
        if (matchers.isEmpty()) {
            return Specs.satisfyNone();
        }
        return Specs.union(matchers);
    }

    private Spec<RelativePath> getAsIncludeSpec(boolean caseSensitive) {
        ArrayList<MyRelativePathSpec> matchers = new ArrayList<MyRelativePathSpec>();
        for (String include : this.myFilePattern.includes) {
            PatternMatcher matcher = PatternMatcherFactory.getPatternMatcher((boolean)true, (boolean)caseSensitive, (String)include);
            matchers.add(new MyRelativePathSpec(matcher));
        }
        return Specs.union(matchers);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePattern";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/gradle/model/impl/GradleResourceFileFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isIncluded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyRelativePathSpec
    implements Spec<RelativePath> {
        @NotNull
        private final PatternMatcher matcher;

        MyRelativePathSpec(@NotNull PatternMatcher matcher) {
            if (matcher == null) {
                MyRelativePathSpec.$$$reportNull$$$0(0);
            }
            this.matcher = matcher;
        }

        public boolean isSatisfiedBy(RelativePath path) {
            return this.matcher.test(path.getSegments(), path.isFile());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "org/jetbrains/jps/gradle/model/impl/GradleResourceFileFilter$MyRelativePathSpec", "<init>"));
        }
    }
}

