/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ConditionalUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.ErrorUtil;

class MergeIfAndPredicate
implements PsiElementPredicate {
    MergeIfAndPredicate() {
    }

    @Override
    public boolean satisfiedBy(@NotNull PsiElement element) {
        if (element == null) {
            MergeIfAndPredicate.$$$reportNull$$$0(0);
        }
        if (!(element instanceof GrIfStatement)) {
            return false;
        }
        GrIfStatement ifStatement = (GrIfStatement)element;
        if (ErrorUtil.containsError(ifStatement)) {
            return false;
        }
        GrStatement thenBranch = ifStatement.getThenBranch();
        if (thenBranch == null) {
            return false;
        }
        if (!((thenBranch = ConditionalUtils.stripBraces(thenBranch)) instanceof GrIfStatement)) {
            return false;
        }
        GrIfStatement childIfStatement = (GrIfStatement)thenBranch;
        GrStatement elseBranch = ifStatement.getElseBranch();
        if (elseBranch != null && (elseBranch = ConditionalUtils.stripBraces(elseBranch)) != null) {
            return false;
        }
        return childIfStatement.getElseBranch() == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/control/MergeIfAndPredicate", "satisfiedBy"));
    }
}

