/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.impl;

import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.dependency.GraphDataInput;
import org.jetbrains.jps.dependency.GraphDataOutput;
import org.jetbrains.jps.dependency.NodeSource;
import org.jetbrains.jps.util.SystemInfo;

public final class PathSource
implements NodeSource {
    @NotNull
    private final String myPath;

    public PathSource(@NotNull String path) {
        if (path == null) {
            PathSource.$$$reportNull$$$0(0);
        }
        this.myPath = File.separatorChar != '/' ? path.replace(File.separatorChar, '/') : path;
    }

    public PathSource(@NotNull GraphDataInput in) throws IOException {
        if (in == null) {
            PathSource.$$$reportNull$$$0(1);
        }
        this.myPath = in.readUTF();
    }

    @Override
    public void write(GraphDataOutput out) throws IOException {
        out.writeUTF(this.myPath);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathSource that = (PathSource)o;
        return SystemInfo.isFileSystemCaseSensitive ? this.myPath.equals(that.myPath) : this.myPath.equalsIgnoreCase(that.myPath);
    }

    @Override
    public int hashCode() {
        if (this.myPath.isEmpty()) {
            return 0;
        }
        return SystemInfo.isFileSystemCaseSensitive ? this.myPath.hashCode() : PathSource.stringHashCodeInsensitive(this.myPath);
    }

    @Override
    public String toString() {
        return this.myPath;
    }

    private static int stringHashCodeInsensitive(@NotNull CharSequence chars) {
        if (chars == null) {
            PathSource.$$$reportNull$$$0(2);
        }
        int h = 0;
        for (int off = 0; off < chars.length(); ++off) {
            h = 31 * h + PathSource.toLowerCase(chars.charAt(off));
        }
        return h;
    }

    private static char toLowerCase(char a) {
        if (a <= 'z') {
            return a >= 'A' && a <= 'Z' ? (char)(a + 32) : a;
        }
        return Character.toLowerCase(a);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/dependency/impl/PathSource";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "stringHashCodeInsensitive";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

