/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.JsLibrary;
import org.jetbrains.kotlin.utils.LibraryUtils;
import org.jetbrains.kotlin.utils.fileUtils.FileUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J(\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\u0011\u001a\u00020\b2\b\b\u0002\u0010\u0012\u001a\u00020\nH\u0007J$\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\f2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000e0\u0016H\u0007J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J(\u0010\u001a\u001a\u00020\u000e*\u00020\f2\u0006\u0010\u001b\u001a\u00020\b2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000e0\u0016H\u0002J \u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u000e\u0010\u001e\u001a\u0004\u0018\u00010\b*\u00020\fH\u0002J\f\u0010\u001f\u001a\u00020\f*\u00020\fH\u0002J$\u0010 \u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\f2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000e0\u0016H\u0002J$\u0010!\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\f2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000e0\u0016H\u0002J \u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\nH\u0002J \u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\nH\u0002J$\u0010'\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\f2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000e0\u0016H\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010\b2\u0006\u0010)\u001a\u00020\bH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/utils/JsLibraryUtils;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "META_INF_RESOURCES", "", "isKotlinJavascriptIrLibrary", "", "candidate", "Ljava/io/File;", "copyJsFilesFromLibraries", "", "libraries", "", "outputLibraryJsPath", "copySourceMap", "traverseJsLibrary", "lib", "action", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/utils/JsLibrary;", "isZippedKlibInZip", "isZippedKlib", "runIfFileExists", "relativePath", "copyJsFilesFromDirectory", "dir", "contentIfExists", "correspondingSourceMapFile", "processDirectory", "traverseDirectory", "copyJsFilesFromZip", "file", "copyLibrary", "outputPath", "library", "traverseArchive", "getSuggestedPath", "path", "js.config"})
@SourceDebugExtension(value={"SMAP\nJsLibraryUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsLibraryUtils.kt\norg/jetbrains/kotlin/utils/JsLibraryUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,195:1\n1#2:196\n1563#3:197\n1634#3,3:198\n1869#3,2:201\n*S KotlinDebug\n*F\n+ 1 JsLibraryUtils.kt\norg/jetbrains/kotlin/utils/JsLibraryUtils\n*L\n160#1:197\n160#1:198,3\n171#1:201,2\n*E\n"})
public final class JsLibraryUtils {
    @NotNull
    public static final JsLibraryUtils INSTANCE = new JsLibraryUtils();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String META_INF_RESOURCES;

    private JsLibraryUtils() {
    }

    @JvmStatic
    public static final boolean isKotlinJavascriptIrLibrary(@NotNull File candidate2) {
        Intrinsics.checkNotNullParameter(candidate2, "candidate");
        return INSTANCE.isZippedKlib(candidate2) ? true : (FileUtil.isJarOrZip(candidate2) ? INSTANCE.isZippedKlibInZip(candidate2) : (!FilesKt.resolve(candidate2, "default").isDirectory() ? false : (!FilesKt.resolve(FilesKt.resolve(candidate2, "default"), "manifest").isFile() ? false : FilesKt.resolve(FilesKt.resolve(candidate2, "default"), "ir").isDirectory())));
    }

    @JvmStatic
    public static final void copyJsFilesFromLibraries(@NotNull List<String> libraries, @NotNull String outputLibraryJsPath, boolean copySourceMap) {
        Intrinsics.checkNotNullParameter(libraries, "libraries");
        Intrinsics.checkNotNullParameter(outputLibraryJsPath, "outputLibraryJsPath");
        for (String library : libraries) {
            File file2 = new File(library);
            boolean bl = file2.exists();
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string2 = "Library " + library + " not found";
                throw new AssertionError((Object)string2);
            }
            if (file2.isDirectory()) {
                INSTANCE.copyJsFilesFromDirectory(file2, outputLibraryJsPath, copySourceMap);
                continue;
            }
            INSTANCE.copyJsFilesFromZip(file2, outputLibraryJsPath, copySourceMap);
        }
    }

    public static /* synthetic */ void copyJsFilesFromLibraries$default(List list, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        JsLibraryUtils.copyJsFilesFromLibraries(list, string2, bl);
    }

    @JvmStatic
    public static final void traverseJsLibrary(@NotNull File lib, @NotNull Function1<? super JsLibrary, Unit> action) {
        block2: {
            File jsFile;
            block3: {
                block1: {
                    Intrinsics.checkNotNullParameter(lib, "lib");
                    Intrinsics.checkNotNullParameter(action, "action");
                    if (!lib.isDirectory()) break block1;
                    INSTANCE.traverseDirectory(lib, action);
                    break block2;
                }
                if (!FileUtil.isJarOrZip(lib)) break block3;
                INSTANCE.traverseArchive(lib, action);
                break block2;
            }
            String string2 = lib.getName();
            Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
            if (!StringsKt.endsWith$default(string2, ".js", false, 2, null)) break block2;
            String string3 = lib.getPath();
            Intrinsics.checkNotNullExpressionValue(string3, "getPath(...)");
            INSTANCE.runIfFileExists(lib, string3, action);
            File file2 = jsFile = FileUtilsKt.withReplacedExtensionOrNull(lib, ".meta.js", ".js");
            if (file2 != null) {
                String string4 = jsFile.getPath();
                Intrinsics.checkNotNullExpressionValue(string4, "getPath(...)");
                INSTANCE.runIfFileExists(file2, string4, action);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isZippedKlibInZip(File candidate2) {
        boolean manifestFound = false;
        boolean irFound = false;
        Closeable closeable = new ZipFile(candidate2);
        Throwable throwable = null;
        try {
            ZipFile it = (ZipFile)closeable;
            boolean bl = false;
            Enumeration<? extends ZipEntry> enumeration = it.entries();
            Intrinsics.checkNotNullExpressionValue(enumeration, "entries(...)");
            Iterator<? extends ZipEntry> iterator2 = CollectionsKt.iterator(enumeration);
            while (iterator2.hasNext()) {
                ZipEntry entry = iterator2.next();
                if (Intrinsics.areEqual(entry.getName(), "default/manifest")) {
                    manifestFound = true;
                }
                if (!Intrinsics.areEqual(entry.getName(), "default/ir/")) continue;
                irFound = true;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return manifestFound && irFound;
    }

    private final boolean isZippedKlib(File candidate2) {
        return Intrinsics.areEqual(FilesKt.getExtension(candidate2), "klib");
    }

    private final void runIfFileExists(File $this$runIfFileExists, String relativePath, Function1<? super JsLibrary, Unit> action) {
        if ($this$runIfFileExists.isFile()) {
            action.invoke(new JsLibrary(FilesKt.readText$default($this$runIfFileExists, null, 1, null), relativePath, this.contentIfExists(this.correspondingSourceMapFile($this$runIfFileExists)), $this$runIfFileExists));
        }
    }

    private final void copyJsFilesFromDirectory(File dir2, String outputLibraryJsPath, boolean copySourceMap) {
        this.traverseDirectory(dir2, arg_0 -> JsLibraryUtils.copyJsFilesFromDirectory$lambda$2(outputLibraryJsPath, copySourceMap, arg_0));
    }

    private final String contentIfExists(File $this$contentIfExists) {
        return $this$contentIfExists.exists() ? FilesKt.readText$default($this$contentIfExists, null, 1, null) : null;
    }

    private final File correspondingSourceMapFile(File $this$correspondingSourceMapFile) {
        return new File($this$correspondingSourceMapFile.getParentFile(), $this$correspondingSourceMapFile.getName() + ".map");
    }

    private final void processDirectory(File dir2, Function1<? super JsLibrary, Unit> action) {
        FileUtil.processFilesRecursively(dir2, arg_0 -> JsLibraryUtils.processDirectory$lambda$3(dir2, action, arg_0));
    }

    private final void traverseDirectory(File dir2, Function1<? super JsLibrary, Unit> action) {
        try {
            this.processDirectory(dir2, action);
        }
        catch (IOException ex) {
            LOG.error("Could not read files from directory " + dir2.getName() + ": " + ex.getMessage());
        }
    }

    private final void copyJsFilesFromZip(File file2, String outputLibraryJsPath, boolean copySourceMap) {
        this.traverseArchive(file2, arg_0 -> JsLibraryUtils.copyJsFilesFromZip$lambda$4(outputLibraryJsPath, copySourceMap, arg_0));
    }

    private final void copyLibrary(String outputPath, JsLibrary library, boolean copySourceMap) {
        block1: {
            File targetFile = new File(outputPath, library.getPath());
            targetFile.getParentFile().mkdirs();
            FilesKt.writeText$default(targetFile, library.getContent(), null, 2, null);
            if (!copySourceMap) break block1;
            String string2 = library.getSourceMapContent();
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                FilesKt.writeText$default(new File(targetFile.getParent(), targetFile.getName() + ".map"), it, null, 2, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void traverseArchive(File file2, Function1<? super JsLibrary, Unit> action) {
        ZipFile zipFile;
        try {
            zipFile = new ZipFile(file2.getPath());
        }
        catch (ZipException e) {
            throw new IOException("Failed to open zip file: " + file2, e);
        }
        try (ZipFile zipFile2 = zipFile;){
            void $this$forEach$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            String correspondingJsPath;
            Object entry;
            Enumeration<? extends ZipEntry> zipEntries = zipFile2.entries();
            List librariesWithoutSourceMaps = new ArrayList();
            Map possibleMapFiles = new LinkedHashMap();
            while (zipEntries.hasMoreElements()) {
                entry = zipEntries.nextElement();
                String entryName = ((ZipEntry)entry).getName();
                if (((ZipEntry)entry).isDirectory()) continue;
                Intrinsics.checkNotNull(entryName);
                if (StringsKt.endsWith$default(entryName, ".js", false, 2, null)) {
                    String relativePath;
                    if (this.getSuggestedPath(entryName) == null) continue;
                    InputStream stream = zipFile2.getInputStream((ZipEntry)entry);
                    Intrinsics.checkNotNull(stream);
                    InputStream inputStream = stream;
                    Charset charset = Charsets.UTF_8;
                    String content = TextStreamsKt.readText(new InputStreamReader(inputStream, charset));
                    ((Collection)librariesWithoutSourceMaps).add(new JsLibrary(content, relativePath, null, null));
                    continue;
                }
                if (!StringsKt.endsWith$default(entryName, ".js.map", false, 2, null)) continue;
                correspondingJsPath = StringsKt.removeSuffix(entryName, (CharSequence)".js.map") + ".js";
                possibleMapFiles.put(correspondingJsPath, entry);
            }
            entry = librariesWithoutSourceMaps;
            boolean $i$f$map = false;
            correspondingJsPath = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                JsLibrary jsLibrary;
                void it;
                JsLibrary jsLibrary2 = (JsLibrary)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                ZipEntry zipEntry = (ZipEntry)possibleMapFiles.get(it.getPath());
                if (zipEntry != null) {
                    InputStream stream = zipFile2.getInputStream(zipEntry);
                    Intrinsics.checkNotNull(stream);
                    InputStream inputStream = stream;
                    Charset charset = Charsets.UTF_8;
                    String content = TextStreamsKt.readText(new InputStreamReader(inputStream, charset));
                    jsLibrary = JsLibrary.copy$default((JsLibrary)it, null, null, content, null, 11, null);
                } else {
                    jsLibrary = it;
                }
                collection.add(jsLibrary);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                action.invoke((JsLibrary)element$iv);
            }
        }
    }

    private final String getSuggestedPath(String path) {
        String string2 = FileUtil.toSystemIndependentName(path);
        Intrinsics.checkNotNullExpressionValue(string2, "toSystemIndependentName(...)");
        String systemIndependentPath = string2;
        if (StringsKt.startsWith$default(systemIndependentPath, LibraryUtils.INSTANCE.getMETA_INF(), false, 2, null)) {
            if (StringsKt.startsWith$default(systemIndependentPath, META_INF_RESOURCES, false, 2, null)) {
                String string3 = path.substring(META_INF_RESOURCES.length());
                Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
                return string3;
            }
            return null;
        }
        return path;
    }

    private static final Unit copyJsFilesFromDirectory$lambda$2(String $outputLibraryJsPath, boolean $copySourceMap, JsLibrary it) {
        Intrinsics.checkNotNullParameter(it, "it");
        INSTANCE.copyLibrary($outputLibraryJsPath, it, $copySourceMap);
        return Unit.INSTANCE;
    }

    private static final boolean processDirectory$lambda$3(File $dir, Function1 $action, File file2) {
        String string2 = FileUtil.getRelativePath($dir, file2);
        if (string2 == null) {
            throw new IllegalArgumentException("relativePath should not be null " + $dir + ' ' + file2);
        }
        String relativePath = string2;
        if (StringsKt.endsWith$default(relativePath, ".js", false, 2, null)) {
            String string3 = INSTANCE.getSuggestedPath(relativePath);
            if (string3 == null) {
                return true;
            }
            String suggestedRelativePath = string3;
            Intrinsics.checkNotNull(file2);
            INSTANCE.runIfFileExists(file2, suggestedRelativePath, $action);
        }
        return true;
    }

    private static final Unit copyJsFilesFromZip$lambda$4(String $outputLibraryJsPath, boolean $copySourceMap, JsLibrary it) {
        Intrinsics.checkNotNullParameter(it, "it");
        INSTANCE.copyLibrary($outputLibraryJsPath, it, $copySourceMap);
        return Unit.INSTANCE;
    }

    static {
        Logger logger = Logger.getInstance(JsLibraryUtils.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
        LOG = logger;
        META_INF_RESOURCES = LibraryUtils.INSTANCE.getMETA_INF() + "resources/";
    }
}

