/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.builtins;

import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.builtins.BuiltInsBinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.serialization.AnnotationSerializer;
import org.jetbrains.kotlin.serialization.KotlinSerializerExtensionBase;
import org.jetbrains.kotlin.serialization.StringTableImpl;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.error.ErrorType;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u0018\u001a\u00020\u0006*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/serialization/builtins/K1BuiltInsSerializerExtension;", "Lorg/jetbrains/kotlin/serialization/KotlinSerializerExtensionBase;", "<init>", "()V", "shortNameToClassId", "", "", "ignoredAnnotationShortNames", "", "createAnnotationSerializer", "Lorg/jetbrains/kotlin/serialization/AnnotationSerializer;", "metadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "getMetadataVersion", "()Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "shouldUseTypeTable", "", "serializeErrorType", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "builder", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type$Builder;", "resolveUnresolvedType", "presentableName", "getPresentableName", "(Lorg/jetbrains/kotlin/types/KotlinType;)Ljava/lang/String;", "cli"})
public final class K1BuiltInsSerializerExtension
extends KotlinSerializerExtensionBase {
    @NotNull
    private final Map<String, String> shortNameToClassId;
    @NotNull
    private final Set<String> ignoredAnnotationShortNames;

    public K1BuiltInsSerializerExtension() {
        super(BuiltInSerializerProtocol.INSTANCE);
        Object[] objectArray = new Pair[]{TuplesKt.to("IntRange", "kotlin/ranges/IntRange"), TuplesKt.to("LongRange", "kotlin/ranges/LongRange"), TuplesKt.to("CharRange", "kotlin/ranges/CharRange"), TuplesKt.to("ExperimentalStdlibApi", "kotlin/ExperimentalStdlibApi")};
        this.shortNameToClassId = MapsKt.mapOf(objectArray);
        objectArray = new String[]{"JvmStatic", "JvmField", "OptIn"};
        this.ignoredAnnotationShortNames = SetsKt.setOf(objectArray);
    }

    @Override
    @NotNull
    protected AnnotationSerializer createAnnotationSerializer() {
        StringTableImpl stringTableImpl = this.getStringTable();
        return new AnnotationSerializer(this, stringTableImpl){
            final /* synthetic */ K1BuiltInsSerializerExtension this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            protected ClassId getAnnotationClassId(AnnotationDescriptor annotation) {
                Intrinsics.checkNotNullParameter(annotation, "annotation");
                KotlinType type2 = annotation.getType();
                ClassDescriptor classDescriptor = DescriptorUtilsKt.getAnnotationClass(annotation);
                if (classDescriptor == null) {
                    throw new IllegalStateException(("Annotation type is not a class: " + type2).toString());
                }
                ClassDescriptor annotationClass = classDescriptor;
                if (ErrorUtils.isError(annotationClass)) {
                    if (K1BuiltInsSerializerExtension.access$getIgnoredAnnotationShortNames$p(this.this$0).contains(K1BuiltInsSerializerExtension.access$getPresentableName(this.this$0, type2))) {
                        return null;
                    }
                    return ClassId.Companion.fromString$default(ClassId.Companion, K1BuiltInsSerializerExtension.access$resolveUnresolvedType(this.this$0, type2), false, 2, null);
                }
                return DescriptorUtilsKt.getClassId((ClassifierDescriptor)annotationClass);
            }
        };
    }

    @Override
    @NotNull
    public BinaryVersion getMetadataVersion() {
        return BuiltInsBinaryVersion.INSTANCE;
    }

    @Override
    public boolean shouldUseTypeTable() {
        return true;
    }

    @Override
    public void serializeErrorType(@NotNull KotlinType type2, @NotNull ProtoBuf.Type.Builder builder) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(builder, "builder");
        String className = this.resolveUnresolvedType(type2);
        builder.setClassName(this.getStringTable().getQualifiedClassNameIndex(className, false));
    }

    private final String resolveUnresolvedType(KotlinType type2) {
        String string2 = this.shortNameToClassId.get(this.getPresentableName(type2));
        if (string2 == null) {
            throw new UnsupportedOperationException("Unsupported unresolved type: " + type2.unwrap() + ".\nConsider adding it to `BuiltInsSerializerExtension.shortNameToClassId`.");
        }
        return string2;
    }

    private final String getPresentableName(KotlinType $this$presentableName) {
        UnwrappedType unwrapped = $this$presentableName.unwrap();
        if (!TypeUtilsKt.isUnresolvedType(unwrapped)) {
            throw new UnsupportedOperationException("Error types which are not unresolved type instances are not supported here: " + unwrapped);
        }
        return StringsKt.removePrefix(((ErrorType)unwrapped).getDebugMessage(), (CharSequence)"Unresolved type for ");
    }

    public static final /* synthetic */ Set access$getIgnoredAnnotationShortNames$p(K1BuiltInsSerializerExtension $this) {
        return $this.ignoredAnnotationShortNames;
    }

    public static final /* synthetic */ String access$getPresentableName(K1BuiltInsSerializerExtension $this, KotlinType $receiver) {
        return $this.getPresentableName($receiver);
    }

    public static final /* synthetic */ String access$resolveUnresolvedType(K1BuiltInsSerializerExtension $this, KotlinType type2) {
        return $this.resolveUnresolvedType(type2);
    }
}

