/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.core.JavaPsiBundle;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.SubtypingConstraint;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class StrictSubtypingConstraint
implements ConstraintFormula {
    private PsiType myS;
    private PsiType myT;
    private final boolean myCapture;

    public StrictSubtypingConstraint(PsiType t, PsiType s) {
        this(t, s, true);
    }

    public StrictSubtypingConstraint(PsiType t, PsiType s, boolean capture) {
        this.myT = t;
        this.myS = s;
        this.myCapture = capture;
    }

    @Override
    public void apply(PsiSubstitutor substitutor2, boolean cache2) {
        this.myT = substitutor2.substitute(this.myT);
        this.myS = substitutor2.substitute(this.myS);
    }

    @Override
    public boolean reduce(InferenceSession session2, List<? super ConstraintFormula> constraints) {
        HashSet<InferenceVariable> dependencies = new HashSet<InferenceVariable>();
        boolean reduceResult = this.doReduce(session2, dependencies, constraints);
        if (!reduceResult) {
            session2.registerIncompatibleErrorMessage(dependencies, JavaPsiBundle.message("type.conforms.to.constraint", session2.getPresentableText(this.myS), session2.getPresentableText(this.myT)));
        }
        return reduceResult;
    }

    private boolean doReduce(InferenceSession session2, Set<? super InferenceVariable> dependencies, List<? super ConstraintFormula> constraints) {
        PsiType lowerBound;
        if (!session2.collectDependencies(this.myS, dependencies) && !session2.collectDependencies(this.myT, dependencies)) {
            if (this.myT == null) {
                return this.myS == null || this.myS.equalsToText("java.lang.Object");
            }
            if (this.myS == null) {
                return true;
            }
            return TypeConversionUtil.isAssignable(this.myT, this.myS);
        }
        if (PsiTypes.nullType().equals(this.myT) || this.myT == null) {
            return false;
        }
        if (PsiTypes.nullType().equals(this.myS) || this.myS == null || this.myT.equalsToText("java.lang.Object")) {
            return true;
        }
        if (PsiTypes.voidType().equals(this.myS) ^ PsiTypes.voidType().equals(this.myT)) {
            return false;
        }
        InferenceVariable inferenceVariable = session2.getInferenceVariable(this.myS);
        if (inferenceVariable != null) {
            InferenceVariable.addBound(this.myS, this.myT, InferenceBound.UPPER, session2);
            return true;
        }
        inferenceVariable = session2.getInferenceVariable(this.myT);
        if (inferenceVariable != null) {
            InferenceVariable.addBound(this.myT, this.myS, InferenceBound.LOWER, session2);
            return true;
        }
        if (this.myT instanceof PsiArrayType) {
            PsiType upperBound;
            PsiType sType = this.myS;
            if (this.myS instanceof PsiCapturedWildcardType && (upperBound = ((PsiCapturedWildcardType)this.myS).getUpperBound()) instanceof PsiArrayType) {
                sType = upperBound;
            }
            if (!(sType instanceof PsiArrayType)) {
                return false;
            }
            PsiType tComponentType = ((PsiArrayType)this.myT).getComponentType();
            PsiType sComponentType = ((PsiArrayType)sType).getComponentType();
            if (!(tComponentType instanceof PsiPrimitiveType) && !(sComponentType instanceof PsiPrimitiveType)) {
                constraints.add(new StrictSubtypingConstraint(tComponentType, sComponentType, this.myCapture));
                return true;
            }
            return sComponentType instanceof PsiPrimitiveType && sComponentType.equals(tComponentType);
        }
        if (this.myT instanceof PsiClassType) {
            PsiClassType.ClassResolveResult TResult = ((PsiClassType)this.myT).resolveGenerics();
            PsiClass CClass = TResult.getElement();
            if (CClass != null) {
                if (CClass instanceof PsiTypeParameter) {
                    if (this.myS instanceof PsiIntersectionType && ArrayUtil.contains(this.myT, ((PsiIntersectionType)this.myS).getConjuncts())) {
                        return true;
                    }
                    PsiType lowerBound2 = TypeConversionUtil.getInferredLowerBoundForSynthetic((PsiTypeParameter)CClass);
                    if (lowerBound2 != null) {
                        constraints.add(new StrictSubtypingConstraint(lowerBound2, this.myS, this.myCapture));
                        return true;
                    }
                    return false;
                }
                if (this.myS instanceof PsiArrayType) {
                    return this.myT.isAssignableFrom(this.myS);
                }
                PsiClassType sType = StrictSubtypingConstraint.getSubclassType(CClass, this.myS, this.myCapture);
                if (sType == null) {
                    return false;
                }
                PsiClassType.ClassResolveResult SResult = sType.resolveGenerics();
                PsiClass SClass = SResult.getElement();
                if (SClass == null) {
                    return false;
                }
                if (((PsiClassType)this.myT).isRaw() || this.myCapture && sType.isRaw()) {
                    return InheritanceUtil.isInheritorOrSelf(SClass, CClass, true);
                }
                PsiSubstitutor substitutor2 = SResult.getSubstitutor();
                HashMap<PsiTypeParameter, PsiType> map = new HashMap<PsiTypeParameter, PsiType>();
                for (PsiTypeParameter typeParameter : SClass.getTypeParameters()) {
                    map.put(typeParameter, substitutor2.substituteWithBoundsPromotion(typeParameter));
                }
                substitutor2 = substitutor2.putAll(map);
                PsiSubstitutor tSubstitutor = TResult.getSubstitutor();
                PsiSubstitutor sSubstitutor = TypeConversionUtil.getClassSubstitutor(CClass, SClass, substitutor2);
                if (sSubstitutor != null) {
                    for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(CClass)) {
                        PsiType sSubstituted;
                        PsiType tSubstituted = tSubstitutor.substitute(parameter);
                        if (tSubstituted == null ^ (sSubstituted = sSubstitutor.substitute(parameter)) == null) {
                            return false;
                        }
                        constraints.add(new SubtypingConstraint(tSubstituted, sSubstituted));
                    }
                    return true;
                }
            }
            return false;
        }
        if (this.myT instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)this.myT).getConjuncts()) {
                constraints.add(new StrictSubtypingConstraint(conjunct, this.myS, this.myCapture));
            }
            return true;
        }
        if (this.myT instanceof PsiCapturedWildcardType && (lowerBound = ((PsiCapturedWildcardType)this.myT).getLowerBound()) != PsiTypes.nullType()) {
            constraints.add(new StrictSubtypingConstraint(lowerBound, this.myS, this.myCapture));
        }
        return true;
    }

    public static PsiClassType getSubclassType(PsiClass containingClass, PsiType sType, boolean capture) {
        if (sType instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)sType).getConjuncts()) {
                PsiClassType.ClassResolveResult conjunctResult;
                if (!(conjunct instanceof PsiClassType) || !InheritanceUtil.isInheritorOrSelf((conjunctResult = ((PsiClassType)conjunct).resolveGenerics()).getElement(), containingClass, true)) continue;
                return (PsiClassType)conjunct;
            }
        } else {
            if (sType instanceof PsiClassType) {
                return (PsiClassType)sType;
            }
            if (sType instanceof PsiCapturedWildcardType) {
                PsiType upperBound = ((PsiCapturedWildcardType)sType).getUpperBound(capture);
                if (upperBound instanceof PsiClassType) {
                    return (PsiClassType)upperBound;
                }
                if (upperBound instanceof PsiIntersectionType) {
                    return StrictSubtypingConstraint.getSubclassType(containingClass, upperBound, capture);
                }
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StrictSubtypingConstraint that = (StrictSubtypingConstraint)o;
        if (this.myS != null ? !this.myS.equals(that.myS) : that.myS != null) {
            return false;
        }
        return !(this.myT != null ? !this.myT.equals(that.myT) : that.myT != null);
    }

    public int hashCode() {
        int result2 = this.myS != null ? this.myS.hashCode() : 0;
        result2 = 31 * result2 + (this.myT != null ? this.myT.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return this.myT.getPresentableText() + " < " + this.myS.getPresentableText();
    }
}

