/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.HashMultimap;
import com.intellij.psi.PsiElement;
import com.intellij.util.AstLoadingFilter;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.contracts.description.ContractProviderKey;
import org.jetbrains.kotlin.contracts.description.LazyContractProvider;
import org.jetbrains.kotlin.contracts.parsing.ContractParsingServices;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationSplitter;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ClassConstructorDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtContextReceiver;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtPureElement;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.FunctionDescriptorResolver;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.OverloadChecker;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.DslMarkerUtils;
import org.jetbrains.kotlin.resolve.calls.components.InferenceSession;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.util.FunctionTypeResolveUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.TraceBasedLocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.error.ErrorTypeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001ZBW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J8\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%J@\u0010&\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010'\u001a\u00020(2\b\u0010$\u001a\u0004\u0018\u00010%Jn\u0010\u0018\u001a\u00020\u00192*\u0010)\u001a&\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020/0*2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010'\u001a\u00020(2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J:\u00100\u001a\u0002012\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00102\u001a\u00020/2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002JH\u00103\u001a\u0002012\u0006\u00104\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u0002052\u0006\u00102\u001a\u00020/2\u0006\u0010 \u001a\u00020!2\u0006\u0010'\u001a\u00020(2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%J<\u00106\u001a\u0004\u0018\u0001072\u0006\u00102\u001a\u00020/2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001e\u001a\u0002052\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J@\u00108\u001a\b\u0012\u0004\u0012\u00020:092\u0006\u0010\u001e\u001a\u0002052\u0006\u00102\u001a\u00020/2\u0006\u0010;\u001a\u00020<2\u0006\u0010 \u001a\u00020!2\u0006\u0010'\u001a\u00020(2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J\f\u0010=\u001a\u00020(*\u00020(H\u0002J\f\u0010>\u001a\u00020?*\u00020(H\u0002J\u000e\u0010@\u001a\u0004\u0018\u00010(*\u00020(H\u0002J\u0012\u0010A\u001a\b\u0012\u0004\u0012\u00020B09*\u00020(H\u0002J\u001c\u0010C\u001a\n\u0012\u0004\u0012\u00020:\u0018\u000109*\u00020(2\u0006\u0010D\u001a\u00020EH\u0002J:\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020K2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010$\u001a\u0004\u0018\u00010%J8\u0010L\u001a\u00020G2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010H\u001a\u00020I2\u0006\u0010M\u001a\u00020N2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010$\u001a\u0004\u0018\u00010%JZ\u0010O\u001a\u00020G2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010H\u001a\u00020I2\u0006\u0010P\u001a\u00020?2\b\u0010Q\u001a\u0004\u0018\u00010R2\u0006\u0010S\u001a\u00020T2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020V092\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010$\u001a\u0004\u0018\u00010%H\u0002JN\u0010W\u001a\b\u0012\u0004\u0012\u00020:092\u0006\u00102\u001a\u00020E2\u0006\u0010X\u001a\u00020<2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020V092\u0006\u0010 \u001a\u00020!2\u000e\u0010Y\u001a\n\u0012\u0004\u0012\u00020(\u0018\u0001092\b\u0010$\u001a\u0004\u0018\u00010%H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Lorg/jetbrains/kotlin/resolve/FunctionDescriptorResolver;", "", "typeResolver", "Lorg/jetbrains/kotlin/resolve/TypeResolver;", "descriptorResolver", "Lorg/jetbrains/kotlin/resolve/DescriptorResolver;", "annotationResolver", "Lorg/jetbrains/kotlin/resolve/AnnotationResolver;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "modifiersChecker", "Lorg/jetbrains/kotlin/resolve/ModifiersChecker;", "overloadChecker", "Lorg/jetbrains/kotlin/resolve/OverloadChecker;", "contractParsingServices", "Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingServices;", "expressionTypingServices", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "<init>", "(Lorg/jetbrains/kotlin/resolve/TypeResolver;Lorg/jetbrains/kotlin/resolve/DescriptorResolver;Lorg/jetbrains/kotlin/resolve/AnnotationResolver;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lorg/jetbrains/kotlin/resolve/ModifiersChecker;Lorg/jetbrains/kotlin/resolve/OverloadChecker;Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingServices;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/storage/StorageManager;)V", "resolveFunctionDescriptor", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "containingDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "inferenceSession", "Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;", "resolveFunctionExpressionDescriptor", "expectedFunctionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "functionConstructor", "Lkotlin/Function5;", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor$Kind;", "Lorg/jetbrains/kotlin/descriptors/SourceElement;", "Lorg/jetbrains/kotlin/descriptors/impl/SimpleFunctionDescriptorImpl;", "initializeFunctionReturnTypeBasedOnFunctionBody", "", "functionDescriptor", "initializeFunctionDescriptorAndExplicitReturnType", "container", "Lorg/jetbrains/kotlin/psi/KtFunction;", "getContractProvider", "Lorg/jetbrains/kotlin/contracts/description/LazyContractProvider;", "createValueParameterDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "innerScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalWritableScope;", "removeParameterNameAnnotation", "functionTypeExpected", "", "getReceiverType", "getContextReceiversTypes", "Lorg/jetbrains/kotlin/resolve/FunctionDescriptorResolver$ContextReceiverTypeWithLabel;", "getValueParameters", "owner", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "resolvePrimaryConstructorDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/ClassConstructorDescriptorImpl;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "classElement", "Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;", "resolveSecondaryConstructorDescriptor", "constructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "createConstructorDescriptor", "isPrimary", "modifierList", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "declarationToTrace", "Lorg/jetbrains/kotlin/psi/KtPureElement;", "valueParameters", "Lorg/jetbrains/kotlin/psi/KtParameter;", "resolveValueParameters", "parameterScope", "expectedParameterTypes", "ContextReceiverTypeWithLabel", "frontend"})
@SourceDebugExtension(value={"SMAP\nFunctionDescriptorResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionDescriptorResolver.kt\norg/jetbrains/kotlin/resolve/FunctionDescriptorResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,534:1\n1617#2,9:535\n1869#2:544\n1870#2:546\n1626#2:547\n1583#2,11:549\n1878#2,2:560\n1880#2:563\n1594#2:564\n1869#2,2:565\n1563#2:568\n1634#2,3:569\n774#2:572\n865#2,2:573\n1563#2:575\n1634#2,3:576\n1#3:545\n1#3:548\n1#3:562\n1#3:567\n*S KotlinDebug\n*F\n+ 1 FunctionDescriptorResolver.kt\norg/jetbrains/kotlin/resolve/FunctionDescriptorResolver\n*L\n206#1:535,9\n206#1:544\n206#1:546\n206#1:547\n243#1:549,11\n243#1:560,2\n243#1:563\n243#1:564\n262#1:565,2\n330#1:568\n330#1:569,3\n364#1:572\n364#1:573,2\n373#1:575\n373#1:576,3\n206#1:545\n243#1:562\n*E\n"})
public final class FunctionDescriptorResolver {
    @NotNull
    private final TypeResolver typeResolver;
    @NotNull
    private final DescriptorResolver descriptorResolver;
    @NotNull
    private final AnnotationResolver annotationResolver;
    @NotNull
    private final KotlinBuiltIns builtIns;
    @NotNull
    private final ModifiersChecker modifiersChecker;
    @NotNull
    private final OverloadChecker overloadChecker;
    @NotNull
    private final ContractParsingServices contractParsingServices;
    @NotNull
    private final ExpressionTypingServices expressionTypingServices;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final StorageManager storageManager;

    public FunctionDescriptorResolver(@NotNull TypeResolver typeResolver, @NotNull DescriptorResolver descriptorResolver, @NotNull AnnotationResolver annotationResolver, @NotNull KotlinBuiltIns builtIns, @NotNull ModifiersChecker modifiersChecker, @NotNull OverloadChecker overloadChecker, @NotNull ContractParsingServices contractParsingServices, @NotNull ExpressionTypingServices expressionTypingServices, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull StorageManager storageManager) {
        Intrinsics.checkNotNullParameter(typeResolver, "typeResolver");
        Intrinsics.checkNotNullParameter(descriptorResolver, "descriptorResolver");
        Intrinsics.checkNotNullParameter(annotationResolver, "annotationResolver");
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        Intrinsics.checkNotNullParameter(modifiersChecker, "modifiersChecker");
        Intrinsics.checkNotNullParameter(overloadChecker, "overloadChecker");
        Intrinsics.checkNotNullParameter(contractParsingServices, "contractParsingServices");
        Intrinsics.checkNotNullParameter(expressionTypingServices, "expressionTypingServices");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(storageManager, "storageManager");
        this.typeResolver = typeResolver;
        this.descriptorResolver = descriptorResolver;
        this.annotationResolver = annotationResolver;
        this.builtIns = builtIns;
        this.modifiersChecker = modifiersChecker;
        this.overloadChecker = overloadChecker;
        this.contractParsingServices = contractParsingServices;
        this.expressionTypingServices = expressionTypingServices;
        this.languageVersionSettings = languageVersionSettings;
        this.storageManager = storageManager;
    }

    @NotNull
    public final SimpleFunctionDescriptor resolveFunctionDescriptor(@NotNull DeclarationDescriptor containingDescriptor, @NotNull LexicalScope scope2, @NotNull KtNamedFunction function2, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo, @Nullable InferenceSession inferenceSession) {
        Intrinsics.checkNotNullParameter(containingDescriptor, "containingDescriptor");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(dataFlowInfo, "dataFlowInfo");
        if (function2.getName() == null) {
            trace.report(Errors.FUNCTION_DECLARATION_WITH_NO_NAME.on((KtFunction)((PsiElement)function2)));
        }
        Function5 function5 = resolveFunctionDescriptor.1.INSTANCE;
        SimpleType simpleType = TypeUtils.NO_EXPECTED_TYPE;
        Intrinsics.checkNotNullExpressionValue(simpleType, "NO_EXPECTED_TYPE");
        return this.resolveFunctionDescriptor(function5, containingDescriptor, scope2, function2, trace, dataFlowInfo, simpleType, inferenceSession);
    }

    @NotNull
    public final SimpleFunctionDescriptor resolveFunctionExpressionDescriptor(@NotNull DeclarationDescriptor containingDescriptor, @NotNull LexicalScope scope2, @NotNull KtNamedFunction function2, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo, @NotNull KotlinType expectedFunctionType, @Nullable InferenceSession inferenceSession) {
        Intrinsics.checkNotNullParameter(containingDescriptor, "containingDescriptor");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(dataFlowInfo, "dataFlowInfo");
        Intrinsics.checkNotNullParameter(expectedFunctionType, "expectedFunctionType");
        return this.resolveFunctionDescriptor(resolveFunctionExpressionDescriptor.1.INSTANCE, containingDescriptor, scope2, function2, trace, dataFlowInfo, expectedFunctionType, inferenceSession);
    }

    private final SimpleFunctionDescriptor resolveFunctionDescriptor(Function5<? super DeclarationDescriptor, ? super Annotations, ? super Name, ? super CallableMemberDescriptor.Kind, ? super SourceElement, ? extends SimpleFunctionDescriptorImpl> functionConstructor, DeclarationDescriptor containingDescriptor, LexicalScope scope2, KtNamedFunction function2, BindingTrace trace, DataFlowInfo dataFlowInfo, KotlinType expectedFunctionType, InferenceSession inferenceSession) {
        Annotations annotations2 = this.annotationResolver.resolveAnnotationsWithoutArguments(scope2, function2.getModifierList(), trace);
        Name name2 = function2.getNameAsSafeName();
        Intrinsics.checkNotNullExpressionValue(name2, "getNameAsSafeName(...)");
        SimpleFunctionDescriptorImpl functionDescriptor = functionConstructor.invoke(containingDescriptor, annotations2, name2, CallableMemberDescriptor.Kind.DECLARATION, KotlinSourceElementKt.toSourceElement(function2));
        this.initializeFunctionDescriptorAndExplicitReturnType(containingDescriptor, scope2, function2, functionDescriptor, trace, expectedFunctionType, dataFlowInfo, inferenceSession);
        this.initializeFunctionReturnTypeBasedOnFunctionBody(scope2, function2, functionDescriptor, trace, dataFlowInfo, inferenceSession);
        BindingContextUtils.recordFunctionDeclarationToDescriptor(trace, function2, functionDescriptor);
        return functionDescriptor;
    }

    private final void initializeFunctionReturnTypeBasedOnFunctionBody(LexicalScope scope2, KtNamedFunction function2, SimpleFunctionDescriptorImpl functionDescriptor, BindingTrace trace, DataFlowInfo dataFlowInfo, InferenceSession inferenceSession) {
        KotlinType kotlinType;
        boolean bl;
        if (functionDescriptor.getReturnType() != null) {
            return;
        }
        boolean bl2 = bl = function2.getTypeReference() == null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Return type must be initialized early for function: " + function2.getText() + ", at: " + PsiDiagnosticUtils.atLocation(function2);
            throw new AssertionError((Object)string);
        }
        if (function2.hasBlockBody()) {
            kotlinType = this.builtIns.getUnitType();
        } else if (function2.hasBody()) {
            kotlinType = this.descriptorResolver.inferReturnTypeFromExpressionBody(trace, scope2, dataFlowInfo, function2, functionDescriptor, inferenceSession);
        } else {
            String[] stringArray = new String[1];
            Intrinsics.checkNotNullExpressionValue(functionDescriptor.getName().asString(), "asString(...)");
            kotlinType = ErrorUtils.createErrorType(ErrorTypeKind.RETURN_TYPE, stringArray);
        }
        KotlinType kotlinType2 = kotlinType;
        Intrinsics.checkNotNull(kotlinType2);
        KotlinType inferredReturnType = kotlinType2;
        functionDescriptor.setReturnType(inferredReturnType);
    }

    /*
     * WARNING - void declaration
     */
    public final void initializeFunctionDescriptorAndExplicitReturnType(@NotNull DeclarationDescriptor container, @NotNull LexicalScope scope2, @NotNull KtFunction function2, @NotNull SimpleFunctionDescriptorImpl functionDescriptor, @NotNull BindingTrace trace, @NotNull KotlinType expectedFunctionType, @NotNull DataFlowInfo dataFlowInfo, @Nullable InferenceSession inferenceSession) {
        KotlinType it;
        void $this$mapIndexedNotNullTo$iv$iv;
        ReceiverParameterDescriptor receiverParameterDescriptor;
        Map $i$f$forEach2;
        KotlinType kotlinType;
        Object it2;
        List list;
        Intrinsics.checkNotNullParameter(container, "container");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(functionDescriptor, "functionDescriptor");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(expectedFunctionType, "expectedFunctionType");
        Intrinsics.checkNotNullParameter(dataFlowInfo, "dataFlowInfo");
        LexicalWritableScope headerScope = new LexicalWritableScope(scope2, functionDescriptor, true, new TraceBasedLocalRedeclarationChecker(trace, this.overloadChecker), LexicalScopeKind.FUNCTION_HEADER);
        List<TypeParameterDescriptorImpl> typeParameterDescriptors = this.descriptorResolver.resolveTypeParametersForDescriptor(functionDescriptor, headerScope, scope2, function2.getTypeParameters(), trace);
        this.descriptorResolver.resolveGenericBounds(function2, functionDescriptor, headerScope, typeParameterDescriptors, trace);
        KtTypeReference receiverTypeRef = function2.getReceiverTypeReference();
        KotlinType receiverType = receiverTypeRef != null ? this.typeResolver.resolveType(headerScope, receiverTypeRef, trace, true) : (function2 instanceof KtFunctionLiteral ? this.getReceiverType(expectedFunctionType) : null);
        List<KtContextReceiver> list2 = function2.getContextReceivers();
        Intrinsics.checkNotNullExpressionValue(list2, "getContextReceivers(...)");
        List<KtContextReceiver> contextReceivers = list2;
        if (function2 instanceof KtFunctionLiteral) {
            list = this.getContextReceiversTypes(expectedFunctionType);
        } else {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = contextReceivers;
            boolean $i$f$mapNotNull = false;
            void var17_17 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                ContextReceiverTypeWithLabel contextReceiverTypeWithLabel;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                it2 = (KtContextReceiver)element$iv$iv;
                boolean bl2 = false;
                if (((KtContextReceiver)it2).typeReference() == null) {
                    contextReceiverTypeWithLabel = null;
                } else {
                    KtTypeReference typeReference;
                    KotlinType type = this.typeResolver.resolveType(headerScope, typeReference, trace, true);
                    contextReceiverTypeWithLabel = new ContextReceiverTypeWithLabel(type, ((KtContextReceiver)it2).labelNameAsName());
                }
                if (contextReceiverTypeWithLabel == null) continue;
                ContextReceiverTypeWithLabel it$iv$iv = contextReceiverTypeWithLabel;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        List contextReceiverTypes = list;
        List<ValueParameterDescriptor> valueParameterDescriptors = this.createValueParameterDescriptors(function2, functionDescriptor, headerScope, trace, expectedFunctionType, inferenceSession);
        headerScope.freeze();
        KtTypeReference ktTypeReference = function2.getTypeReference();
        if (ktTypeReference != null) {
            KtTypeReference it3 = ktTypeReference;
            boolean bl = false;
            kotlinType = this.typeResolver.resolveType(headerScope, it3, trace, true);
        } else {
            kotlinType = null;
        }
        KotlinType returnType = kotlinType;
        DescriptorVisibility descriptorVisibility = ModifiersChecker.resolveVisibilityFromModifiers(function2, DescriptorResolver.getDefaultVisibility(function2, container));
        Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "resolveVisibilityFromModifiers(...)");
        DescriptorVisibility visibility = descriptorVisibility;
        Modality modality = ModifiersChecker.resolveMemberModalityFromModifiers(function2, DescriptorResolver.getDefaultModality(container, visibility, function2.hasBody()), trace.getBindingContext(), container);
        Intrinsics.checkNotNullExpressionValue((Object)modality, "resolveMemberModalityFromModifiers(...)");
        Modality modality2 = modality;
        LazyContractProvider contractProvider = this.getContractProvider(functionDescriptor, trace, scope2, dataFlowInfo, function2, inferenceSession);
        Map $this$initializeFunctionDescriptorAndExplicitReturnType_u24lambda_u243 = $i$f$forEach2 = (Map)new LinkedHashMap();
        boolean bl = false;
        if (contractProvider != null) {
            $this$initializeFunctionDescriptorAndExplicitReturnType_u24lambda_u243.put(ContractProviderKey.INSTANCE, contractProvider);
        }
        if (receiverType != null && this.functionTypeExpected(expectedFunctionType) && !expectedFunctionType.getAnnotations().isEmpty()) {
            $this$initializeFunctionDescriptorAndExplicitReturnType_u24lambda_u243.put(DslMarkerUtils.FunctionTypeAnnotationsKey.INSTANCE, expectedFunctionType.getAnnotations());
        }
        Map userData = $i$f$forEach2;
        KotlinType kotlinType2 = receiverType;
        if (kotlinType2 != null) {
            KotlinType it4 = kotlinType2;
            boolean bl4 = false;
            Annotations annotations2 = it4.getAnnotations();
            EnumSet<Enum> enumSet = EnumSet.of((Enum)AnnotationUseSiteTarget.RECEIVER);
            Intrinsics.checkNotNullExpressionValue(enumSet, "of(...)");
            AnnotationSplitter splitter = new AnnotationSplitter(this.storageManager, annotations2, (Set<? extends AnnotationUseSiteTarget>)enumSet);
            receiverParameterDescriptor = DescriptorFactory.createExtensionReceiverParameterForCallable(functionDescriptor, it4, splitter.getAnnotationsForTarget(AnnotationUseSiteTarget.RECEIVER));
        } else {
            receiverParameterDescriptor = null;
        }
        ReceiverParameterDescriptor extensionReceiver = receiverParameterDescriptor;
        Iterable $this$mapIndexedNotNull$iv = contextReceiverTypes;
        boolean $i$f$mapIndexedNotNull2 = false;
        Iterable splitter = $this$mapIndexedNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            ReceiverParameterDescriptor it$iv$iv;
            void contextReceiver;
            void element$iv$iv;
            int n2;
            if ((n2 = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t2 = item$iv$iv$iv;
            int index$iv$iv = n2;
            boolean bl5 = false;
            ContextReceiverTypeWithLabel contextReceiverTypeWithLabel = (ContextReceiverTypeWithLabel)element$iv$iv;
            int index = index$iv$iv;
            boolean bl6 = false;
            Annotations annotations3 = contextReceiver.getType().getAnnotations();
            EnumSet<Enum> enumSet = EnumSet.of((Enum)AnnotationUseSiteTarget.RECEIVER);
            Intrinsics.checkNotNullExpressionValue(enumSet, "of(...)");
            AnnotationSplitter splitter2 = new AnnotationSplitter(this.storageManager, annotations3, (Set<? extends AnnotationUseSiteTarget>)enumSet);
            if (DescriptorFactory.createContextReceiverParameterForCallable(functionDescriptor, contextReceiver.getType(), contextReceiver.getLabel(), splitter2.getAnnotationsForTarget(AnnotationUseSiteTarget.RECEIVER), index) == null) continue;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List contextReceiverDescriptors = (List)destination$iv$iv;
        if (this.languageVersionSettings.supportsFeature(LanguageFeature.ContextReceivers)) {
            void $this$forEach$iv;
            HashMultimap labelNameToReceiverMap = HashMultimap.create();
            if (receiverTypeRef != null && extensionReceiver != null) {
                String string = receiverTypeRef.nameForReceiverLabel();
                if (string != null) {
                    it2 = string;
                    boolean bl8 = false;
                    labelNameToReceiverMap.put(it2, extensionReceiver);
                }
            }
            Iterable $i$f$mapIndexedNotNull2 = CollectionsKt.reversed(CollectionsKt.zip((Iterable)contextReceiverDescriptors, RangesKt.until(0, contextReceivers.size())));
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv) {
                String it5;
                Pair pair = (Pair)element$iv;
                boolean bl9 = false;
                ReceiverParameterDescriptor contextReceiverDescriptor = (ReceiverParameterDescriptor)pair.component1();
                int i2 = ((Number)pair.component2()).intValue();
                if (contextReceivers.get(i2).name() == null) continue;
                boolean bl10 = false;
                labelNameToReceiverMap.put(it5, contextReceiverDescriptor);
            }
            trace.record(BindingContext.DESCRIPTOR_TO_CONTEXT_RECEIVER_MAP, functionDescriptor, labelNameToReceiverMap);
        }
        Map map = userData;
        Map $this$forEach$iv = map;
        DescriptorVisibility descriptorVisibility2 = visibility;
        Modality modality3 = modality2;
        KotlinType kotlinType3 = returnType;
        List<ValueParameterDescriptor> list3 = valueParameterDescriptors;
        List<TypeParameterDescriptorImpl> list4 = typeParameterDescriptors;
        List list5 = contextReceiverDescriptors;
        ReceiverParameterDescriptor receiverParameterDescriptor2 = DescriptorUtils.getDispatchReceiverParameterIfNeeded(container);
        ReceiverParameterDescriptor receiverParameterDescriptor3 = extensionReceiver;
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = functionDescriptor;
        boolean bl11 = false;
        boolean bl12 = !it.isEmpty();
        simpleFunctionDescriptorImpl.initialize(receiverParameterDescriptor3, receiverParameterDescriptor2, list5, (List<? extends TypeParameterDescriptor>)list4, list3, kotlinType3, modality3, descriptorVisibility2, (Map<? extends CallableDescriptor.UserDataKey<?>, ?>)(bl12 ? map : null));
        functionDescriptor.setOperator(function2.hasModifier(KtTokens.OPERATOR_KEYWORD));
        functionDescriptor.setInfix(function2.hasModifier(KtTokens.INFIX_KEYWORD));
        functionDescriptor.setExternal(function2.hasModifier(KtTokens.EXTERNAL_KEYWORD));
        functionDescriptor.setInline(function2.hasModifier(KtTokens.INLINE_KEYWORD));
        functionDescriptor.setTailrec(function2.hasModifier(KtTokens.TAILREC_KEYWORD));
        functionDescriptor.setSuspend(function2.hasModifier(KtTokens.SUSPEND_KEYWORD));
        functionDescriptor.setExpect(container instanceof PackageFragmentDescriptor && PsiUtilsKt.hasExpectModifier(function2) || container instanceof ClassDescriptor && ((ClassDescriptor)container).isExpect());
        functionDescriptor.setActual(PsiUtilsKt.hasActualModifier(function2));
        KotlinType kotlinType4 = receiverType;
        if (kotlinType4 != null) {
            it = kotlinType4;
            boolean bl13 = false;
            ForceResolveUtil.forceResolveAllContents(it.getAnnotations());
        }
        for (ValueParameterDescriptor valueParameterDescriptor : valueParameterDescriptors) {
            ForceResolveUtil.forceResolveAllContents(valueParameterDescriptor.getType().getAnnotations());
        }
    }

    private final LazyContractProvider getContractProvider(SimpleFunctionDescriptorImpl functionDescriptor, BindingTrace trace, LexicalScope scope2, DataFlowInfo dataFlowInfo, KtFunction function2, InferenceSession inferenceSession) {
        if (!(function2 instanceof KtNamedFunction)) {
            return null;
        }
        boolean isContractsEnabled = this.languageVersionSettings.supportsFeature(LanguageFeature.AllowContractsForCustomFunctions);
        boolean isAllowedOnMembers = this.languageVersionSettings.supportsFeature(LanguageFeature.AllowContractsForNonOverridableMembers);
        if (!isContractsEnabled || !((KtNamedFunction)function2).mayHaveContract(isAllowedOnMembers)) {
            return null;
        }
        return new LazyContractProvider(this.storageManager, () -> FunctionDescriptorResolver.getContractProvider$lambda$12(function2, this, trace, scope2, dataFlowInfo, functionDescriptor, inferenceSession));
    }

    /*
     * WARNING - void declaration
     */
    private final List<ValueParameterDescriptor> createValueParameterDescriptors(KtFunction function2, SimpleFunctionDescriptorImpl functionDescriptor, LexicalWritableScope innerScope, BindingTrace trace, KotlinType expectedFunctionType, InferenceSession inferenceSession) {
        List expectedParameterTypes;
        List list;
        List<ValueParameterDescriptor> expectedValueParameters;
        List<ValueParameterDescriptor> list2 = expectedValueParameters = this.getValueParameters(expectedFunctionType, functionDescriptor);
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                KotlinType kotlinType = it.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
                collection.add(this.removeParameterNameAnnotation(kotlinType));
            }
            list = (List)destination$iv$iv;
        } else {
            list = expectedParameterTypes = null;
        }
        if (expectedValueParameters != null) {
            if (expectedValueParameters.size() == 1 && function2 instanceof KtFunctionLiteral && ((KtFunctionLiteral)function2).getValueParameterList() == null) {
                ValueParameterDescriptor valueParameterDescriptor = CollectionsKt.single(expectedValueParameters);
                CallableDescriptor callableDescriptor = functionDescriptor;
                Annotations annotations2 = Annotations.Companion.getEMPTY();
                List list3 = expectedParameterTypes;
                Intrinsics.checkNotNull(list3);
                KotlinType kotlinType = (KotlinType)CollectionsKt.single(list3);
                boolean bl = valueParameterDescriptor.declaresDefaultValue();
                boolean bl2 = valueParameterDescriptor.isCrossinline();
                boolean bl3 = valueParameterDescriptor.isNoinline();
                KotlinType kotlinType2 = valueParameterDescriptor.getVarargElementType();
                SourceElement sourceElement = SourceElement.NO_SOURCE;
                Intrinsics.checkNotNullExpressionValue(sourceElement, "NO_SOURCE");
                ValueParameterDescriptorImpl it = new ValueParameterDescriptorImpl(callableDescriptor, null, 0, annotations2, StandardNames.IMPLICIT_LAMBDA_PARAMETER_NAME, kotlinType, bl, bl2, bl3, kotlinType2, sourceElement);
                trace.record(BindingContext.AUTO_CREATED_IT, it);
                return CollectionsKt.listOf(it);
            }
            if (function2.getValueParameters().size() != expectedValueParameters.size()) {
                PsiElement psiElement = function2;
                List list4 = expectedParameterTypes;
                Intrinsics.checkNotNull(list4);
                trace.report(Errors.EXPECTED_PARAMETERS_NUMBER_MISMATCH.on((KtFunction)psiElement, list4.size(), expectedParameterTypes));
            }
        }
        BindingContextUtilsKt.recordScope(trace, innerScope, function2.getValueParameterList());
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        List<KtParameter> list5 = function2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list5, "getValueParameters(...)");
        return this.resolveValueParameters(functionDescriptor2, innerScope, list5, trace, expectedParameterTypes, inferenceSession);
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinType removeParameterNameAnnotation(KotlinType $this$removeParameterNameAnnotation) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        if ($this$removeParameterNameAnnotation instanceof TypeUtils.SpecialType) {
            return $this$removeParameterNameAnnotation;
        }
        AnnotationDescriptor annotationDescriptor = $this$removeParameterNameAnnotation.getAnnotations().findAnnotation(StandardNames.FqNames.parameterName);
        if (annotationDescriptor == null) {
            return $this$removeParameterNameAnnotation;
        }
        AnnotationDescriptor parameterNameAnnotation = annotationDescriptor;
        Iterable iterable = $this$removeParameterNameAnnotation.getAnnotations();
        Annotations.Companion companion = Annotations.Companion;
        KotlinType kotlinType = $this$removeParameterNameAnnotation;
        boolean $i$f$filter = false;
        void var5_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AnnotationDescriptor it = (AnnotationDescriptor)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual(it, parameterNameAnnotation))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return TypeUtilsKt.replaceAnnotations(kotlinType, companion.create(list));
    }

    private final boolean functionTypeExpected(KotlinType $this$functionTypeExpected) {
        return !TypeUtils.noExpectedType($this$functionTypeExpected) && FunctionTypesKt.isBuiltinFunctionalType($this$functionTypeExpected);
    }

    private final KotlinType getReceiverType(KotlinType $this$getReceiverType) {
        return this.functionTypeExpected($this$getReceiverType) ? FunctionTypesKt.getReceiverTypeFromFunctionType($this$getReceiverType) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ContextReceiverTypeWithLabel> getContextReceiversTypes(KotlinType $this$getContextReceiversTypes) {
        List list;
        if (this.functionTypeExpected($this$getContextReceiversTypes)) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = FunctionTypesKt.getContextReceiverTypesFromFunctionType($this$getContextReceiversTypes);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KotlinType kotlinType = (KotlinType)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new ContextReceiverTypeWithLabel((KotlinType)it, null));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final List<ValueParameterDescriptor> getValueParameters(KotlinType $this$getValueParameters, FunctionDescriptor owner) {
        return this.functionTypeExpected($this$getValueParameters) ? FunctionTypeResolveUtilsKt.createValueParametersForInvokeInFunctionType(owner, FunctionTypesKt.getValueParameterTypesFromFunctionType($this$getValueParameters)) : null;
    }

    @Nullable
    public final ClassConstructorDescriptorImpl resolvePrimaryConstructorDescriptor(@NotNull LexicalScope scope2, @NotNull ClassDescriptor classDescriptor, @NotNull KtPureClassOrObject classElement, @NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings, @Nullable InferenceSession inferenceSession) {
        Intrinsics.checkNotNullParameter(scope2, "scope");
        Intrinsics.checkNotNullParameter(classDescriptor, "classDescriptor");
        Intrinsics.checkNotNullParameter(classElement, "classElement");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        if (classDescriptor.getKind() == ClassKind.ENUM_ENTRY || !classElement.hasPrimaryConstructor()) {
            return null;
        }
        KtModifierList ktModifierList = classElement.getPrimaryConstructorModifierList();
        KtPrimaryConstructor ktPrimaryConstructor = classElement.getPrimaryConstructor();
        KtPureElement ktPureElement = ktPrimaryConstructor != null ? (KtPureElement)ktPrimaryConstructor : (KtPureElement)classElement;
        List<KtParameter> list = classElement.getPrimaryConstructorParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getPrimaryConstructorParameters(...)");
        return this.createConstructorDescriptor(scope2, classDescriptor, true, ktModifierList, ktPureElement, list, trace, languageVersionSettings, inferenceSession);
    }

    @NotNull
    public final ClassConstructorDescriptorImpl resolveSecondaryConstructorDescriptor(@NotNull LexicalScope scope2, @NotNull ClassDescriptor classDescriptor, @NotNull KtSecondaryConstructor constructor, @NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings, @Nullable InferenceSession inferenceSession) {
        Intrinsics.checkNotNullParameter(scope2, "scope");
        Intrinsics.checkNotNullParameter(classDescriptor, "classDescriptor");
        Intrinsics.checkNotNullParameter(constructor, "constructor");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        return this.createConstructorDescriptor(scope2, classDescriptor, false, constructor.getModifierList(), constructor, constructor.getValueParameters(), trace, languageVersionSettings, inferenceSession);
    }

    private final ClassConstructorDescriptorImpl createConstructorDescriptor(LexicalScope scope2, ClassDescriptor classDescriptor, boolean isPrimary, KtModifierList modifierList2, KtPureElement declarationToTrace, List<? extends KtParameter> valueParameters, BindingTrace trace, LanguageVersionSettings languageVersionSettings, InferenceSession inferenceSession) {
        ClassConstructorDescriptorImpl classConstructorDescriptorImpl = ClassConstructorDescriptorImpl.create(classDescriptor, this.annotationResolver.resolveAnnotationsWithoutArguments(scope2, modifierList2, trace), isPrimary, KotlinSourceElementKt.toSourceElement(declarationToTrace));
        Intrinsics.checkNotNullExpressionValue(classConstructorDescriptorImpl, "create(...)");
        ClassConstructorDescriptorImpl constructorDescriptor = classConstructorDescriptorImpl;
        constructorDescriptor.setExpect(classDescriptor.isExpect());
        KtModifierList ktModifierList = modifierList2;
        constructorDescriptor.setActual((ktModifierList != null ? PsiUtilsKt.hasActualModifier(ktModifierList) : false) || classDescriptor.getKind() == ClassKind.ANNOTATION_CLASS && classDescriptor.isActual());
        LexicalWritableScope parameterScope = new LexicalWritableScope(scope2, constructorDescriptor, false, new TraceBasedLocalRedeclarationChecker(trace, this.overloadChecker), LexicalScopeKind.CONSTRUCTOR_HEADER);
        ClassConstructorDescriptorImpl constructor = constructorDescriptor.initialize(this.resolveValueParameters(constructorDescriptor, parameterScope, valueParameters, trace, null, inferenceSession), ModifiersChecker.resolveVisibilityFromModifiers(modifierList2, DescriptorUtils.getDefaultConstructorVisibility(classDescriptor, languageVersionSettings.supportsFeature(LanguageFeature.AllowSealedInheritorsInDifferentFilesOfSamePackage))));
        constructor.setReturnType(classDescriptor.getDefaultType());
        if (DescriptorUtils.isAnnotationClass(classDescriptor)) {
            CompileTimeConstantUtils.checkConstructorParametersType(valueParameters, trace);
        }
        if (declarationToTrace instanceof PsiElement) {
            trace.record(BindingContext.CONSTRUCTOR, declarationToTrace, constructorDescriptor);
        }
        Intrinsics.checkNotNull(constructor);
        return constructor;
    }

    /*
     * Unable to fully structure code
     */
    private final List<ValueParameterDescriptor> resolveValueParameters(FunctionDescriptor functionDescriptor, LexicalWritableScope parameterScope, List<? extends KtParameter> valueParameters, BindingTrace trace, List<? extends KotlinType> expectedParameterTypes, InferenceSession inferenceSession) {
        result = new ArrayList<ValueParameterDescriptorImpl>();
        var9_9 = ((Collection)valueParameters).size();
        for (i = 0; i < var9_9; ++i) {
            valueParameter = valueParameters.get(i);
            typeReference = valueParameter.getTypeReference();
            v0 = expectedParameterTypes;
            if (v0 == null) ** GOTO lbl-1000
            it = v0;
            $i$a$-let-FunctionDescriptorResolver$resolveValueParameters$expectedType$1 = false;
            v1 = i < it.size() ? it.get(i) : null;
            v0 = v1;
            if (v1 != null) {
                it = var14_14 = v0;
                $i$a$-takeUnless-FunctionDescriptorResolver$resolveValueParameters$expectedType$2 = false;
                v2 = !TypeUtils.noExpectedType(it) ? var14_14 : null;
            } else lbl-1000:
            // 2 sources

            {
                v2 = null;
            }
            expectedType = v2;
            type = null;
            if (typeReference != null) {
                type = this.typeResolver.resolveType(parameterScope, typeReference, trace, true);
                if (expectedType != null && !KotlinTypeChecker.DEFAULT.isSubtypeOf((KotlinType)expectedType, (KotlinType)type)) {
                    trace.report(Errors.EXPECTED_PARAMETER_TYPE_MISMATCH.on((KtParameter)((PsiElement)valueParameter), (KotlinType)expectedType));
                }
            } else {
                if (ExpressionTypingUtils.isFunctionLiteral(functionDescriptor) || ExpressionTypingUtils.isFunctionExpression(functionDescriptor)) {
                    containsErrorType = TypeUtils.contains(expectedType, (Function1<UnwrappedType, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, resolveValueParameters$lambda$18(org.jetbrains.kotlin.types.UnwrappedType ), (Lorg/jetbrains/kotlin/types/UnwrappedType;)Ljava/lang/Boolean;)());
                    if (expectedType == null || containsErrorType) {
                        trace.report(Errors.CANNOT_INFER_PARAMETER_TYPE.on((KtParameter)((PsiElement)valueParameter)));
                    }
                    if ((v3 = expectedType) == null) {
                        v3 = TypeUtils.CANNOT_INFER_FUNCTION_PARAM_TYPE;
                    }
                } else {
                    trace.report(Errors.VALUE_PARAMETER_WITH_NO_TYPE_ANNOTATION.on((KtParameter)((PsiElement)valueParameter)));
                    var15_17 = new String[1];
                    Intrinsics.checkNotNullExpressionValue(valueParameter.getNameAsSafeName().toString(), "toString(...)");
                    v3 = ErrorUtils.createErrorType(ErrorTypeKind.MISSED_TYPE_FOR_PARAMETER, var15_17);
                }
                var14_14 = v3;
                Intrinsics.checkNotNull(var14_14);
                type = var14_14;
            }
            if (!(functionDescriptor instanceof ConstructorDescriptor) || !((ConstructorDescriptor)functionDescriptor).isPrimary()) {
                isConstructor = functionDescriptor instanceof ConstructorDescriptor;
                $this$resolveValueParameters_u24lambda_u2419 = this.modifiersChecker.withTrace(trace);
                $i$a$-with-FunctionDescriptorResolver$resolveValueParameters$1 = false;
                $this$resolveValueParameters_u24lambda_u2419.checkParameterHasNoValOrVar(valueParameter, isConstructor != false ? Errors.VAL_OR_VAR_ON_SECONDARY_CONSTRUCTOR_PARAMETER : Errors.VAL_OR_VAR_ON_FUN_PARAMETER);
            }
            Intrinsics.checkNotNullExpressionValue(this.descriptorResolver.resolveValueParameterDescriptor(parameterScope, functionDescriptor, valueParameter, i, (KotlinType)type, trace, Annotations.Companion.getEMPTY(), inferenceSession), "resolveValueParameterDescriptor(...)");
            ExpressionTypingUtils.checkVariableShadowing(parameterScope, trace, valueParameterDescriptor);
            parameterScope.addVariableDescriptor(valueParameterDescriptor);
            result.add(valueParameterDescriptor);
        }
        return result;
    }

    private static final KotlinType getContractProvider$lambda$12$lambda$11(FunctionDescriptorResolver this$0, BindingTrace $trace, LexicalScope $scope, DataFlowInfo $dataFlowInfo, KtFunction $function, SimpleFunctionDescriptorImpl $functionDescriptor, InferenceSession $inferenceSession) {
        return this$0.expressionTypingServices.getBodyExpressionType($trace, $scope, $dataFlowInfo, $function, $functionDescriptor, $inferenceSession);
    }

    private static final Object getContractProvider$lambda$12(KtFunction $function, FunctionDescriptorResolver this$0, BindingTrace $trace, LexicalScope $scope, DataFlowInfo $dataFlowInfo, SimpleFunctionDescriptorImpl $functionDescriptor, InferenceSession $inferenceSession) {
        return AstLoadingFilter.forceAllowTreeLoading(((KtNamedFunction)$function).getContainingFile(), () -> FunctionDescriptorResolver.getContractProvider$lambda$12$lambda$11(this$0, $trace, $scope, $dataFlowInfo, $function, $functionDescriptor, $inferenceSession));
    }

    private static final Boolean resolveValueParameters$lambda$18(UnwrappedType it) {
        Intrinsics.checkNotNull(it);
        return KotlinTypeKt.isError(it);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/FunctionDescriptorResolver$ContextReceiverTypeWithLabel;", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "label", "Lorg/jetbrains/kotlin/name/Name;", "<init>", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/name/Name;)V", "getType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "getLabel", "()Lorg/jetbrains/kotlin/name/Name;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "frontend"})
    private static final class ContextReceiverTypeWithLabel {
        @NotNull
        private final KotlinType type;
        @Nullable
        private final Name label;

        public ContextReceiverTypeWithLabel(@NotNull KotlinType type, @Nullable Name label) {
            Intrinsics.checkNotNullParameter(type, "type");
            this.type = type;
            this.label = label;
        }

        @NotNull
        public final KotlinType getType() {
            return this.type;
        }

        @Nullable
        public final Name getLabel() {
            return this.label;
        }

        @NotNull
        public final KotlinType component1() {
            return this.type;
        }

        @Nullable
        public final Name component2() {
            return this.label;
        }

        @NotNull
        public final ContextReceiverTypeWithLabel copy(@NotNull KotlinType type, @Nullable Name label) {
            Intrinsics.checkNotNullParameter(type, "type");
            return new ContextReceiverTypeWithLabel(type, label);
        }

        public static /* synthetic */ ContextReceiverTypeWithLabel copy$default(ContextReceiverTypeWithLabel contextReceiverTypeWithLabel, KotlinType kotlinType, Name name2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                kotlinType = contextReceiverTypeWithLabel.type;
            }
            if ((n2 & 2) != 0) {
                name2 = contextReceiverTypeWithLabel.label;
            }
            return contextReceiverTypeWithLabel.copy(kotlinType, name2);
        }

        @NotNull
        public String toString() {
            return "ContextReceiverTypeWithLabel(type=" + this.type + ", label=" + this.label + ')';
        }

        public int hashCode() {
            int result2 = this.type.hashCode();
            result2 = result2 * 31 + (this.label == null ? 0 : this.label.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ContextReceiverTypeWithLabel)) {
                return false;
            }
            ContextReceiverTypeWithLabel contextReceiverTypeWithLabel = (ContextReceiverTypeWithLabel)other;
            if (!Intrinsics.areEqual(this.type, contextReceiverTypeWithLabel.type)) {
                return false;
            }
            return Intrinsics.areEqual(this.label, contextReceiverTypeWithLabel.label);
        }
    }
}

