/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.dfa;

import java.util.LinkedHashSet;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.DfaType;
import org.jetbrains.kotlin.fir.resolve.dfa.DataFlowVariable;
import org.jetbrains.kotlin.fir.resolve.dfa.Implication;
import org.jetbrains.kotlin.fir.resolve.dfa.MutableTypeStatement;
import org.jetbrains.kotlin.fir.resolve.dfa.Operation;
import org.jetbrains.kotlin.fir.resolve.dfa.OperationStatement;
import org.jetbrains.kotlin.fir.resolve.dfa.RealVariable;
import org.jetbrains.kotlin.fir.resolve.dfa.Statement;
import org.jetbrains.kotlin.fir.resolve.dfa.SyntheticVariable;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0086\u0004\u001a\u0017\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\tH\u0086\u0004\u001a\u0017\u0010\n\u001a\u00020\u0005*\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\tH\u0086\u0004\u001a\u0015\u0010\u000b\u001a\u00020\f*\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0086\u0004\u001a\u0019\u0010\u000f\u001a\u00020\u0010*\u00020\u00022\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0086\u0004\u001a\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\bH\u0086\u0004\u001a\u0015\u0010\u0014\u001a\u00020\u0010*\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0086\u0004\u001a\u0015\u0010\u0017\u001a\u00020\u0010*\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0086\u0004\u001a\u001b\u0010\u0018\u001a\u00020\b*\u00020\u0006\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\u0010\u0000(\u0000\u001a\u001b\u0010\u001a\u001a\u00020\b*\u00020\u0006\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\u0010\u0000(\u0001*\"\u0010\u0000\"\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00f2\u0001\b\n\u00020\u0019\n\u00020\u0002\u00a8\u0006\u001b"}, d2={"TypeStatements", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/RealVariable;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/TypeStatement;", "eq", "Lorg/jetbrains/kotlin/fir/resolve/dfa/OperationStatement;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/DataFlowVariable;", "constant", "", "", "notEq", "implies", "Lorg/jetbrains/kotlin/fir/resolve/dfa/Implication;", "effect", "Lorg/jetbrains/kotlin/fir/resolve/dfa/Statement;", "valueNotEq", "Lorg/jetbrains/kotlin/fir/resolve/dfa/MutableTypeStatement;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "boolean", "typeEq", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "typeNotEq", "isSynthetic", "Lorg/jetbrains/kotlin/fir/resolve/dfa/SyntheticVariable;", "isReal", "semantics"})
public final class ModelKt {
    @NotNull
    public static final OperationStatement eq(@NotNull DataFlowVariable $this$eq, boolean constant) {
        Intrinsics.checkNotNullParameter($this$eq, "<this>");
        return new OperationStatement($this$eq, constant ? Operation.EqTrue : Operation.EqFalse);
    }

    @NotNull
    public static final OperationStatement eq(@NotNull DataFlowVariable $this$eq, @Nullable Void constant) {
        Intrinsics.checkNotNullParameter($this$eq, "<this>");
        return new OperationStatement($this$eq, Operation.EqNull);
    }

    @NotNull
    public static final OperationStatement notEq(@NotNull DataFlowVariable $this$notEq, @Nullable Void constant) {
        Intrinsics.checkNotNullParameter($this$notEq, "<this>");
        return new OperationStatement($this$notEq, Operation.NotEqNull);
    }

    @NotNull
    public static final Implication implies(@NotNull OperationStatement $this$implies, @NotNull Statement effect) {
        Intrinsics.checkNotNullParameter($this$implies, "<this>");
        Intrinsics.checkNotNullParameter(effect, "effect");
        return new Implication($this$implies, effect);
    }

    @NotNull
    public static final MutableTypeStatement valueNotEq(@NotNull RealVariable $this$valueNotEq, @NotNull FirBasedSymbol<?> symbol) {
        Intrinsics.checkNotNullParameter($this$valueNotEq, "<this>");
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        DfaType[] dfaTypeArray = new DfaType[]{new DfaType.Symbol(symbol)};
        return new MutableTypeStatement($this$valueNotEq, null, SetsKt.linkedSetOf(dfaTypeArray), 2, null);
    }

    @NotNull
    public static final MutableTypeStatement valueNotEq(@NotNull RealVariable $this$valueNotEq, boolean bl) {
        Intrinsics.checkNotNullParameter($this$valueNotEq, "<this>");
        DfaType[] dfaTypeArray = new DfaType[]{new DfaType.BooleanLiteral(bl)};
        return new MutableTypeStatement($this$valueNotEq, null, SetsKt.linkedSetOf(dfaTypeArray), 2, null);
    }

    @NotNull
    public static final MutableTypeStatement typeEq(@NotNull RealVariable $this$typeEq, @NotNull ConeKotlinType type) {
        LinkedHashSet<Object> linkedHashSet;
        Intrinsics.checkNotNullParameter($this$typeEq, "<this>");
        Intrinsics.checkNotNullParameter(type, "type");
        if (type instanceof ConeErrorType) {
            linkedHashSet = new LinkedHashSet();
        } else {
            ConeKotlinType[] coneKotlinTypeArray = new ConeKotlinType[]{type};
            linkedHashSet = SetsKt.linkedSetOf(coneKotlinTypeArray);
        }
        return new MutableTypeStatement($this$typeEq, linkedHashSet, null, 4, null);
    }

    @NotNull
    public static final MutableTypeStatement typeNotEq(@NotNull RealVariable $this$typeNotEq, @NotNull ConeKotlinType type) {
        LinkedHashSet<Object> linkedHashSet;
        Intrinsics.checkNotNullParameter($this$typeNotEq, "<this>");
        Intrinsics.checkNotNullParameter(type, "type");
        if (type instanceof ConeErrorType) {
            linkedHashSet = new LinkedHashSet();
        } else {
            DfaType[] dfaTypeArray = new DfaType[]{new DfaType.Cone(type)};
            linkedHashSet = SetsKt.linkedSetOf(dfaTypeArray);
        }
        return new MutableTypeStatement($this$typeNotEq, null, linkedHashSet, 2, null);
    }

    public static final boolean isSynthetic(@NotNull DataFlowVariable $this$isSynthetic) {
        Intrinsics.checkNotNullParameter($this$isSynthetic, "<this>");
        return $this$isSynthetic instanceof SyntheticVariable;
    }

    public static final boolean isReal(@NotNull DataFlowVariable $this$isReal) {
        Intrinsics.checkNotNullParameter($this$isReal, "<this>");
        return $this$isReal instanceof RealVariable;
    }
}

