/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.test;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.jvm.DefaultJvmElementVisitor;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.inspection.JvmLocalInspection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.testIntegration.JavaTestFramework;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\u00020\u000fH\u0002J&\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/codeInspection/test/TestCaseWithoutTestsVisitor;", "Lcom/intellij/lang/jvm/DefaultJvmElementVisitor;", "", "sink", "Lcom/intellij/lang/jvm/inspection/JvmLocalInspection$HighlightSink;", "ignoreSupers", "<init>", "(Lcom/intellij/lang/jvm/inspection/JvmLocalInspection$HighlightSink;Z)V", "visitClass", "clazz", "Lcom/intellij/lang/jvm/JvmClass;", "(Lcom/intellij/lang/jvm/JvmClass;)Ljava/lang/Boolean;", "availableFrameworks", "", "Lcom/intellij/testIntegration/JavaTestFramework;", "Lcom/intellij/psi/PsiClass;", "hasTestMethods", "aClass", "frameworks", "", "checkSuite", "intellij.jvm.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nTestCaseWithoutTestsInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestCaseWithoutTestsInspection.kt\ncom/intellij/codeInspection/test/TestCaseWithoutTestsVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,88:1\n808#2,11:89\n774#2:100\n865#2,2:101\n774#2:105\n865#2,2:106\n12637#3,2:103\n*S KotlinDebug\n*F\n+ 1 TestCaseWithoutTestsInspection.kt\ncom/intellij/codeInspection/test/TestCaseWithoutTestsVisitor\n*L\n70#1:89,11\n71#1:100\n71#1:101,2\n81#1:105\n81#1:106,2\n78#1:103,2\n*E\n"})
final class TestCaseWithoutTestsVisitor
implements DefaultJvmElementVisitor<Boolean> {
    @NotNull
    private final JvmLocalInspection.HighlightSink sink;
    private final boolean ignoreSupers;

    public TestCaseWithoutTestsVisitor(@NotNull JvmLocalInspection.HighlightSink sink, boolean ignoreSupers) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        this.sink = sink;
        this.ignoreSupers = ignoreSupers;
    }

    @NotNull
    public Boolean visitClass(@NotNull JvmClass clazz) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        if (!(clazz instanceof PsiClass)) {
            return true;
        }
        if (clazz instanceof PsiTypeParameter) {
            return true;
        }
        if (((PsiClass)clazz).isEnum() || ((PsiClass)clazz).isAnnotationType() || ((PsiClass)clazz).isInterface() || PsiUtil.isLocalOrAnonymousClass((PsiClass)((PsiClass)clazz))) {
            return true;
        }
        if (((PsiClass)clazz).hasModifier(JvmModifier.ABSTRACT)) {
            return true;
        }
        if (((PsiClass)clazz).hasAnnotation("org.junit.Ignore")) {
            return true;
        }
        if (((PsiClass)clazz).hasAnnotation("org.junit.runner.RunWith")) {
            return true;
        }
        Collection<JavaTestFramework> applicableFrameworks = this.availableFrameworks((PsiClass)clazz);
        if (applicableFrameworks.isEmpty()) {
            return true;
        }
        if (this.hasTestMethods((PsiClass)clazz, (Iterable<? extends JavaTestFramework>)applicableFrameworks, true)) {
            return true;
        }
        if (this.ignoreSupers) {
            for (PsiClass superClass = ((PsiClass)clazz).getSuperClass(); superClass != null && ((PsiClass)clazz).getManager().isInProject((PsiElement)superClass); superClass = superClass.getSuperClass()) {
                if (superClass.hasAnnotation("org.junit.runner.RunWith")) {
                    return true;
                }
                Collection<JavaTestFramework> superFrameworks = this.availableFrameworks(superClass);
                if (!this.hasTestMethods(superClass, (Iterable<? extends JavaTestFramework>)superFrameworks, false)) continue;
                return true;
            }
        }
        Object[] objectArray = new Object[]{ClassInheritorsSearch.search((PsiClass)((PsiClass)clazz), (SearchScope)((PsiClass)clazz).getUseScope(), (boolean)false).findFirst() != null};
        this.sink.highlight(JvmAnalysisBundle.message("jvm.inspections.test.case.without.test.methods.problem.descriptor", objectArray), new LocalQuickFix[0]);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<JavaTestFramework> availableFrameworks(PsiClass $this$availableFrameworks) {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Set set = TestFrameworks.detectApplicableFrameworks((PsiClass)$this$availableFrameworks);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"detectApplicableFrameworks(...)");
        Iterable $this$filterIsInstance$iv = set;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof JavaTestFramework)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JavaTestFramework framework = (JavaTestFramework)element$iv$iv;
            boolean bl = false;
            if (!framework.isFrameworkAvailable((PsiElement)$this$availableFrameworks)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasTestMethods(PsiClass aClass, Iterable<? extends JavaTestFramework> frameworks, boolean checkSuite) {
        void $this$filterTo$iv$iv;
        PsiMethod[] psiMethodArray = aClass.getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getMethods(...)");
        PsiMethod[] methods = psiMethodArray;
        for (JavaTestFramework javaTestFramework : frameworks) {
            boolean bl;
            block6: {
                if (checkSuite && javaTestFramework.isSuiteClass(aClass)) {
                    return true;
                }
                PsiMethod[] $this$any$iv = methods;
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    PsiMethod element$iv;
                    PsiMethod method = element$iv = $this$any$iv[i];
                    boolean bl2 = false;
                    if (!javaTestFramework.isTestMethod((PsiElement)method, false)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
            if (!bl) continue;
            return true;
        }
        Iterable<? extends JavaTestFramework> iterable = frameworks;
        boolean $i$f$filter = false;
        Iterable<? extends JavaTestFramework> $i$f$any = iterable;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JavaTestFramework it = (JavaTestFramework)element$iv$iv;
            boolean bl = false;
            if (!it.acceptNestedClasses()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nestedTestFrameworks = (List)destination$iv$iv;
        if (nestedTestFrameworks.isEmpty()) {
            return false;
        }
        for (PsiClass innerClass : aClass.getInnerClasses()) {
            if (innerClass.hasModifierProperty("static")) continue;
            Intrinsics.checkNotNull((Object)innerClass);
            if (!this.hasTestMethods(innerClass, nestedTestFrameworks, false)) continue;
            return true;
        }
        return false;
    }
}

