/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.statistics;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.statistics.KotlinModuleSizeCollector;
import org.jetbrains.kotlin.idea.statistics.KotlinModuleSizeCollectorTracker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0004\u001f !\"B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0002J\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b*\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018*\u00020\u001aH\u0082@\u00a2\u0006\u0002\u0010\u001bJ\f\u0010\u001c\u001a\u00020\u0015*\u00020\u001aH\u0002J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001e\u001a\u00020\u001aH\u0096@\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/statistics/KotlinModuleSizeCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "<init>", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "GROUP", "toBucketName", "", "Lkotlin/ranges/IntRange;", "toBuckets", "", "Lorg/jetbrains/kotlin/idea/statistics/KotlinModuleSizeCollector$StatisticsBucket;", "lineCountBucketRanges", "LINE_COUNT_BUCKETS", "LINE_COUNT_EVENT", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "fileCountBucketRanges", "FILE_COUNT_BUCKETS", "FILE_COUNT_EVENT", "isGeneratedGradleFile", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "gatherProjectStatistics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "hasKotlinFiles", "collect", "project", "Companion", "StatisticsBucket", "ProjectStatistics", "ModuleStatistics", "kotlin.base.statistics"})
@SourceDebugExtension(value={"SMAP\nKotlinModuleSizeCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinModuleSizeCollector.kt\norg/jetbrains/kotlin/idea/statistics/KotlinModuleSizeCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,243:1\n1563#2:244\n1634#2,3:245\n1563#2:252\n1634#2,3:253\n1563#2:260\n1634#2,3:261\n37#3:248\n36#3,3:249\n37#3:256\n36#3,3:257\n*S KotlinDebug\n*F\n+ 1 KotlinModuleSizeCollector.kt\norg/jetbrains/kotlin/idea/statistics/KotlinModuleSizeCollector\n*L\n69#1:244\n69#1:245,3\n95#1:252\n95#1:253,3\n41#1:260\n41#1:261,3\n69#1:248\n69#1:249,3\n95#1:256\n95#1:257,3\n*E\n"})
public final class KotlinModuleSizeCollector
extends ProjectUsagesCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EventLogGroup GROUP = new EventLogGroup("kotlin.project.structure", 1, null, 4, null);
    @NotNull
    private final List<IntRange> lineCountBucketRanges;
    @NotNull
    private final List<StatisticsBucket> LINE_COUNT_BUCKETS;
    @NotNull
    private final VarargEventId LINE_COUNT_EVENT;
    @NotNull
    private final List<IntRange> fileCountBucketRanges;
    @NotNull
    private final List<StatisticsBucket> FILE_COUNT_BUCKETS;
    @NotNull
    private final VarargEventId FILE_COUNT_EVENT;
    @NotNull
    private static final Logger logger;
    private static final int AVERAGE_SIZE_PER_LINE = 40;

    /*
     * WARNING - void declaration
     */
    public KotlinModuleSizeCollector() {
        StatisticsBucket it;
        Collection<EventField<Integer>> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object[] objectArray = new IntRange[]{new IntRange(0, 0), new IntRange(1, 100), new IntRange(101, 1000), new IntRange(1001, 2000), new IntRange(2001, 5000), new IntRange(5001, 10000), new IntRange(10001, 20000), new IntRange(20001, 50000), new IntRange(50001, 100000), new IntRange(100001, 200000), new IntRange(200001, 500000), new IntRange(500001, 1000000), new IntRange(1000001, Integer.MAX_VALUE)};
        this.lineCountBucketRanges = CollectionsKt.listOf((Object[])objectArray);
        this.LINE_COUNT_BUCKETS = this.toBuckets(this.lineCountBucketRanges);
        Iterable iterable = this.LINE_COUNT_BUCKETS;
        String string = "modules.sizes.line_count";
        EventLogGroup eventLogGroup = this.GROUP;
        KotlinModuleSizeCollector kotlinModuleSizeCollector = this;
        boolean $i$f$map = false;
        void var4_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            StatisticsBucket statisticsBucket = (StatisticsBucket)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getEventField());
        }
        collection = (List)destination$iv$iv;
        Collection<EventField<Integer>> $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection<EventField<Integer>> thisCollection$iv = $this$toTypedArray$iv;
        objectArray = thisCollection$iv.toArray(new EventField[0]);
        kotlinModuleSizeCollector.LINE_COUNT_EVENT = eventLogGroup.registerVarargEvent(string, (EventField[])Arrays.copyOf(objectArray, objectArray.length));
        objectArray = new IntRange[]{new IntRange(0, 0), new IntRange(1, 1), new IntRange(2, 4), new IntRange(5, 7), new IntRange(8, 15), new IntRange(16, 25), new IntRange(26, 40), new IntRange(41, 70), new IntRange(71, 100), new IntRange(101, 300), new IntRange(301, 600), new IntRange(601, 1000), new IntRange(1001, 1500), new IntRange(1501, 2500), new IntRange(2501, 4000), new IntRange(4001, Integer.MAX_VALUE)};
        this.fileCountBucketRanges = CollectionsKt.listOf((Object[])objectArray);
        this.FILE_COUNT_BUCKETS = this.toBuckets(this.fileCountBucketRanges);
        $this$toTypedArray$iv = this.FILE_COUNT_BUCKETS;
        string = "modules.sizes.file_count";
        eventLogGroup = this.GROUP;
        kotlinModuleSizeCollector = this;
        $i$f$map = false;
        thisCollection$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (StatisticsBucket)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getEventField());
        }
        $this$toTypedArray$iv = collection = (List)destination$iv$iv;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        objectArray = thisCollection$iv.toArray(new EventField[0]);
        kotlinModuleSizeCollector.FILE_COUNT_EVENT = eventLogGroup.registerVarargEvent(string, (EventField[])Arrays.copyOf(objectArray, objectArray.length));
    }

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }

    private final String toBucketName(IntRange $this$toBucketName) {
        if ($this$toBucketName.getEndInclusive() == Integer.MAX_VALUE) {
            return "bucket_" + $this$toBucketName.getStart() + "_max";
        }
        return "bucket_" + $this$toBucketName.getStart() + "_" + $this$toBucketName.getEndInclusive();
    }

    /*
     * WARNING - void declaration
     */
    private final List<StatisticsBucket> toBuckets(List<IntRange> $this$toBuckets) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toBuckets;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void range2;
            IntRange intRange = (IntRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new StatisticsBucket((EventField<Integer>)((EventField)EventFields.Int((String)this.toBucketName((IntRange)range2))), (IntRange)range2));
        }
        return (List)destination$iv$iv;
    }

    private final boolean isGeneratedGradleFile(VirtualFile $this$isGeneratedGradleFile) {
        String string = $this$isGeneratedGradleFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)"build/generated-sources/kotlin", (boolean)false, (int)2, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object gatherProjectStatistics(Project $this$gatherProjectStatistics, Continuation<? super Set<MetricEvent>> $completion) {
        if (!($completion instanceof gatherProjectStatistics.1)) ** GOTO lbl-1000
        var12_3 = $completion;
        if ((var12_3.label & -2147483648) != 0) {
            var12_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                int I$0;
                int I$1;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ KotlinModuleSizeCollector this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return KotlinModuleSizeCollector.access$gatherProjectStatistics(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                projectStatistics = new ProjectStatistics(this.FILE_COUNT_BUCKETS, this.LINE_COUNT_BUCKETS);
                var4_7 = ProjectUtil.getModules((Project)$this$gatherProjectStatistics);
                var5_8 = 0;
                var6_9 = var4_7.length;
lbl16:
                // 2 sources

                while (var5_8 < var6_9) {
                    module = var4_7[var5_8];
                    startTime = System.currentTimeMillis();
                    moduleStatistics = new ModuleStatistics(0, 0, false, 7, null);
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$gatherProjectStatistics);
                    $continuation.L$1 = projectStatistics;
                    $continuation.L$2 = var4_7;
                    $continuation.L$3 = module;
                    $continuation.L$4 = moduleStatistics;
                    $continuation.I$0 = var5_8;
                    $continuation.I$1 = var6_9;
                    $continuation.J$0 = startTime;
                    $continuation.label = 1;
                    v0 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, gatherProjectStatistics$lambda$4(com.intellij.openapi.module.Module org.jetbrains.kotlin.idea.statistics.KotlinModuleSizeCollector org.jetbrains.kotlin.idea.statistics.KotlinModuleSizeCollector$ModuleStatistics ), ()Ljava/lang/Boolean;)((Module)module, (KotlinModuleSizeCollector)this, (ModuleStatistics)moduleStatistics), (Continuation)$continuation);
                    if (v0 == var13_5) {
                        return var13_5;
                    }
                    ** GOTO lbl45
                }
                break;
            }
            case 1: {
                startTime = $continuation.J$0;
                var6_9 = $continuation.I$1;
                var5_8 = $continuation.I$0;
                moduleStatistics = (ModuleStatistics)$continuation.L$4;
                module = (Module)$continuation.L$3;
                var4_7 = (Module[])$continuation.L$2;
                projectStatistics = (ProjectStatistics)$continuation.L$1;
                $this$gatherProjectStatistics = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl45:
                // 2 sources

                projectStatistics.increaseLineCountBucket(moduleStatistics.getFileSize());
                projectStatistics.increaseFileCountBucket(moduleStatistics.getFileCount());
                KotlinModuleSizeCollector.logger.debug("Collecting stats for module " + module.getName() + " took " + (System.currentTimeMillis() - startTime) + " ms");
                ++var5_8;
                ** GOTO lbl16
            }
        }
        return projectStatistics.generateEvents();
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final boolean hasKotlinFiles(Project $this$hasKotlinFiles) {
        return FileTypeIndex.containsFileOfType((FileType)((FileType)KotlinFileType.INSTANCE), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)$this$hasKotlinFiles));
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object collect(@NotNull Project project, @NotNull Continuation<? super Set<MetricEvent>> $completion) {
        block10: {
            if (!($completion instanceof collect.1)) ** GOTO lbl-1000
            var8_3 = $completion;
            if ((var8_3.label & -2147483648) != 0) {
                var8_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    long J$0;
                    boolean Z$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ KotlinModuleSizeCollector this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.collect(null, (Continuation<? super Set<MetricEvent>>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (!KotlinModuleSizeCollectorTracker.Companion.getInstance(project).shouldCollectData$kotlin_base_statistics()) {
                        return SetsKt.emptySet();
                    }
                    startTime = System.currentTimeMillis();
                    $continuation.L$0 = project;
                    $continuation.J$0 = startTime;
                    $continuation.label = 1;
                    v0 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, collect$lambda$5(org.jetbrains.kotlin.idea.statistics.KotlinModuleSizeCollector com.intellij.openapi.project.Project ), ()Ljava/lang/Boolean;)((KotlinModuleSizeCollector)this, (Project)project), (Continuation)$continuation);
                    if (v0 == var9_5) {
                        return var9_5;
                    }
                    ** GOTO lbl27
                }
                case 1: {
                    startTime = $continuation.J$0;
                    project = (Project)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl27:
                    // 2 sources

                    if (!(hasKotlinFiles = ((Boolean)v0).booleanValue())) break;
                    $continuation.L$0 = project;
                    $continuation.J$0 = startTime;
                    $continuation.Z$0 = hasKotlinFiles;
                    $continuation.label = 2;
                    v1 = this.gatherProjectStatistics(project, (Continuation<? super Set<MetricEvent>>)$continuation);
                    if (v1 == var9_5) {
                        return var9_5;
                    }
                    ** GOTO lbl42
                }
                case 2: {
                    hasKotlinFiles = $continuation.Z$0;
                    startTime = $continuation.J$0;
                    project = (Project)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl42:
                    // 2 sources

                    v2 = (Set)v1;
                    break block10;
                }
            }
            v2 = SetsKt.emptySet();
        }
        result = v2;
        KotlinModuleSizeCollectorTracker.Companion.getInstance(project).onCollectionFinished$kotlin_base_statistics();
        KotlinModuleSizeCollector.logger.debug("Collecting stats for project took " + (System.currentTimeMillis() - startTime) + " ms");
        return result;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final boolean gatherProjectStatistics$lambda$4$lambda$3(KotlinModuleSizeCollector this$0, ModuleStatistics $moduleStatistics, VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (Intrinsics.areEqual((Object)file.getExtension(), (Object)"kt") && !this$0.isGeneratedGradleFile(file)) {
            int n = $moduleStatistics.getFileCount();
            $moduleStatistics.setFileCount(n + 1);
            $moduleStatistics.setFileSize($moduleStatistics.getFileSize() + (int)file.getLength());
        } else if (Intrinsics.areEqual((Object)file.getExtension(), (Object)"java")) {
            $moduleStatistics.setHasJavaFiles(true);
        }
        return true;
    }

    private static final boolean gatherProjectStatistics$lambda$4(Module $module, KotlinModuleSizeCollector this$0, ModuleStatistics $moduleStatistics) {
        ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance((Module)$module).getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)moduleFileIndex, (String)"getFileIndex(...)");
        ModuleFileIndex moduleFileIndex2 = moduleFileIndex;
        return moduleFileIndex2.iterateContent(arg_0 -> KotlinModuleSizeCollector.gatherProjectStatistics$lambda$4$lambda$3(this$0, $moduleStatistics, arg_0));
    }

    private static final boolean collect$lambda$5(KotlinModuleSizeCollector this$0, Project $project) {
        return this$0.hasKotlinFiles($project);
    }

    public static final /* synthetic */ Object access$gatherProjectStatistics(KotlinModuleSizeCollector $this, Project $receiver, Continuation $completion) {
        return $this.gatherProjectStatistics($receiver, (Continuation<? super Set<MetricEvent>>)$completion);
    }

    static {
        Logger logger = Logger.getInstance(KotlinModuleSizeCollector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        KotlinModuleSizeCollector.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/statistics/KotlinModuleSizeCollector$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "AVERAGE_SIZE_PER_LINE", "", "kotlin.base.statistics"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\b\u0002\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/statistics/KotlinModuleSizeCollector$ModuleStatistics;", "", "fileCount", "", "fileSize", "hasJavaFiles", "", "<init>", "(IIZ)V", "getFileCount", "()I", "setFileCount", "(I)V", "getFileSize", "setFileSize", "getHasJavaFiles", "()Z", "setHasJavaFiles", "(Z)V", "kotlin.base.statistics"})
    private static final class ModuleStatistics {
        private int fileCount;
        private int fileSize;
        private boolean hasJavaFiles;

        public ModuleStatistics(int fileCount, int fileSize, boolean hasJavaFiles) {
            this.fileCount = fileCount;
            this.fileSize = fileSize;
            this.hasJavaFiles = hasJavaFiles;
        }

        public /* synthetic */ ModuleStatistics(int n, int n2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                n = 0;
            }
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            if ((n3 & 4) != 0) {
                bl = false;
            }
            this(n, n2, bl);
        }

        public final int getFileCount() {
            return this.fileCount;
        }

        public final void setFileCount(int n) {
            this.fileCount = n;
        }

        public final int getFileSize() {
            return this.fileSize;
        }

        public final void setFileSize(int n) {
            this.fileSize = n;
        }

        public final boolean getHasJavaFiles() {
            return this.hasJavaFiles;
        }

        public final void setHasJavaFiles(boolean bl) {
            this.hasJavaFiles = bl;
        }

        public ModuleStatistics() {
            this(0, 0, false, 7, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0001\u001aB#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u000f\u001a\u00020\u0010*\u0010\u0012\f\u0012\n0\fR\u00060\u0000R\u00020\r0\u00032\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0012J\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0012J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n0\fR\u00060\u0000R\u00020\r0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\f\u0012\n0\fR\u00060\u0000R\u00020\r0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/statistics/KotlinModuleSizeCollector$ProjectStatistics;", "", "fileCountBuckets", "", "Lorg/jetbrains/kotlin/idea/statistics/KotlinModuleSizeCollector$StatisticsBucket;", "lineCountBuckets", "<init>", "(Lorg/jetbrains/kotlin/idea/statistics/KotlinModuleSizeCollector;Ljava/util/List;Ljava/util/List;)V", "getFileCountBuckets", "()Ljava/util/List;", "getLineCountBuckets", "fileCountBucketCounts", "Lorg/jetbrains/kotlin/idea/statistics/KotlinModuleSizeCollector$ProjectStatistics$BucketCount;", "Lorg/jetbrains/kotlin/idea/statistics/KotlinModuleSizeCollector;", "lineCountBucketCounts", "increaseBucketCount", "", "value", "", "increaseFileCountBucket", "fileCount", "increaseLineCountBucket", "totalFileSize", "generateEvents", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "BucketCount", "kotlin.base.statistics"})
    @SourceDebugExtension(value={"SMAP\nKotlinModuleSizeCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinModuleSizeCollector.kt\norg/jetbrains/kotlin/idea/statistics/KotlinModuleSizeCollector$ProjectStatistics\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,243:1\n1563#2:244\n1634#2,3:245\n1563#2:248\n1634#2,3:249\n295#2,2:252\n1563#2:254\n1634#2,3:255\n1563#2:258\n1634#2,3:259\n*S KotlinDebug\n*F\n+ 1 KotlinModuleSizeCollector.kt\norg/jetbrains/kotlin/idea/statistics/KotlinModuleSizeCollector$ProjectStatistics\n*L\n112#1:244\n112#1:245,3\n113#1:248\n113#1:249,3\n116#1:252,2\n132#1:254\n132#1:255,3\n133#1:258\n133#1:259,3\n*E\n"})
    private final class ProjectStatistics {
        @NotNull
        private final List<StatisticsBucket> fileCountBuckets;
        @NotNull
        private final List<StatisticsBucket> lineCountBuckets;
        @NotNull
        private final List<BucketCount> fileCountBucketCounts;
        @NotNull
        private final List<BucketCount> lineCountBucketCounts;

        public ProjectStatistics(@NotNull List<StatisticsBucket> fileCountBuckets, List<StatisticsBucket> lineCountBuckets) {
            StatisticsBucket it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter(fileCountBuckets, (String)"fileCountBuckets");
            Intrinsics.checkNotNullParameter(lineCountBuckets, (String)"lineCountBuckets");
            this.fileCountBuckets = fileCountBuckets;
            this.lineCountBuckets = lineCountBuckets;
            Iterable iterable = this.fileCountBuckets;
            ProjectStatistics projectStatistics = this;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                StatisticsBucket statisticsBucket = (StatisticsBucket)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new BucketCount(it, 0));
            }
            projectStatistics.fileCountBucketCounts = (List)destination$iv$iv;
            $this$map$iv = this.lineCountBuckets;
            projectStatistics = this;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (StatisticsBucket)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new BucketCount(it, 0));
            }
            projectStatistics.lineCountBucketCounts = (List)destination$iv$iv;
        }

        @NotNull
        public final List<StatisticsBucket> getFileCountBuckets() {
            return this.fileCountBuckets;
        }

        @NotNull
        public final List<StatisticsBucket> getLineCountBuckets() {
            return this.lineCountBuckets;
        }

        public final void increaseBucketCount(@NotNull List<BucketCount> $this$increaseBucketCount, int value) {
            block2: {
                BucketCount bucketCount;
                Object v0;
                block1: {
                    Intrinsics.checkNotNullParameter($this$increaseBucketCount, (String)"<this>");
                    Iterable $this$firstOrNull$iv = $this$increaseBucketCount;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        BucketCount it = (BucketCount)element$iv;
                        boolean bl = false;
                        if (!it.getBucket().getRange().contains(value)) continue;
                        v0 = element$iv;
                        break block1;
                    }
                    v0 = null;
                }
                BucketCount bucketCount2 = bucketCount = (BucketCount)v0;
                if (bucketCount2 == null) break block2;
                bucketCount2.setCount(bucketCount.getCount() + 1);
            }
        }

        public final void increaseFileCountBucket(int fileCount) {
            this.increaseBucketCount(this.fileCountBucketCounts, fileCount);
        }

        public final void increaseLineCountBucket(int totalFileSize) {
            int estimatedLinesOfCode = (int)Math.ceil((double)totalFileSize / (double)40);
            this.increaseBucketCount(this.lineCountBucketCounts, estimatedLinesOfCode);
        }

        @NotNull
        public final Set<MetricEvent> generateEvents() {
            BucketCount it;
            Collection<EventPair> collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Object[] objectArray = new MetricEvent[2];
            Iterable iterable = this.lineCountBucketCounts;
            VarargEventId varargEventId = KotlinModuleSizeCollector.this.LINE_COUNT_EVENT;
            int n = 0;
            Object[] objectArray2 = objectArray;
            boolean $i$f$map = false;
            void var4_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                BucketCount bucketCount = (BucketCount)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getBucket().getEventField().with((Object)it.getCount()));
            }
            collection = (List)destination$iv$iv;
            objectArray2[n] = varargEventId.metric((List)collection);
            $this$map$iv = this.fileCountBucketCounts;
            varargEventId = KotlinModuleSizeCollector.this.FILE_COUNT_EVENT;
            n = 1;
            objectArray2 = objectArray;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (BucketCount)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getBucket().getEventField().with((Object)it.getCount()));
            }
            collection = (List)destination$iv$iv;
            objectArray2[n] = varargEventId.metric(collection);
            return SetsKt.setOf((Object[])objectArray);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/statistics/KotlinModuleSizeCollector$ProjectStatistics$BucketCount;", "", "bucket", "Lorg/jetbrains/kotlin/idea/statistics/KotlinModuleSizeCollector$StatisticsBucket;", "count", "", "<init>", "(Lorg/jetbrains/kotlin/idea/statistics/KotlinModuleSizeCollector$ProjectStatistics;Lorg/jetbrains/kotlin/idea/statistics/KotlinModuleSizeCollector$StatisticsBucket;I)V", "getBucket", "()Lorg/jetbrains/kotlin/idea/statistics/KotlinModuleSizeCollector$StatisticsBucket;", "getCount", "()I", "setCount", "(I)V", "kotlin.base.statistics"})
        private final class BucketCount {
            @NotNull
            private final StatisticsBucket bucket;
            private int count;

            public BucketCount(StatisticsBucket bucket, int count) {
                Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
                this.bucket = bucket;
                this.count = count;
            }

            @NotNull
            public final StatisticsBucket getBucket() {
                return this.bucket;
            }

            public final int getCount() {
                return this.count;
            }

            public final void setCount(int n) {
                this.count = n;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/statistics/KotlinModuleSizeCollector$StatisticsBucket;", "", "eventField", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "", "range", "Lkotlin/ranges/IntRange;", "<init>", "(Lcom/intellij/internal/statistic/eventLog/events/EventField;Lkotlin/ranges/IntRange;)V", "getEventField", "()Lcom/intellij/internal/statistic/eventLog/events/EventField;", "getRange", "()Lkotlin/ranges/IntRange;", "kotlin.base.statistics"})
    private static final class StatisticsBucket {
        @NotNull
        private final EventField<Integer> eventField;
        @NotNull
        private final IntRange range;

        public StatisticsBucket(@NotNull EventField<Integer> eventField, @NotNull IntRange range2) {
            Intrinsics.checkNotNullParameter(eventField, (String)"eventField");
            Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
            this.eventField = eventField;
            this.range = range2;
        }

        @NotNull
        public final EventField<Integer> getEventField() {
            return this.eventField;
        }

        @NotNull
        public final IntRange getRange() {
            return this.range;
        }
    }
}

