/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.analysis.api.imports.KaDefaultImport;
import org.jetbrains.kotlin.analysis.api.imports.KaDefaultImportsProviderKt;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinModificationTrackerFactory;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModuleProvider;
import org.jetbrains.kotlin.asJava.ImpreciseResolveResult;
import org.jetbrains.kotlin.idea.base.util.KotlinScopeUtils;
import org.jetbrains.kotlin.idea.stubindex.KotlinTypeAliasShortNameIndex;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 %2\u00020\u0001:\u0002%&B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0012\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0003H\u0007J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ,\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u000f2\b\u0010!\u001a\u0004\u0018\u00010\u0003H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0014\u0010#\u001a\u00020\u001c*\u00020\u001c2\u0006\u0010$\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/search/PsiBasedClassResolver;", "", "targetClassFqName", "", "<init>", "(Ljava/lang/String;)V", "target", "Lcom/intellij/psi/PsiClass;", "(Lcom/intellij/psi/PsiClass;)V", "targetShortName", "targetPackage", "conflictingPackages", "", "packagesWithTypeAliases", "forceAmbiguity", "", "forceAmbiguityForInnerAnnotations", "forceAmbiguityForNonAnnotations", "findPotentialClassConflicts", "", "findPotentialTypeAliasConflicts", "addConflict", "fqName", "canBeTargetReference", "Lorg/jetbrains/kotlin/asJava/ImpreciseResolveResult;", "ref", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "analyzeSingleImport", "Lorg/jetbrains/kotlin/idea/search/PsiBasedClassResolver$Result;", "result", "importedFqName", "Lorg/jetbrains/kotlin/name/FqName;", "isAllUnder", "aliasName", "checkQualifiedReferenceToTarget", "changeTo", "newResult", "Companion", "Result", "kotlin.base.analysis"})
@SourceDebugExtension(value={"SMAP\nPsiBasedClassResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsiBasedClassResolver.kt\norg/jetbrains/kotlin/idea/search/PsiBasedClassResolver\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,256:1\n213#2:257\n264#2,2:258\n196#2:260\n196#2:261\n125#3:262\n*S KotlinDebug\n*F\n+ 1 PsiBasedClassResolver.kt\norg/jetbrains/kotlin/idea/search/PsiBasedClassResolver\n*L\n152#1:257\n153#1:258,2\n153#1:260\n157#1:261\n226#1:262\n*E\n"})
public final class PsiBasedClassResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String targetClassFqName;
    @NotNull
    private final String targetShortName;
    @NotNull
    private final String targetPackage;
    @NotNull
    private final List<String> conflictingPackages;
    @NotNull
    private final List<String> packagesWithTypeAliases;
    private boolean forceAmbiguity;
    private boolean forceAmbiguityForInnerAnnotations;
    private boolean forceAmbiguityForNonAnnotations;
    @NotNull
    private static final AtomicInteger attempts = new AtomicInteger();
    @NotNull
    private static final AtomicInteger trueHits = new AtomicInteger();
    @NotNull
    private static final AtomicInteger falseHits = new AtomicInteger();
    @NotNull
    private static final Key<CachedValue<PsiBasedClassResolver>> PSI_BASED_CLASS_RESOLVER_KEY = new Key("PsiBasedClassResolver");

    @TestOnly
    public PsiBasedClassResolver(@NotNull String targetClassFqName) {
        Intrinsics.checkNotNullParameter((Object)targetClassFqName, (String)"targetClassFqName");
        this.targetClassFqName = targetClassFqName;
        this.targetShortName = StringsKt.substringAfterLast$default((String)this.targetClassFqName, (char)'.', null, (int)2, null);
        this.targetPackage = StringsKt.substringBeforeLast((String)this.targetClassFqName, (char)'.', (String)"");
        this.conflictingPackages = new ArrayList();
        this.packagesWithTypeAliases = new ArrayList();
    }

    private PsiBasedClassResolver(PsiClass target) {
        String string = target.getQualifiedName();
        if (string == null) {
            string = "";
        }
        this(string);
        if (target.getQualifiedName() == null || target.getContainingClass() != null || ((CharSequence)this.targetPackage).length() == 0) {
            this.forceAmbiguity = true;
            return;
        }
        ActionsKt.runReadAction(() -> PsiBasedClassResolver._init_$lambda$0(this, target));
    }

    private final void findPotentialClassConflicts(PsiClass target) {
        PsiShortNamesCache psiShortNamesCache = PsiShortNamesCache.getInstance((Project)target.getProject());
        Project project = target.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PsiClass[] psiClassArray = psiShortNamesCache.getClassesByName(this.targetShortName, KotlinScopeUtils.allScope(project));
        Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"getClassesByName(...)");
        for (PsiClass psiClass : psiClassArray) {
            Intrinsics.checkNotNull((Object)psiClass);
            PsiClass candidate = psiClass;
            if (candidate.getContainingClass() != null && !candidate.hasModifierProperty("private")) {
                if (candidate.isAnnotationType()) {
                    this.forceAmbiguityForInnerAnnotations = true;
                    break;
                }
                this.forceAmbiguityForNonAnnotations = true;
                break;
            }
            if (Intrinsics.areEqual((Object)candidate.getQualifiedName(), (Object)target.getQualifiedName())) {
                if (candidate == target || Intrinsics.areEqual((Object)candidate.getNavigationElement().getContainingFile(), (Object)target.getNavigationElement().getContainingFile())) continue;
                this.forceAmbiguity = true;
                break;
            }
            String string = candidate.getQualifiedName();
            if (string == null || (string = StringsKt.substringBeforeLast((String)string, (char)'.', (String)"")) == null) continue;
            String candidatePackage = string;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)candidatePackage, (Object)"")) {
                this.forceAmbiguity = true;
                continue;
            }
            this.conflictingPackages.add(candidatePackage);
        }
    }

    private final void findPotentialTypeAliasConflicts(PsiClass target) {
        Project project = target.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = target.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Collection candidates2 = KotlinTypeAliasShortNameIndex.Helper.get(this.targetShortName, project, KotlinScopeUtils.allScope(project2));
        for (KtTypeAlias candidate : candidates2) {
            this.packagesWithTypeAliases.add(candidate.getContainingKtFile().getPackageFqName().asString());
        }
    }

    @TestOnly
    public final void addConflict(@NotNull String fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        this.conflictingPackages.add(StringsKt.substringBeforeLast$default((String)fqName2, (char)'.', null, (int)2, null));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ImpreciseResolveResult canBeTargetReference(@NotNull KtSimpleNameExpression ref) {
        Result qualifiedCheckResult;
        KtDeclaration declaration;
        String $this$getParentOfType$iv$iv;
        void $this$getParentOfTypeAndBranch_u24default$iv;
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        attempts.incrementAndGet();
        if (!Intrinsics.areEqual((Object)ref.getReferencedName(), (Object)this.targetShortName)) {
            return ImpreciseResolveResult.UNSURE;
        }
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)ref;
        boolean $i$f$getStrictParentOfType = false;
        KtUserType ktUserType = (KtUserType)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtUserType.class, (boolean)true);
        if (ktUserType == null) {
            return ImpreciseResolveResult.UNSURE;
        }
        KtUserType userType = ktUserType;
        $this$getStrictParentOfType$iv = (PsiElement)userType;
        Function1 branch$iv = PsiBasedClassResolver::canBeTargetReference$lambda$2;
        boolean strict$iv2 = false;
        boolean $i$f$getParentOfTypeAndBranch = false;
        void var8_12 = $this$getParentOfTypeAndBranch_u24default$iv;
        boolean strict$iv$iv = strict$iv2;
        boolean $i$f$getParentOfType = false;
        PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv$iv, KtAnnotationEntry.class, (boolean)strict$iv$iv);
        KtAnnotationEntry parentAnnotation = (KtAnnotationEntry)(psiElement != null ? PsiUtilsKt.getIfChildIsInBranch((PsiElement)psiElement, (PsiElement)$this$getParentOfTypeAndBranch_u24default$iv, (Function1)branch$iv) : null);
        if (this.forceAmbiguityForNonAnnotations && parentAnnotation == null) {
            return ImpreciseResolveResult.UNSURE;
        }
        KtAnnotationEntry ktAnnotationEntry = parentAnnotation;
        if (ktAnnotationEntry != null) {
            void $this$getParentOfType$iv;
            PsiElement strict$iv2 = (PsiElement)ktAnnotationEntry;
            boolean strict$iv3 = true;
            boolean $i$f$getParentOfType2 = false;
            v3 = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtDeclaration.class, (boolean)strict$iv3);
        } else {
            v3 = declaration = null;
        }
        if (this.forceAmbiguityForInnerAnnotations) {
            KtDeclaration ktDeclaration = declaration;
            if (!((ktDeclaration != null ? ktDeclaration.getParent() : null) instanceof KtFile)) {
                return ImpreciseResolveResult.UNSURE;
            }
        }
        if (this.forceAmbiguity) {
            return ImpreciseResolveResult.UNSURE;
        }
        Result result2 = qualifiedCheckResult = this.checkQualifiedReferenceToTarget(ref);
        if (result2 != null) {
            return result2.getReturnValue();
        }
        KtFile ktFile2 = ref.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
        KtFile file = ktFile2;
        Result result3 = Result.NothingFound;
        $this$getParentOfType$iv$iv = file.getPackageFqName().asString();
        if (Intrinsics.areEqual((Object)$this$getParentOfType$iv$iv, (Object)this.targetPackage)) {
            result3 = this.changeTo(result3, Result.Found);
        } else if (this.conflictingPackages.contains($this$getParentOfType$iv$iv)) {
            result3 = this.changeTo(result3, Result.FoundOther);
        } else if (this.packagesWithTypeAliases.contains($this$getParentOfType$iv$iv)) {
            return ImpreciseResolveResult.UNSURE;
        }
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        KaModule kaModule = KaModuleProvider.Companion.getModule(project2, (PsiElement)file, null);
        for (KaDefaultImport defaultImports : KaDefaultImportsProviderKt.getDefaultImports(kaModule.getTargetPlatform(), project2).getDefaultImports()) {
            ImportPath importPath = defaultImports.getImportPath();
            Name name2 = importPath.getAlias();
            if ((result3 = this.analyzeSingleImport(result3, importPath.getFqName(), importPath.isAllUnder(), name2 != null ? name2.asString() : null)) != Result.Ambiguity) continue;
            return ImpreciseResolveResult.UNSURE;
        }
        for (KtImportDirective importDirective : file.getImportDirectives()) {
            if ((result3 = this.analyzeSingleImport(result3, importDirective.getImportedFqName(), importDirective.isAllUnder(), importDirective.getAliasName())) != Result.Ambiguity) continue;
            return ImpreciseResolveResult.UNSURE;
        }
        if (result3.getReturnValue() == ImpreciseResolveResult.MATCH) {
            trueHits.incrementAndGet();
        } else if (result3.getReturnValue() == ImpreciseResolveResult.NO_MATCH) {
            falseHits.incrementAndGet();
        }
        return result3.getReturnValue();
    }

    private final Result analyzeSingleImport(Result result2, FqName importedFqName, boolean isAllUnder, String aliasName) {
        if (!isAllUnder) {
            FqName fqName2 = importedFqName;
            if (Intrinsics.areEqual((Object)(fqName2 != null ? fqName2.asString() : null), (Object)this.targetClassFqName) && (aliasName == null || Intrinsics.areEqual((Object)aliasName, (Object)this.targetShortName))) {
                return this.changeTo(result2, Result.Found);
            }
            FqName fqName3 = importedFqName;
            if (Intrinsics.areEqual((Object)(fqName3 != null && (fqName3 = fqName3.shortName()) != null ? fqName3.asString() : null), (Object)this.targetShortName) && this.conflictingPackages.contains(importedFqName.parent().asString()) && aliasName == null) {
                return this.changeTo(result2, Result.FoundOther);
            }
            FqName fqName4 = importedFqName;
            if (Intrinsics.areEqual((Object)(fqName4 != null && (fqName4 = fqName4.shortName()) != null ? fqName4.asString() : null), (Object)this.targetShortName) && this.packagesWithTypeAliases.contains(importedFqName.parent().asString()) && aliasName == null) {
                return Result.Ambiguity;
            }
            if (Intrinsics.areEqual((Object)aliasName, (Object)this.targetShortName)) {
                return this.changeTo(result2, Result.FoundOther);
            }
        } else {
            FqName fqName5 = importedFqName;
            if (Intrinsics.areEqual((Object)(fqName5 != null ? fqName5.asString() : null), (Object)this.targetPackage)) {
                return this.changeTo(result2, Result.Found);
            }
            FqName fqName6 = importedFqName;
            if (CollectionsKt.contains((Iterable)this.conflictingPackages, (Object)(fqName6 != null ? fqName6.asString() : null))) {
                return this.changeTo(result2, Result.FoundOther);
            }
            FqName fqName7 = importedFqName;
            if (CollectionsKt.contains((Iterable)this.packagesWithTypeAliases, (Object)(fqName7 != null ? fqName7.asString() : null))) {
                return Result.Ambiguity;
            }
        }
        return result2;
    }

    private final Result checkQualifiedReferenceToTarget(KtSimpleNameExpression ref) {
        KtUserType ktUserType;
        KtUserType ktUserType2;
        PsiElement $this$safeAs$iv = ref.getParent();
        boolean $i$f$safeAs = false;
        PsiElement psiElement = $this$safeAs$iv;
        if (!(psiElement instanceof KtUserType)) {
            psiElement = null;
        }
        if ((ktUserType2 = (KtUserType)psiElement) != null && (ktUserType = ktUserType2.getQualifier()) != null) {
            KtUserType qualifier2 = ktUserType;
            boolean bl = false;
            String fqName2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)SequencesKt.toList((Sequence)SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object>(qualifier2, null){
                Object L$1;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ KtUserType $qualifier;
                {
                    this.$qualifier = $qualifier;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = (SequenceScope)this.L$0;
                    var4_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    block0 : switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            q = this.$qualifier;
lbl7:
                            // 2 sources

                            while (true) {
                                v0 = q;
                                if ((v0 != null ? v0.getReferencedName() : null) == null || (v1 /* !! */  = q) == null || (v1 /* !! */  = v1 /* !! */ .getReferencedName()) == null) break block0;
                                this.L$0 = $this$sequence;
                                this.L$1 = q;
                                this.label = 1;
                                v2 = $this$sequence.yield((Object)v1 /* !! */ , (Continuation)this);
                                if (v2 == var4_3) {
                                    return var4_3;
                                }
                                ** GOTO lbl21
                                break;
                            }
                        }
                        case 1: {
                            q = (KtUserType)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl21:
                            // 2 sources

                            v3 = q;
                            q = v3 != null ? v3.getQualifier() : null;
                            ** continue;
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(SequenceScope<? super String> p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            })))), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
            return Intrinsics.areEqual((Object)fqName2, (Object)this.targetPackage) ? Result.Ambiguity : Result.FoundOther;
        }
        return null;
    }

    private final Result changeTo(Result $this$changeTo, Result newResult) {
        if ($this$changeTo == Result.NothingFound || $this$changeTo.getReturnValue() == newResult.getReturnValue()) {
            return newResult;
        }
        return Result.Ambiguity;
    }

    private static final Unit _init_$lambda$0(PsiBasedClassResolver this$0, PsiClass $target) {
        this$0.findPotentialClassConflicts($target);
        this$0.findPotentialTypeAliasConflicts($target);
        return Unit.INSTANCE;
    }

    private static final PsiElement canBeTargetReference$lambda$2(KtAnnotationEntry $this$getParentOfTypeAndBranch) {
        Intrinsics.checkNotNullParameter((Object)$this$getParentOfTypeAndBranch, (String)"$this$getParentOfTypeAndBranch");
        return (PsiElement)$this$getParentOfTypeAndBranch.getTypeReference();
    }

    public /* synthetic */ PsiBasedClassResolver(PsiClass target, DefaultConstructorMarker $constructor_marker) {
        this(target);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012R\u0013\u0010\u0004\u001a\u00020\u00058G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u00020\u00058G\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0013\u0010\n\u001a\u00020\u00058G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/search/PsiBasedClassResolver$Companion;", "", "<init>", "()V", "attempts", "Ljava/util/concurrent/atomic/AtomicInteger;", "getAttempts", "()Ljava/util/concurrent/atomic/AtomicInteger;", "trueHits", "getTrueHits", "falseHits", "getFalseHits", "PSI_BASED_CLASS_RESOLVER_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/CachedValue;", "Lorg/jetbrains/kotlin/idea/search/PsiBasedClassResolver;", "getInstance", "target", "Lcom/intellij/psi/PsiClass;", "kotlin.base.analysis"})
    @SourceDebugExtension(value={"SMAP\nPsiBasedClassResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsiBasedClassResolver.kt\norg/jetbrains/kotlin/idea/search/PsiBasedClassResolver$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,256:1\n1#2:257\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @TestOnly
        @NotNull
        public final AtomicInteger getAttempts() {
            return attempts;
        }

        @TestOnly
        @NotNull
        public final AtomicInteger getTrueHits() {
            return trueHits;
        }

        @TestOnly
        @NotNull
        public final AtomicInteger getFalseHits() {
            return falseHits;
        }

        @NotNull
        public final PsiBasedClassResolver getInstance(@NotNull PsiClass target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            CachedValue cachedValue2 = (CachedValue)target.getUserData(PSI_BASED_CLASS_RESOLVER_KEY);
            if (cachedValue2 != null) {
                CachedValue it = cachedValue2;
                boolean bl = false;
                Object object = it.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
                return (PsiBasedClassResolver)object;
            }
            CachedValue cachedValue3 = CachedValuesManager.getManager((Project)target.getProject()).createCachedValue(() -> Companion.getInstance$lambda$1(target), false);
            Intrinsics.checkNotNullExpressionValue((Object)cachedValue3, (String)"createCachedValue(...)");
            CachedValue cachedValue4 = cachedValue3;
            target.putUserData(PSI_BASED_CLASS_RESOLVER_KEY, (Object)cachedValue4);
            Object object = cachedValue4.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (PsiBasedClassResolver)object;
        }

        private static final CachedValueProvider.Result getInstance$lambda$1(PsiClass $target) {
            PsiBasedClassResolver psiBasedClassResolver = new PsiBasedClassResolver($target, null);
            Object[] objectArray = new Object[1];
            Project project = $target.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            objectArray[0] = KotlinModificationTrackerFactory.Companion.getInstance(project).createProjectWideSourceModificationTracker();
            return new CachedValueProvider.Result((Object)psiBasedClassResolver, objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/search/PsiBasedClassResolver$Result;", "", "returnValue", "Lorg/jetbrains/kotlin/asJava/ImpreciseResolveResult;", "<init>", "(Ljava/lang/String;ILorg/jetbrains/kotlin/asJava/ImpreciseResolveResult;)V", "getReturnValue", "()Lorg/jetbrains/kotlin/asJava/ImpreciseResolveResult;", "NothingFound", "Found", "FoundOther", "Ambiguity", "kotlin.base.analysis"})
    public static final class Result
    extends Enum<Result> {
        @NotNull
        private final ImpreciseResolveResult returnValue;
        public static final /* enum */ Result NothingFound = new Result(ImpreciseResolveResult.NO_MATCH);
        public static final /* enum */ Result Found = new Result(ImpreciseResolveResult.MATCH);
        public static final /* enum */ Result FoundOther = new Result(ImpreciseResolveResult.NO_MATCH);
        public static final /* enum */ Result Ambiguity = new Result(ImpreciseResolveResult.UNSURE);
        private static final /* synthetic */ Result[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Result(ImpreciseResolveResult returnValue) {
            this.returnValue = returnValue;
        }

        @NotNull
        public final ImpreciseResolveResult getReturnValue() {
            return this.returnValue;
        }

        public static Result[] values() {
            return (Result[])$VALUES.clone();
        }

        public static Result valueOf(String value) {
            return Enum.valueOf(Result.class, value);
        }

        @NotNull
        public static EnumEntries<Result> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = resultArray = new Result[]{Result.NothingFound, Result.Found, Result.FoundOther, Result.Ambiguity};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

