/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.core.DescriptorUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000 )*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003:\u0001)B+\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00028\u0000\u0012\b\b\u0001\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0018\u001a\u00020\u0019H\u0014J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001bH\u0002J,\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u00022\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0!H\u0002J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$H\u0004J\u0016\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020\u001bH$J\u0006\u0010(\u001a\u00020\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\b\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/CallableRefactoring;", "T", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "callableDescriptor", "commandName", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getCallableDescriptor", "()Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getCommandName", "()Ljava/lang/String;", "kind", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor$Kind;", "forcePerformForSelectedFunctionOnly", "", "getClosestModifiableDescriptors", "", "showSuperFunctionWarningDialog", "", "superCallables", "callableFromEditor", "options", "", "checkModifiable", "element", "Lcom/intellij/psi/PsiElement;", "performRefactoring", "", "descriptorsForChange", "run", "Companion", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nCallableRefactoring.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallableRefactoring.kt\norg/jetbrains/kotlin/idea/refactoring/CallableRefactoring\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,231:1\n1563#2:232\n1634#2,3:233\n37#3:236\n36#3,3:237\n1#4:240\n73#5:241\n*S KotlinDebug\n*F\n+ 1 CallableRefactoring.kt\norg/jetbrains/kotlin/idea/refactoring/CallableRefactoring\n*L\n66#1:232\n66#1:233,3\n85#1:236\n85#1:237,3\n128#1:241\n*E\n"})
public abstract class CallableRefactoring<T extends CallableDescriptor> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private final Editor editor;
    @NotNull
    private final T callableDescriptor;
    @NotNull
    private final String commandName;
    @NotNull
    private final CallableMemberDescriptor.Kind kind;
    @NotNull
    private static final Logger LOG;

    public CallableRefactoring(@NotNull Project project, @Nullable Editor editor, @NotNull T callableDescriptor, @NlsContexts.Command @NotNull String commandName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(callableDescriptor, (String)"callableDescriptor");
        Intrinsics.checkNotNullParameter((Object)commandName, (String)"commandName");
        this.project = project;
        this.editor = editor;
        this.callableDescriptor = callableDescriptor;
        this.commandName = commandName;
        T t = this.callableDescriptor;
        CallableMemberDescriptor callableMemberDescriptor = t instanceof CallableMemberDescriptor ? (CallableMemberDescriptor)t : null;
        if (callableMemberDescriptor == null || (callableMemberDescriptor = callableMemberDescriptor.getKind()) == null) {
            callableMemberDescriptor = CallableMemberDescriptor.Kind.DECLARATION;
        }
        this.kind = callableMemberDescriptor;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final T getCallableDescriptor() {
        return this.callableDescriptor;
    }

    @NotNull
    public final String getCommandName() {
        return this.commandName;
    }

    protected boolean forcePerformForSelectedFunctionOnly() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<CallableDescriptor> getClosestModifiableDescriptors() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = switch (WhenMappings.$EnumSwitchMapping$0[this.kind.ordinal()]) {
            case 1 -> SetsKt.setOf(this.callableDescriptor);
            case 2, 3 -> {
                T v1 = this.callableDescriptor;
                Intrinsics.checkNotNull(v1, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableMemberDescriptor");
                yield DescriptorUtilsKt.getDirectlyOverriddenDeclarations((CallableMemberDescriptor)v1);
            }
            default -> throw new IllegalStateException("Unexpected callable kind: " + this.kind);
        };
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CallableDescriptor callableDescriptor = (CallableDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            DeclarationDescriptor declarationDescriptor = ExpectActualUtilKt.liftToExpected((DeclarationDescriptor)it);
            CallableDescriptor callableDescriptor2 = declarationDescriptor instanceof CallableDescriptor ? (CallableDescriptor)declarationDescriptor : null;
            if (callableDescriptor2 == null) {
                callableDescriptor2 = it;
            }
            collection.add(callableDescriptor2);
        }
        return (List)destination$iv$iv;
    }

    private final int showSuperFunctionWarningDialog(Collection<? extends CallableDescriptor> superCallables, CallableDescriptor callableFromEditor, List<String> options2) {
        String superString = CollectionsKt.joinToString$default((Iterable)superCallables, (CharSequence)",\n    ", (CharSequence)"\n    ", (CharSequence)".\n\n", (int)0, null, CallableRefactoring::showSuperFunctionWarningDialog$lambda$1, (int)24, null);
        Object[] objectArray = new Object[]{DescriptorRenderer.COMPACT.render((DeclarationDescriptor)callableFromEditor), superString, "refactor"};
        String message2 = KotlinBundle.message((String)"override.declaration.x.overrides.y.in.class.list", (Object[])objectArray);
        String string = IdeBundle.message((String)"title.warning", (Object[])new Object[0]);
        Intrinsics.checkNotNull((Object)string);
        String title = string;
        Icon icon2 = Messages.getQuestionIcon();
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"getQuestionIcon(...)");
        Icon icon3 = icon2;
        Collection $this$toTypedArray$iv = options2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return Messages.showDialog((String)message2, (String)title, (String[])thisCollection$iv.toArray(new String[0]), (int)0, (Icon)icon3);
    }

    protected final boolean checkModifiable(@NotNull PsiElement element) {
        String unmodifiableFileName;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (KotlinRefactoringUtilKt.canRefactor(element)) {
            return true;
        }
        PsiFile psiFile = element.getContainingFile();
        String string = unmodifiableFileName = psiFile != null ? psiFile.getName() : null;
        if (unmodifiableFileName != null) {
            String string2 = RefactoringBundle.message((String)"refactoring.cannot.be.performed");
            Object[] objectArray = new Object[2];
            Intrinsics.checkNotNullExpressionValue((Object)DescriptiveNameUtil.getDescriptiveName((PsiElement)element), (String)"getDescriptiveName(...)");
            objectArray[1] = unmodifiableFileName;
            String message2 = string2 + "\n" + KotlinBundle.message((String)"error.hint.cannot.modify.0.declaration.from.1.file", (Object[])objectArray);
            CommonRefactoringUtil.showErrorHint((Project)this.project, (Editor)this.editor, (String)message2, (String)CommonBundle.getErrorTitle(), null);
        } else {
            LOG.error("Could not find file for Psi element: " + element.getText());
        }
        return false;
    }

    protected abstract void performRefactoring(@NotNull Collection<? extends CallableDescriptor> var1);

    public final boolean run() {
        boolean bl;
        if (this.kind == CallableMemberDescriptor.Kind.SYNTHESIZED) {
            LOG.error("Change signature refactoring should not be called for synthesized member " + this.callableDescriptor);
            return false;
        }
        Collection<CallableDescriptor> closestModifiableDescriptors = this.getClosestModifiableDescriptors();
        if (this.forcePerformForSelectedFunctionOnly()) {
            this.performRefactoring(closestModifiableDescriptors);
            return true;
        }
        boolean bl2 = bl = !closestModifiableDescriptors.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-CallableRefactoring$run$22 = false;
            String $i$a$-assert-CallableRefactoring$run$22 = "Should contain original declaration or some of its super declarations";
            throw new AssertionError((Object)$i$a$-assert-CallableRefactoring$run$22);
        }
        T t = this.callableDescriptor;
        Object object = t instanceof CallableMemberDescriptor ? (CallableMemberDescriptor)t : null;
        if (object == null || (object = DescriptorUtilsKt.getDeepestSuperDeclarations$default(object, false, 1, null)) == null) {
            object = CollectionsKt.listOf(this.callableDescriptor);
        }
        Object deepestSuperDeclarations2 = object;
        boolean $i$f$isUnitTestMode = false;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.performRefactoring((Collection<CallableDescriptor>)deepestSuperDeclarations2);
            return true;
        }
        if (closestModifiableDescriptors.size() == 1 && CollectionsKt.subtract((Iterable)((Iterable)deepestSuperDeclarations2), (Iterable)closestModifiableDescriptors).isEmpty()) {
            this.performRefactoring(closestModifiableDescriptors);
            return true;
        }
        boolean isSingleFunctionSelected = closestModifiableDescriptors.size() == 1;
        T selectedFunction = isSingleFunctionSelected ? (CallableDescriptor)CollectionsKt.first((Iterable)closestModifiableDescriptors) : this.callableDescriptor;
        List<String> optionsForDialog = CallableRefactoring.run$buildDialogOptions(isSingleFunctionSelected);
        int code = this.showSuperFunctionWarningDialog((Collection<? extends CallableDescriptor>)((Collection<CallableDescriptor>)deepestSuperDeclarations2), (CallableDescriptor)selectedFunction, optionsForDialog);
        if (CallableRefactoring.run$performForWholeHierarchy(optionsForDialog, code)) {
            this.performRefactoring((Collection<CallableDescriptor>)deepestSuperDeclarations2);
        } else if (CallableRefactoring.run$performForSelectedFunctionOnly(optionsForDialog, code)) {
            this.performRefactoring(closestModifiableDescriptors);
        } else {
            return false;
        }
        return true;
    }

    private static final CharSequence showSuperFunctionWarningDialog$lambda$1(CallableDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getContainingDeclaration().getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        return string;
    }

    private static final boolean run$buttonPressed(int code, List<String> dialogButtons, String button) {
        return code == dialogButtons.indexOf(button) && dialogButtons.contains(button);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean run$performForWholeHierarchy(List<String> dialogButtons, int code) {
        String string = Messages.getYesButton();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getYesButton(...)");
        if (CallableRefactoring.run$buttonPressed(code, dialogButtons, string)) return true;
        String string2 = Messages.getOkButton();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getOkButton(...)");
        if (!CallableRefactoring.run$buttonPressed(code, dialogButtons, string2)) return false;
        return true;
    }

    private static final boolean run$performForSelectedFunctionOnly(List<String> dialogButtons, int code) {
        String string = Messages.getNoButton();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNoButton(...)");
        return CallableRefactoring.run$buttonPressed(code, dialogButtons, string);
    }

    private static final List<String> run$buildDialogOptions(boolean isSingleFunctionSelected) {
        List list2;
        if (isSingleFunctionSelected) {
            Object[] objectArray = new String[]{Messages.getYesButton(), Messages.getNoButton(), Messages.getCancelButton()};
            list2 = CollectionsKt.arrayListOf((Object[])objectArray);
        } else {
            Object[] objectArray = new String[]{Messages.getOkButton(), Messages.getCancelButton()};
            list2 = CollectionsKt.arrayListOf((Object[])objectArray);
        }
        return list2;
    }

    static {
        Logger logger = Logger.getInstance(CallableRefactoring.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/CallableRefactoring$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CallableMemberDescriptor.Kind.values().length];
            try {
                nArray[CallableMemberDescriptor.Kind.DECLARATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CallableMemberDescriptor.Kind.DELEGATION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CallableMemberDescriptor.Kind.FAKE_OVERRIDE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

