/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.ConvertTrimIndentToTrimMarginIntention;
import org.jetbrains.kotlin.idea.intentions.ConvertTrimMarginToTrimIndentIntentionKt;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertTrimMarginToTrimIndentIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "<init>", "()V", "isApplicableTo", "", "element", "caretOffset", "", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nConvertTrimMarginToTrimIndentIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertTrimMarginToTrimIndentIntention.kt\norg/jetbrains/kotlin/idea/intentions/ConvertTrimMarginToTrimIndentIntention\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,65:1\n12434#2:66\n12435#2:71\n13472#2:72\n13473#2:77\n413#3,4:67\n413#3,4:73\n*S KotlinDebug\n*F\n+ 1 ConvertTrimMarginToTrimIndentIntention.kt\norg/jetbrains/kotlin/idea/intentions/ConvertTrimMarginToTrimIndentIntention\n*L\n31#1:66\n31#1:71\n42#1:72\n42#1:77\n32#1:67,4\n46#1:73,4\n*E\n"})
public final class ConvertTrimMarginToTrimIndentIntention
extends SelfTargetingIntention<KtCallExpression> {
    public ConvertTrimMarginToTrimIndentIntention() {
        super(KtCallExpression.class, KotlinBundle.lazyMessage((String)"convert.to.trim.indent", (Object[])new Object[0]), null, 4, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicableTo(@NotNull KtCallExpression element, int caretOffset) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)((KtElement)element));
        KtExpression ktExpression = ktQualifiedExpression != null ? ktQualifiedExpression.getReceiverExpression() : null;
        if (!(ktExpression instanceof KtStringTemplateExpression)) return false;
        KtStringTemplateExpression ktStringTemplateExpression = (KtStringTemplateExpression)ktExpression;
        if (ktStringTemplateExpression == null) {
            return false;
        }
        KtStringTemplateExpression template2 = ktStringTemplateExpression;
        String string = template2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (!StringsKt.startsWith$default((String)string, (String)"\"\"\"", (boolean)false, (int)2, null)) {
            return false;
        }
        KtExpression ktExpression2 = element.getCalleeExpression();
        if (ktExpression2 == null) {
            return false;
        }
        KtExpression callee = ktExpression2;
        if (!Intrinsics.areEqual((Object)callee.getText(), (Object)"trimMargin")) return false;
        CallableDescriptor callableDescriptor = UtilsKt.getCallableDescriptor(callee);
        if (!Intrinsics.areEqual((Object)(callableDescriptor != null ? DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)callableDescriptor)) : null), (Object)new FqName("kotlin.text.trimMargin"))) {
            return false;
        }
        if (!ConvertTrimIndentToTrimMarginIntention.Holder.INSTANCE.isSurroundedByLineBreaksOrBlanks(template2)) {
            return false;
        }
        String string2 = ConvertTrimMarginToTrimIndentIntentionKt.access$marginPrefix(element);
        if (string2 == null) {
            return false;
        }
        String marginPrefix = string2;
        KtStringTemplateEntry[] ktStringTemplateEntryArray = template2.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"getEntries(...)");
        Object[] $this$all$iv = ktStringTemplateEntryArray;
        boolean $i$f$all = false;
        int n = 0;
        int n2 = $this$all$iv.length;
        while (n < n2) {
            Object element$iv = $this$all$iv[n];
            KtStringTemplateEntry entry = (KtStringTemplateEntry)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)entry);
            if (ConvertTrimIndentToTrimMarginIntention.Holder.INSTANCE.isStartOfLine(entry)) {
                String string3;
                block10: {
                    String $this$dropWhile$iv;
                    Intrinsics.checkNotNullExpressionValue((Object)entry.getText(), (String)"getText(...)");
                    boolean $i$f$dropWhile = false;
                    int n3 = ((CharSequence)$this$dropWhile$iv).length();
                    for (int index$iv = 0; index$iv < n3; ++index$iv) {
                        char it = $this$dropWhile$iv.charAt(index$iv);
                        boolean bl2 = false;
                        if (CharsKt.isWhitespace((char)it)) continue;
                        String string4 = $this$dropWhile$iv.substring(index$iv);
                        string3 = string4;
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                        break block10;
                    }
                    string3 = "";
                }
                if (!StringsKt.startsWith$default((String)string3, (String)marginPrefix, (boolean)false, (int)2, null)) return false;
            }
            boolean bl3 = true;
            if (!bl3) {
                return false;
            }
            ++n;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyTo(@NotNull KtCallExpression element, @Nullable Editor editor) {
        StringBuilder stringBuilder;
        KtQualifiedExpression qualifiedExpression;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtQualifiedExpression ktQualifiedExpression = qualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)((KtElement)element));
        KtExpression ktExpression = ktQualifiedExpression != null ? ktQualifiedExpression.getReceiverExpression() : null;
        KtStringTemplateExpression ktStringTemplateExpression = ktExpression instanceof KtStringTemplateExpression ? (KtStringTemplateExpression)ktExpression : null;
        if (ktStringTemplateExpression == null) {
            return;
        }
        KtStringTemplateExpression template2 = ktStringTemplateExpression;
        String string = ConvertTrimMarginToTrimIndentIntentionKt.access$marginPrefix(element);
        if (string == null) {
            return;
        }
        String marginPrefix = string;
        String indent = ConvertTrimIndentToTrimMarginIntention.Holder.INSTANCE.calculateIndent(template2);
        StringBuilder $this$applyTo_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        KtStringTemplateEntry[] ktStringTemplateEntryArray = template2.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"getEntries(...)");
        Object[] $this$forEach$iv = ktStringTemplateEntryArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StringBuilder stringBuilder2;
            KtStringTemplateEntry entry = (KtStringTemplateEntry)element$iv;
            boolean bl2 = false;
            String text = entry.getText();
            Intrinsics.checkNotNull((Object)entry);
            if (ConvertTrimIndentToTrimMarginIntention.Holder.INSTANCE.isStartOfLine(entry)) {
                String string2;
                StringBuilder stringBuilder3;
                block5: {
                    void $this$dropWhile$iv;
                    $this$applyTo_u24lambda_u244.append(indent);
                    Intrinsics.checkNotNullExpressionValue((Object)entry.getText(), (String)"getText(...)");
                    stringBuilder3 = $this$applyTo_u24lambda_u244;
                    boolean $i$f$dropWhile = false;
                    int n = ((CharSequence)$this$dropWhile$iv).length();
                    for (int index$iv = 0; index$iv < n; ++index$iv) {
                        char it = $this$dropWhile$iv.charAt(index$iv);
                        boolean bl3 = false;
                        if (CharsKt.isWhitespace((char)it)) continue;
                        String string3 = $this$dropWhile$iv.substring(index$iv);
                        string2 = string3;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                        break block5;
                    }
                    string2 = "";
                }
                stringBuilder2 = stringBuilder3.append(StringsKt.replaceFirst$default((String)string2, (String)marginPrefix, (String)"", (boolean)false, (int)4, null));
                continue;
            }
            stringBuilder2 = $this$applyTo_u24lambda_u244.append(text);
        }
        String newTemplate = stringBuilder.toString();
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        qualifiedExpression.replace((PsiElement)new KtPsiFactory(project, false, 2, null).createExpression("\"\"\"" + newTemplate + "\"\"\".trimIndent()"));
    }
}

