/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.UtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.highlighter.ReceiverUsageCollector;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0014\u0015\u0016B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH$J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH$J\u001c\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00100\u0012H\u0016R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0003\u0017\u0018\u0019\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/ReceiverInfo;", "", "<init>", "()V", "psi", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "getPsi", "()Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "getDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "elementsToProcess", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/psi/KtElement;", "collectReceiverUsages", "", "consumer", "Lkotlin/Function1;", "Lcom/intellij/openapi/util/TextRange;", "Function", "Property", "Lambda", "Lorg/jetbrains/kotlin/idea/highlighter/ReceiverInfo$Function;", "Lorg/jetbrains/kotlin/idea/highlighter/ReceiverInfo$Lambda;", "Lorg/jetbrains/kotlin/idea/highlighter/ReceiverInfo$Property;", "kotlin.highlighting.k1"})
public abstract class ReceiverInfo {
    private ReceiverInfo() {
    }

    @NotNull
    public abstract KtCallableDeclaration getPsi();

    @Nullable
    protected abstract CallableDescriptor getDescriptor(@NotNull BindingContext var1);

    @NotNull
    protected abstract Sequence<KtElement> elementsToProcess();

    public void collectReceiverUsages(@NotNull Function1<? super TextRange, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        BindingContext bindingContext = ResolutionUtils.safeAnalyze((KtElement)this.getPsi(), BodyResolveMode.PARTIAL);
        CallableDescriptor callableDescriptor = this.getDescriptor(bindingContext);
        if (callableDescriptor == null) {
            return;
        }
        CallableDescriptor callableDescriptor2 = callableDescriptor;
        ReceiverUsageCollector visitor2 = new ReceiverUsageCollector(callableDescriptor2, consumer);
        for (KtElement element : this.elementsToProcess()) {
            element.accept((KtVisitor)visitor2, (Object)Unit.INSTANCE);
        }
    }

    public /* synthetic */ ReceiverInfo(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u001c\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\r0\u000fH\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/ReceiverInfo$Function;", "Lorg/jetbrains/kotlin/idea/highlighter/ReceiverInfo;", "psi", "Lorg/jetbrains/kotlin/psi/KtFunction;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFunction;)V", "getPsi", "()Lorg/jetbrains/kotlin/psi/KtFunction;", "getDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "collectReceiverUsages", "", "consumer", "Lkotlin/Function1;", "Lcom/intellij/openapi/util/TextRange;", "elementsToProcess", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/psi/KtElement;", "kotlin.highlighting.k1"})
    public static final class Function
    extends ReceiverInfo {
        @NotNull
        private final KtFunction psi;

        public Function(@NotNull KtFunction psi) {
            Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
            super(null);
            this.psi = psi;
        }

        @NotNull
        public KtFunction getPsi() {
            return this.psi;
        }

        @Override
        @Nullable
        protected CallableDescriptor getDescriptor(@NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            Object object = bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)this.getPsi());
            return object instanceof CallableDescriptor ? (CallableDescriptor)object : null;
        }

        @Override
        public void collectReceiverUsages(@NotNull Function1<? super TextRange, Unit> consumer) {
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            KtTypeReference ktTypeReference = this.getPsi().getReceiverTypeReference();
            if (ktTypeReference != null && (ktTypeReference = ktTypeReference.getTextRange()) != null) {
                consumer.invoke((Object)ktTypeReference);
            }
            super.collectReceiverUsages(consumer);
        }

        @Override
        @NotNull
        protected Sequence<KtElement> elementsToProcess() {
            Sequence sequence = UtilKt.sequenceOfNotNull((Object)this.getPsi().getBodyExpression());
            List list2 = this.getPsi().getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
            return SequencesKt.plus((Sequence)sequence, (Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list2), Function::elementsToProcess$lambda$0));
        }

        private static final KtExpression elementsToProcess$lambda$0(KtParameter it) {
            return it.getDefaultValue();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/ReceiverInfo$Lambda;", "Lorg/jetbrains/kotlin/idea/highlighter/ReceiverInfo;", "psi", "Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;)V", "getPsi", "()Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "getDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "elementsToProcess", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/psi/KtElement;", "kotlin.highlighting.k1"})
    public static final class Lambda
    extends ReceiverInfo {
        @NotNull
        private final KtFunctionLiteral psi;

        public Lambda(@NotNull KtFunctionLiteral psi) {
            Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
            super(null);
            this.psi = psi;
        }

        @NotNull
        public KtFunctionLiteral getPsi() {
            return this.psi;
        }

        @Override
        @Nullable
        protected CallableDescriptor getDescriptor(@NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            return (CallableDescriptor)bindingContext.get((ReadOnlySlice)BindingContext.FUNCTION, (Object)this.getPsi());
        }

        @Override
        @NotNull
        protected Sequence<KtElement> elementsToProcess() {
            Sequence sequence = UtilKt.sequenceOfNotNull((Object)this.getPsi().getBodyExpression());
            List list2 = this.getPsi().getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
            return SequencesKt.plus((Sequence)sequence, (Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list2), Lambda::elementsToProcess$lambda$0));
        }

        private static final KtExpression elementsToProcess$lambda$0(KtParameter it) {
            return it.getDefaultValue();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u001c\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\r0\u000fH\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/ReceiverInfo$Property;", "Lorg/jetbrains/kotlin/idea/highlighter/ReceiverInfo;", "psi", "Lorg/jetbrains/kotlin/psi/KtProperty;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtProperty;)V", "getPsi", "()Lorg/jetbrains/kotlin/psi/KtProperty;", "getDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "collectReceiverUsages", "", "consumer", "Lkotlin/Function1;", "Lcom/intellij/openapi/util/TextRange;", "elementsToProcess", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/psi/KtElement;", "kotlin.highlighting.k1"})
    public static final class Property
    extends ReceiverInfo {
        @NotNull
        private final KtProperty psi;

        public Property(@NotNull KtProperty psi) {
            Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
            super(null);
            this.psi = psi;
        }

        @NotNull
        public KtProperty getPsi() {
            return this.psi;
        }

        @Override
        @Nullable
        protected CallableDescriptor getDescriptor(@NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            Object object = bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)this.getPsi());
            return object instanceof CallableDescriptor ? (CallableDescriptor)object : null;
        }

        @Override
        public void collectReceiverUsages(@NotNull Function1<? super TextRange, Unit> consumer) {
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            KtTypeReference ktTypeReference = this.getPsi().getReceiverTypeReference();
            if (ktTypeReference != null && (ktTypeReference = ktTypeReference.getTextRange()) != null) {
                consumer.invoke((Object)ktTypeReference);
            }
            super.collectReceiverUsages(consumer);
        }

        @Override
        @NotNull
        protected Sequence<KtElement> elementsToProcess() {
            List list2 = this.getPsi().getAccessors();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAccessors(...)");
            return CollectionsKt.asSequence((Iterable)list2);
        }
    }
}

