/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.findUsages.similarity;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.usages.similarity.bag.Bag;
import com.intellij.usages.similarity.features.UsageSimilarityFeaturesRecorder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtContainerNodeForControlStructureBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010\u0011\u001a\u00020%H\u0002J\b\u0010*\u001a\u00020\u0010H\u0002J\u0010\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020\u00102\u0006\u0010/\u001a\u000200H\u0002J\u0018\u00101\u001a\u00020\u00102\u0006\u00102\u001a\u00020'2\u0006\u00103\u001a\u000204H\u0002J\u0010\u00105\u001a\u00020\u00102\u0006\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u00020\u00102\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010;\u001a\u00020\u00102\u0006\u0010<\u001a\u00020=H\u0002J\u0010\u0010>\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/jetbrains/kotlin/idea/findUsages/similarity/KotlinSimilarityFeaturesExtractor;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "element", "Lcom/intellij/psi/PsiElement;", "context", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;)V", "usageSimilarityFeaturesRecorder", "Lcom/intellij/usages/similarity/features/UsageSimilarityFeaturesRecorder;", "variableNames", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "getFeatures", "Lcom/intellij/usages/similarity/bag/Bag;", "visitStringTemplateExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitBinaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitIsExpression", "Lorg/jetbrains/kotlin/psi/KtIsExpression;", "visitLambdaExpression", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "visitUnaryExpression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "visitTypeReference", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "visitReferenceExpression", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "visitBlockExpression", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "fieldOrMethodReference", "", "collectVariableNames", "collectForExpressionParameterName", "forExpression", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "collectWhenExpressionParameterName", "whenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "collectVariableNamesFromBlock", "blockExpression", "untilOffset", "", "collectDestructuringDeclarationNames", "destructuringDeclaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "collectFunctionParametersNames", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "collectParameterNames", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "collectPropertyName", "kotlin.base.analysis"})
@SourceDebugExtension(value={"SMAP\nKotlinSimilarityFeaturesExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSimilarityFeaturesExtractor.kt\norg/jetbrains/kotlin/idea/findUsages/similarity/KotlinSimilarityFeaturesExtractor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n1#2:148\n*E\n"})
public final class KotlinSimilarityFeaturesExtractor
extends KtTreeVisitorVoid {
    @NotNull
    private final PsiElement context;
    @NotNull
    private final UsageSimilarityFeaturesRecorder usageSimilarityFeaturesRecorder;
    @NotNull
    private final HashSet<String> variableNames;

    public KotlinSimilarityFeaturesExtractor(@NotNull PsiElement element, @NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.usageSimilarityFeaturesRecorder = new UsageSimilarityFeaturesRecorder(this.context, element);
        this.variableNames = new HashSet();
    }

    @NotNull
    public final Bag getFeatures() {
        this.collectVariableNames();
        this.context.accept((PsiElementVisitor)this);
        Bag bag = this.usageSimilarityFeaturesRecorder.getFeatures();
        Intrinsics.checkNotNullExpressionValue((Object)bag, (String)"getFeatures(...)");
        return bag;
    }

    public void visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.usageSimilarityFeaturesRecorder.addAllFeatures((PsiElement)expression, "literal: string");
        super.visitStringTemplateExpression(expression);
    }

    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        this.usageSimilarityFeaturesRecorder.addAllFeatures((PsiElement)property, "PROPERTY: ");
        super.visitProperty(property);
    }

    public void visitCallExpression(@NotNull KtCallExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        KtExpression calleeExpression = expression.getCalleeExpression();
        if (calleeExpression instanceof KtNameReferenceExpression) {
            this.usageSimilarityFeaturesRecorder.addAllFeatures((PsiElement)expression, "{CALL: " + ((KtNameReferenceExpression)calleeExpression).getReferencedName() + "}");
        }
        super.visitCallExpression(expression);
    }

    public void visitBinaryExpression(@NotNull KtBinaryExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.usageSimilarityFeaturesRecorder.addAllFeatures((PsiElement)expression, expression.getOperationToken().toString());
        super.visitBinaryExpression(expression);
    }

    public void visitIsExpression(@NotNull KtIsExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.usageSimilarityFeaturesRecorder.addAllFeatures((PsiElement)expression, "instanceof");
        super.visitIsExpression(expression);
    }

    public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression) {
        Intrinsics.checkNotNullParameter((Object)lambdaExpression, (String)"lambdaExpression");
        this.usageSimilarityFeaturesRecorder.addAllFeatures((PsiElement)lambdaExpression, "lambda");
        super.visitLambdaExpression(lambdaExpression);
    }

    public void visitUnaryExpression(@NotNull KtUnaryExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.usageSimilarityFeaturesRecorder.addAllFeatures((PsiElement)expression, expression.getOperationToken().toString());
        super.visitUnaryExpression(expression);
    }

    public void visitTypeReference(@NotNull KtTypeReference typeReference) {
        Intrinsics.checkNotNullParameter((Object)typeReference, (String)"typeReference");
        this.usageSimilarityFeaturesRecorder.addAllFeatures((PsiElement)typeReference, "TYPE: " + typeReference.nameForReceiverLabel());
        super.visitTypeReference(typeReference);
    }

    public void visitReferenceExpression(@NotNull KtReferenceExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        PsiElement parent2 = expression.getParent();
        String feature = (this.fieldOrMethodReference(expression) || parent2 instanceof KtUserType) && expression instanceof KtNameReferenceExpression ? "{REFERENCE: " + ((KtNameReferenceExpression)expression).getReferencedName() + "}" : "REFERENCE: ";
        this.usageSimilarityFeaturesRecorder.addAllFeatures((PsiElement)expression, feature);
        super.visitReferenceExpression(expression);
    }

    public void visitBlockExpression(@NotNull KtBlockExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (expression.getParent() instanceof KtContainerNodeForControlStructureBody && expression.getStatements().size() > 1) {
            this.usageSimilarityFeaturesRecorder.addAllFeatures((PsiElement)expression, "COMPLEX_BODY");
        } else {
            super.visitBlockExpression(expression);
        }
    }

    private final boolean fieldOrMethodReference(KtReferenceExpression expression) {
        return expression instanceof KtNameReferenceExpression && !this.variableNames.contains(((KtNameReferenceExpression)expression).getReferencedName());
    }

    private final void collectVariableNames() {
        PsiElement currentElement = this.context;
        while (!(currentElement instanceof PsiFile) && currentElement.getParent() != null) {
            PsiElement parent2;
            int startOffsetInParent = currentElement.getStartOffsetInParent();
            PsiElement psiElement = parent2;
            if (psiElement instanceof KtBlockExpression) {
                this.collectVariableNamesFromBlock((KtBlockExpression)parent2, startOffsetInParent);
            } else if (psiElement instanceof KtFunction) {
                this.collectFunctionParametersNames((KtFunction)parent2);
            } else if (psiElement instanceof KtWhenExpression) {
                this.collectWhenExpressionParameterName((KtWhenExpression)parent2);
            } else if (psiElement instanceof KtForExpression) {
                this.collectForExpressionParameterName((KtForExpression)parent2);
            }
            currentElement = parent2;
        }
    }

    private final void collectForExpressionParameterName(KtForExpression forExpression) {
        block0: {
            KtParameter ktParameter = forExpression.getLoopParameter();
            if (ktParameter == null) break block0;
            KtParameter p0 = ktParameter;
            boolean bl = false;
            this.collectParameterNames(p0);
        }
    }

    private final void collectWhenExpressionParameterName(KtWhenExpression whenExpression) {
        KtExpression ktExpression = whenExpression.getSubjectExpression();
        KtProperty ktProperty = ktExpression instanceof KtProperty ? (KtProperty)ktExpression : null;
        if (ktProperty == null) {
            return;
        }
        KtProperty property = ktProperty;
        this.collectPropertyName(property);
    }

    private final void collectVariableNamesFromBlock(KtBlockExpression blockExpression, int untilOffset) {
        KtExpression statement;
        Iterator iterator2 = blockExpression.getStatements().iterator();
        while (iterator2.hasNext() && (statement = (KtExpression)iterator2.next()).getStartOffsetInParent() < untilOffset) {
            KtExpression ktExpression = statement;
            if (ktExpression instanceof KtProperty) {
                this.collectPropertyName((KtProperty)statement);
                continue;
            }
            if (!(ktExpression instanceof KtDestructuringDeclaration)) continue;
            this.collectDestructuringDeclarationNames((KtDestructuringDeclaration)statement);
        }
    }

    private final void collectDestructuringDeclarationNames(KtDestructuringDeclaration destructuringDeclaration) {
        for (KtDestructuringDeclarationEntry entry : destructuringDeclaration.getEntries()) {
            String string;
            if (entry.getName() == null) continue;
            HashSet<String> hashSet = this.variableNames;
            String p0 = string;
            boolean bl = false;
            hashSet.add(p0);
        }
    }

    private final void collectFunctionParametersNames(KtFunction function) {
        if (function instanceof KtFunctionLiteral) {
            ((Collection)this.variableNames).add(StandardNames.IMPLICIT_LAMBDA_PARAMETER_NAME.getIdentifier());
        }
        for (KtParameter valueParameter : function.getValueParameters()) {
            Intrinsics.checkNotNull((Object)valueParameter);
            this.collectParameterNames(valueParameter);
        }
    }

    private final void collectParameterNames(KtParameter parameter) {
        block1: {
            String string = parameter.getName();
            if (string != null) {
                String string2 = string;
                HashSet<String> hashSet = this.variableNames;
                String p0 = string2;
                boolean bl = false;
                hashSet.add(p0);
            }
            KtDestructuringDeclaration ktDestructuringDeclaration = parameter.getDestructuringDeclaration();
            if (ktDestructuringDeclaration == null) break block1;
            KtDestructuringDeclaration p0 = ktDestructuringDeclaration;
            boolean bl = false;
            this.collectDestructuringDeclarationNames(p0);
        }
    }

    private final void collectPropertyName(KtProperty property) {
        block0: {
            String string = property.getName();
            if (string == null) break block0;
            String string2 = string;
            HashSet<String> hashSet = this.variableNames;
            String p0 = string2;
            boolean bl = false;
            hashSet.add(p0);
        }
    }
}

