/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOptInMarkedDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "checkers"})
public final class FirOptInMarkedDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirOptInMarkedDeclarationChecker INSTANCE = new FirOptInMarkedDeclarationChecker();

    private FirOptInMarkedDeclarationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        for (FirAnnotation annotation : declaration.getAnnotations()) {
            FirRegularClassSymbol annotationClass;
            if (FirAnnotationHelpersKt.getAnnotationClassForOptInMarker(annotation, context.getSession()) == null) continue;
            AnnotationUseSiteTarget useSiteTarget = annotation.getUseSiteTarget();
            if (declaration instanceof FirPropertyAccessor && ((FirPropertyAccessor)declaration).isGetter() || useSiteTarget == AnnotationUseSiteTarget.PROPERTY_GETTER) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)annotation.getSource()), FirErrors.INSTANCE.getOPT_IN_MARKER_ON_WRONG_TARGET(), (Object)"getter", null, (int)16, null);
            }
            if (useSiteTarget == AnnotationUseSiteTarget.SETTER_PARAMETER || useSiteTarget != AnnotationUseSiteTarget.PROPERTY && useSiteTarget != AnnotationUseSiteTarget.PROPERTY_SETTER && declaration instanceof FirValueParameter && FirAnnotationHelpersKt.getAllowedAnnotationTargets(annotationClass, context.getSession()).contains(KotlinTarget.VALUE_PARAMETER)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)annotation.getSource()), FirErrors.INSTANCE.getOPT_IN_MARKER_ON_WRONG_TARGET(), (Object)"parameter", null, (int)16, null);
            }
            if (declaration instanceof FirProperty && ((FirProperty)declaration).isLocal()) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)annotation.getSource()), FirErrors.INSTANCE.getOPT_IN_MARKER_ON_WRONG_TARGET(), (Object)"variable", null, (int)16, null);
            }
            if (useSiteTarget != AnnotationUseSiteTarget.FIELD && useSiteTarget != AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)annotation.getSource()), FirErrors.INSTANCE.getOPT_IN_MARKER_ON_WRONG_TARGET(), (Object)"field", null, (int)16, null);
        }
        if (!(declaration instanceof FirCallableDeclaration)) {
            return;
        }
        FirReceiverParameter firReceiverParameter = ((FirCallableDeclaration)declaration).getReceiverParameter();
        if (firReceiverParameter == null) {
            return;
        }
        FirReceiverParameter receiver2 = firReceiverParameter;
        for (FirAnnotation annotation : receiver2.getAnnotations()) {
            if (FirAnnotationHelpersKt.getAnnotationClassForOptInMarker(annotation, context.getSession()) == null) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)annotation.getSource()), FirErrors.INSTANCE.getOPT_IN_MARKER_ON_WRONG_TARGET(), (Object)"parameter", null, (int)16, null);
        }
    }
}

