/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.actions.TaskSearchSupport;
import com.intellij.tasks.impl.TaskManagerImpl;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskAutoCompletionListProvider
extends TextFieldWithAutoCompletionListProvider<Task> {
    private final Project myProject;

    public TaskAutoCompletionListProvider(Project project) {
        super(null);
        this.myProject = project;
    }

    protected String getQuickDocHotKeyAdvertisementTail(@NotNull String shortcut) {
        if (shortcut == null) {
            TaskAutoCompletionListProvider.$$$reportNull$$$0(0);
        }
        return "task description and comments";
    }

    @NotNull
    public List<Task> getItems(String prefix, boolean cached, CompletionParameters parameters) {
        List<Task> list = TaskSearchSupport.getItems(TaskManager.getManager((Project)this.myProject), prefix, cached, parameters.isAutoPopup());
        if (list == null) {
            TaskAutoCompletionListProvider.$$$reportNull$$$0(1);
        }
        return list;
    }

    public void setItems(@Nullable Collection variants) {
    }

    public LookupElementBuilder createLookupBuilder(@NotNull Task task) {
        if (task == null) {
            TaskAutoCompletionListProvider.$$$reportNull$$$0(2);
        }
        LookupElementBuilder builder = super.createLookupBuilder((Object)task);
        builder = builder.withLookupString(task.getSummary());
        if (task.isClosed()) {
            builder = builder.strikeout();
        }
        return builder;
    }

    protected InsertHandler<LookupElement> createInsertHandler(final @NotNull Task task) {
        if (task == null) {
            TaskAutoCompletionListProvider.$$$reportNull$$$0(3);
        }
        return new InsertHandler<LookupElement>(){

            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    1.$$$reportNull$$$0(1);
                }
                Document document = context.getEditor().getDocument();
                String s = ((TaskManagerImpl)TaskManager.getManager((Project)context.getProject())).getChangelistName(task);
                s = StringUtil.convertLineSeparators((String)s);
                document.replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)s);
                context.getEditor().getCaretModel().moveToOffset(context.getStartOffset() + s.length());
                TaskAutoCompletionListProvider.this.handleInsert(task);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "item";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/tasks/actions/TaskAutoCompletionListProvider$1";
                objectArray[2] = "handleInsert";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    protected void handleInsert(@NotNull Task task) {
        if (task == null) {
            TaskAutoCompletionListProvider.$$$reportNull$$$0(4);
        }
    }

    protected Icon getIcon(@NotNull Task task) {
        if (task == null) {
            TaskAutoCompletionListProvider.$$$reportNull$$$0(5);
        }
        return task.getIcon();
    }

    @NotNull
    protected String getLookupString(@NotNull Task task) {
        if (task == null) {
            TaskAutoCompletionListProvider.$$$reportNull$$$0(6);
        }
        String string = task.getPresentableId();
        if (string == null) {
            TaskAutoCompletionListProvider.$$$reportNull$$$0(7);
        }
        return string;
    }

    protected String getTailText(@NotNull Task task) {
        if (task == null) {
            TaskAutoCompletionListProvider.$$$reportNull$$$0(8);
        }
        return " " + task.getSummary();
    }

    protected String getTypeText(@NotNull Task task) {
        if (task == null) {
            TaskAutoCompletionListProvider.$$$reportNull$$$0(9);
        }
        return null;
    }

    public int compare(@NotNull Task task1, @NotNull Task task2) {
        if (task1 == null) {
            TaskAutoCompletionListProvider.$$$reportNull$$$0(10);
        }
        if (task2 == null) {
            TaskAutoCompletionListProvider.$$$reportNull$$$0(11);
        }
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcut";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/actions/TaskAutoCompletionListProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task1";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/actions/TaskAutoCompletionListProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickDocHotKeyAdvertisementTail";
                break;
            }
            case 1: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createLookupBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createInsertHandler";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLookupString";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTailText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTypeText";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 7 -> new IllegalStateException(string);
        };
    }
}

