/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.util.ArrayList;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.cmd.AppendRangeCmd;
import tim.prune.data.DataPoint;
import tim.prune.data.RangeStats;
import tim.prune.data.UnitSetLibrary;
import tim.prune.function.DistanceTimeLimitFunction;
import tim.prune.function.PointUtils;

public class CreateMarkerWaypointsFunction
extends DistanceTimeLimitFunction {
    private final ArrayList<DataPoint> _pointsToAdd = new ArrayList();
    private int _previousMultiple = 0;

    public CreateMarkerWaypointsFunction(App app) {
        super(app, true);
    }

    @Override
    public String getNameKey() {
        return "function.createmarkerwaypoints";
    }

    private void initMemory() {
        this._pointsToAdd.clear();
        this._previousMultiple = 0;
    }

    @Override
    protected void performFunction() {
        int n = this.getTimeLimitInSeconds();
        boolean bl = n > 0;
        double d = this.getDistanceLimitKilometres();
        boolean bl2 = d > 0.0;
        boolean bl3 = this.isHalvesSelected();
        this.initMemory();
        if (bl || bl2) {
            this.createWaypointsAtIntervals(n, d);
        } else if (bl3) {
            this.createHalfwayWaypoints();
        } else {
            return;
        }
        if (!this._pointsToAdd.isEmpty()) {
            AppendRangeCmd appendRangeCmd = new AppendRangeCmd(this._pointsToAdd);
            appendRangeCmd.setDescription(this.getName());
            String string = I18nManager.getTextWithNumber("confirm.pointsadded", this._pointsToAdd.size());
            appendRangeCmd.setConfirmText(string);
            this._app.execute(appendRangeCmd);
        }
        this._dialog.dispose();
    }

    private void createWaypointsAtIntervals(int n, double d) {
        boolean bl = n > 0;
        boolean bl2 = d > 0.0;
        DataPoint dataPoint = null;
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = this.getConfig().getConfigInt("prune.altitudetolerance") / 100;
        RangeStats rangeStats = new RangeStats(n2);
        int n3 = this._app.getTrackInfo().getTrack().getNumPoints();
        int n4 = 0;
        while (n4 < n3) {
            DataPoint dataPoint2 = this._app.getTrackInfo().getTrack().getPoint(n4);
            rangeStats.addPoint(dataPoint2);
            if (!dataPoint2.isWaypoint()) {
                if (bl) {
                    d2 = rangeStats.getMovingDurationInSeconds();
                    this.processValue(dataPoint, d3, n, dataPoint2, d2);
                } else if (bl2) {
                    d2 = rangeStats.getMovingDistanceKilometres();
                    this.processValue(dataPoint, d3, d, dataPoint2, d2);
                }
                dataPoint = dataPoint2;
                d3 = d2;
            }
            ++n4;
        }
    }

    private void processValue(DataPoint dataPoint, double d, double d2, DataPoint dataPoint2, double d3) {
        int n = (int)Math.floor(d3 / d2);
        int n2 = this._previousMultiple + 1;
        while (n2 <= n) {
            double d4 = (double)n2 * d2 - d;
            double d5 = d3 - (double)n2 * d2;
            double d6 = d4 / (d4 + d5);
            DataPoint dataPoint3 = PointUtils.interpolate(dataPoint, dataPoint2, d6);
            dataPoint3.setWaypointName(this.createLimitDescription(n2));
            this._pointsToAdd.add(dataPoint3);
            ++n2;
        }
        this._previousMultiple = n;
    }

    private void createHalfwayWaypoints() {
        int n = this._app.getTrackInfo().getTrack().getNumPoints();
        int n2 = this.getConfig().getConfigInt("prune.altitudetolerance") / 100;
        RangeStats rangeStats = new RangeStats(n2);
        int n3 = 0;
        while (n3 < n) {
            DataPoint dataPoint = this._app.getTrackInfo().getTrack().getPoint(n3);
            rangeStats.addPoint(dataPoint);
            ++n3;
        }
        double d = rangeStats.getMovingDistanceKilometres();
        double d2 = rangeStats.getMovingAltitudeRange().getClimb(UnitSetLibrary.UNITS_METRES);
        double d3 = rangeStats.getMovingAltitudeRange().getDescent(UnitSetLibrary.UNITS_METRES);
        double d4 = d / 2.0;
        double d5 = d2 / 2.0;
        double d6 = d3 / 2.0;
        RangeStats rangeStats2 = new RangeStats(n2);
        DataPoint dataPoint = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        int n4 = 0;
        while (n4 < n) {
            DataPoint dataPoint2 = this._app.getTrackInfo().getTrack().getPoint(n4);
            rangeStats2.addPoint(dataPoint2);
            if (!dataPoint2.isWaypoint()) {
                double d10;
                if (!bl && d > 0.0) {
                    d10 = rangeStats2.getMovingDistanceKilometres();
                    bl = this.processHalfValue(dataPoint, d7, d4, dataPoint2, d10, HalfwayType.HALF_DISTANCE);
                    d7 = d10;
                }
                if (!bl2 && d2 > 0.0) {
                    d10 = rangeStats2.getMovingAltitudeRange().getClimb(UnitSetLibrary.UNITS_METRES);
                    bl2 = this.processHalfValue(dataPoint, d8, d5, dataPoint2, d10, HalfwayType.HALF_CLIMB);
                    d8 = d10;
                }
                if (!bl3 && d3 > 0.0) {
                    d10 = rangeStats2.getMovingAltitudeRange().getDescent(UnitSetLibrary.UNITS_METRES);
                    bl3 = this.processHalfValue(dataPoint, d9, d6, dataPoint2, d10, HalfwayType.HALF_DESCENT);
                    d9 = d10;
                }
                dataPoint = dataPoint2;
            }
            ++n4;
        }
    }

    private boolean processHalfValue(DataPoint dataPoint, double d, double d2, DataPoint dataPoint2, double d3, HalfwayType halfwayType) {
        if (d <= d2 && d3 >= d2) {
            double d4 = d2 - d;
            double d5 = d3 - d2;
            double d6 = d4 / (d4 + d5);
            DataPoint dataPoint3 = PointUtils.interpolate(dataPoint, dataPoint2, d6);
            dataPoint3.setWaypointName(this.createHalfwayName(halfwayType));
            this._pointsToAdd.add(dataPoint3);
            return true;
        }
        return false;
    }

    private String createHalfwayName(HalfwayType halfwayType) {
        String string;
        switch (halfwayType) {
            case HALF_DISTANCE: {
                string = "distance";
                break;
            }
            case HALF_CLIMB: {
                string = "climb";
                break;
            }
            case HALF_DESCENT: {
                string = "descent";
                break;
            }
            default: {
                return "half";
            }
        }
        return I18nManager.getText("dialog.markers.half." + string);
    }

    private static enum HalfwayType {
        HALF_DISTANCE,
        HALF_CLIMB,
        HALF_DESCENT;

    }
}

