/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.anim.dom.AbstractSVGAnimatedLength;
import io.sf.carte.echosvg.anim.dom.AnimatedLiveAttributeValue;
import io.sf.carte.echosvg.anim.dom.SVGOMRectElement;
import io.sf.carte.echosvg.bridge.Bridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.SVGShapeElementBridge;
import io.sf.carte.echosvg.dom.svg.LiveAttributeException;
import io.sf.carte.echosvg.gvt.ShapeNode;
import io.sf.carte.echosvg.gvt.ShapePainter;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import org.w3c.dom.Element;

public class SVGRectElementBridge
extends SVGShapeElementBridge {
    @Override
    public String getLocalName() {
        return "rect";
    }

    @Override
    public Bridge getInstance() {
        return new SVGRectElementBridge();
    }

    @Override
    protected void buildShape(BridgeContext ctx, Element e, ShapeNode shapeNode) throws BridgeException {
        float ry;
        float rx;
        SVGOMRectElement re = (SVGOMRectElement)e;
        AbstractSVGAnimatedLength _x = (AbstractSVGAnimatedLength)re.getX();
        float x = this.safeAnimatedLength(_x, 0.0f);
        AbstractSVGAnimatedLength _y = (AbstractSVGAnimatedLength)re.getY();
        float y = this.safeAnimatedLength(_y, 0.0f);
        AbstractSVGAnimatedLength _width = (AbstractSVGAnimatedLength)re.getWidth();
        float w = this.safeAnimatedLength(_width, 0.0f);
        AbstractSVGAnimatedLength _height = (AbstractSVGAnimatedLength)re.getHeight();
        float h = this.safeAnimatedLength(_height, 0.0f);
        boolean rxAuto = false;
        AbstractSVGAnimatedLength _rx = (AbstractSVGAnimatedLength)re.getRx();
        try {
            rx = _rx.getCheckedValue();
        }
        catch (LiveAttributeException ex) {
            rx = 0.0f;
            rxAuto = true;
            SVGRectElementBridge.reportLiveAttributeException(ctx, ex);
        }
        if (rx > w / 2.0f) {
            rx = w / 2.0f;
        }
        AbstractSVGAnimatedLength _ry = (AbstractSVGAnimatedLength)re.getRy();
        try {
            ry = _ry.getCheckedValue();
        }
        catch (LiveAttributeException ex) {
            ry = rx;
            SVGRectElementBridge.reportLiveAttributeException(ctx, ex);
        }
        if (ry > h / 2.0f) {
            ry = h / 2.0f;
        }
        if (rxAuto) {
            rx = ry;
        }
        RectangularShape shape = rx == 0.0f || ry == 0.0f ? new Rectangle2D.Float(x, y, w, h) : new RoundRectangle2D.Float(x, y, w, h, rx * 2.0f, ry * 2.0f);
        try {
            shapeNode.setShape((Shape)shape);
        }
        catch (LiveAttributeException ex) {
            throw new BridgeException(ctx, ex);
        }
    }

    @Override
    public void handleAnimatedAttributeChanged(AnimatedLiveAttributeValue alav) {
        String ln;
        if (alav.getNamespaceURI() == null && ((ln = alav.getLocalName()).equals("x") || ln.equals("y") || ln.equals("width") || ln.equals("height") || ln.equals("rx") || ln.equals("ry"))) {
            this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
            this.handleGeometryChanged();
            return;
        }
        super.handleAnimatedAttributeChanged(alav);
    }

    @Override
    protected ShapePainter createShapePainter(BridgeContext ctx, Element e, ShapeNode shapeNode) {
        Shape shape = shapeNode.getShape();
        Rectangle2D r2d = shape.getBounds2D();
        if (r2d.getWidth() == 0.0 || r2d.getHeight() == 0.0) {
            return null;
        }
        return super.createShapePainter(ctx, e, shapeNode);
    }
}

