/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.opengl.GLException;
import com.jogamp.opengl.fixedfunc.GLMatrixFunc;
import com.jogamp.opengl.math.FloatUtil;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class ProjectFloat {
    private final float[] mat4Tmp1 = new float[16];
    private final float[] mat4Tmp2 = new float[16];
    private final float[] mat4Tmp3 = new float[16];

    public static final int getRequiredFloatBufferSize() {
        return 16;
    }

    public void gluOrtho2D(GLMatrixFunc gLMatrixFunc, float f, float f2, float f3, float f4) {
        gLMatrixFunc.glOrthof(f, f2, f3, f4, -1.0f, 1.0f);
    }

    public void gluPerspective(GLMatrixFunc gLMatrixFunc, float f, float f2, float f3, float f4) throws GLException {
        gLMatrixFunc.glMultMatrixf(FloatUtil.makePerspective(this.mat4Tmp1, 0, true, f * (float)Math.PI / 180.0f, f2, f3, f4), 0);
    }

    public void gluLookAt(GLMatrixFunc gLMatrixFunc, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.mat4Tmp2[0] = f;
        this.mat4Tmp2[1] = f2;
        this.mat4Tmp2[2] = f3;
        this.mat4Tmp2[4] = f4;
        this.mat4Tmp2[5] = f5;
        this.mat4Tmp2[6] = f6;
        this.mat4Tmp2[8] = f7;
        this.mat4Tmp2[9] = f8;
        this.mat4Tmp2[10] = f9;
        gLMatrixFunc.glMultMatrixf(FloatUtil.makeLookAt(this.mat4Tmp1, 0, this.mat4Tmp2, 0, this.mat4Tmp2, 4, this.mat4Tmp2, 8, this.mat4Tmp3), 0);
    }

    public boolean gluProject(float f, float f2, float f3, float[] fArray, int n, float[] fArray2, int n2, int[] nArray, int n3, float[] fArray3, int n4) {
        return FloatUtil.mapObjToWin(f, f2, f3, fArray, n, fArray2, n2, nArray, n3, fArray3, n4, this.mat4Tmp1, this.mat4Tmp2);
    }

    public boolean gluProject(float f, float f2, float f3, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, int[] nArray, int n, float[] fArray, int n2) {
        float[] fArray2 = this.mat4Tmp1;
        float[] fArray3 = this.mat4Tmp2;
        fArray2[0] = f;
        fArray2[1] = f2;
        fArray2[2] = f3;
        fArray2[3] = 1.0f;
        FloatUtil.multMatrixVec(floatBuffer, fArray2, fArray3);
        FloatUtil.multMatrixVec(floatBuffer2, fArray3, fArray2);
        if (fArray2[3] == 0.0f) {
            return false;
        }
        fArray2[3] = 1.0f / fArray2[3] * 0.5f;
        fArray2[0] = fArray2[0] * fArray2[3] + 0.5f;
        fArray2[1] = fArray2[1] * fArray2[3] + 0.5f;
        fArray2[2] = fArray2[2] * fArray2[3] + 0.5f;
        fArray[0 + n2] = fArray2[0] * (float)nArray[2 + n] + (float)nArray[0 + n];
        fArray[1 + n2] = fArray2[1] * (float)nArray[3 + n] + (float)nArray[1 + n];
        fArray[2 + n2] = fArray2[2];
        return true;
    }

    public boolean gluProject(float f, float f2, float f3, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, IntBuffer intBuffer, FloatBuffer floatBuffer3) {
        float[] fArray = this.mat4Tmp1;
        float[] fArray2 = this.mat4Tmp2;
        fArray[0] = f;
        fArray[1] = f2;
        fArray[2] = f3;
        fArray[3] = 1.0f;
        FloatUtil.multMatrixVec(floatBuffer, fArray, fArray2);
        FloatUtil.multMatrixVec(floatBuffer2, fArray2, fArray);
        if (fArray[3] == 0.0f) {
            return false;
        }
        fArray[3] = 1.0f / fArray[3] * 0.5f;
        fArray[0] = fArray[0] * fArray[3] + 0.5f;
        fArray[1] = fArray[1] * fArray[3] + 0.5f;
        fArray[2] = fArray[2] * fArray[3] + 0.5f;
        int n = intBuffer.position();
        int n2 = floatBuffer3.position();
        floatBuffer3.put(0 + n2, fArray[0] * (float)intBuffer.get(2 + n) + (float)intBuffer.get(0 + n));
        floatBuffer3.put(1 + n2, fArray[1] * (float)intBuffer.get(3 + n) + (float)intBuffer.get(1 + n));
        floatBuffer3.put(2 + n2, fArray[2]);
        return true;
    }

    public boolean gluUnProject(float f, float f2, float f3, float[] fArray, int n, float[] fArray2, int n2, int[] nArray, int n3, float[] fArray3, int n4) {
        return FloatUtil.mapWinToObj(f, f2, f3, fArray, n, fArray2, n2, nArray, n3, fArray3, n4, this.mat4Tmp1, this.mat4Tmp2);
    }

    public boolean gluUnProject(float f, float f2, float f3, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, int[] nArray, int n, float[] fArray, int n2) {
        FloatUtil.multMatrix(floatBuffer2, floatBuffer, this.mat4Tmp1);
        if (null == FloatUtil.invertMatrix(this.mat4Tmp1, this.mat4Tmp1)) {
            return false;
        }
        this.mat4Tmp2[0] = f;
        this.mat4Tmp2[1] = f2;
        this.mat4Tmp2[2] = f3;
        this.mat4Tmp2[3] = 1.0f;
        this.mat4Tmp2[0] = (this.mat4Tmp2[0] - (float)nArray[0 + n]) / (float)nArray[2 + n];
        this.mat4Tmp2[1] = (this.mat4Tmp2[1] - (float)nArray[1 + n]) / (float)nArray[3 + n];
        this.mat4Tmp2[0] = this.mat4Tmp2[0] * 2.0f - 1.0f;
        this.mat4Tmp2[1] = this.mat4Tmp2[1] * 2.0f - 1.0f;
        this.mat4Tmp2[2] = this.mat4Tmp2[2] * 2.0f - 1.0f;
        FloatUtil.multMatrixVec(this.mat4Tmp1, 0, this.mat4Tmp2, 0, this.mat4Tmp2, 4);
        if ((double)this.mat4Tmp2[7] == 0.0) {
            return false;
        }
        this.mat4Tmp2[7] = 1.0f / this.mat4Tmp2[7];
        fArray[0 + n2] = this.mat4Tmp2[4] * this.mat4Tmp2[7];
        fArray[1 + n2] = this.mat4Tmp2[5] * this.mat4Tmp2[7];
        fArray[2 + n2] = this.mat4Tmp2[6] * this.mat4Tmp2[7];
        return true;
    }

    public boolean gluUnProject(float f, float f2, float f3, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, IntBuffer intBuffer, FloatBuffer floatBuffer3) {
        int n = intBuffer.position();
        int n2 = floatBuffer3.position();
        FloatUtil.multMatrix(floatBuffer2, floatBuffer, this.mat4Tmp1);
        if (null == FloatUtil.invertMatrix(this.mat4Tmp1, this.mat4Tmp1)) {
            return false;
        }
        this.mat4Tmp2[0] = f;
        this.mat4Tmp2[1] = f2;
        this.mat4Tmp2[2] = f3;
        this.mat4Tmp2[3] = 1.0f;
        this.mat4Tmp2[0] = (this.mat4Tmp2[0] - (float)intBuffer.get(0 + n)) / (float)intBuffer.get(2 + n);
        this.mat4Tmp2[1] = (this.mat4Tmp2[1] - (float)intBuffer.get(1 + n)) / (float)intBuffer.get(3 + n);
        this.mat4Tmp2[0] = this.mat4Tmp2[0] * 2.0f - 1.0f;
        this.mat4Tmp2[1] = this.mat4Tmp2[1] * 2.0f - 1.0f;
        this.mat4Tmp2[2] = this.mat4Tmp2[2] * 2.0f - 1.0f;
        FloatUtil.multMatrixVec(this.mat4Tmp1, 0, this.mat4Tmp2, 0, this.mat4Tmp2, 4);
        if ((double)this.mat4Tmp2[7] == 0.0) {
            return false;
        }
        this.mat4Tmp2[7] = 1.0f / this.mat4Tmp2[7];
        floatBuffer3.put(0 + n2, this.mat4Tmp2[4] * this.mat4Tmp2[7]);
        floatBuffer3.put(1 + n2, this.mat4Tmp2[5] * this.mat4Tmp2[7]);
        floatBuffer3.put(2 + n2, this.mat4Tmp2[6] * this.mat4Tmp2[7]);
        return true;
    }

    public boolean gluUnProject4(float f, float f2, float f3, float f4, float[] fArray, int n, float[] fArray2, int n2, int[] nArray, int n3, float f5, float f6, float[] fArray3, int n4) {
        return FloatUtil.mapWinToObj4(f, f2, f3, f4, fArray, n, fArray2, n2, nArray, n3, f5, f6, fArray3, n4, this.mat4Tmp1, this.mat4Tmp2);
    }

    public boolean gluUnProject4(float f, float f2, float f3, float f4, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, IntBuffer intBuffer, float f5, float f6, FloatBuffer floatBuffer3) {
        FloatUtil.multMatrix(floatBuffer2, floatBuffer, this.mat4Tmp1);
        if (null == FloatUtil.invertMatrix(this.mat4Tmp1, this.mat4Tmp1)) {
            return false;
        }
        this.mat4Tmp2[0] = f;
        this.mat4Tmp2[1] = f2;
        this.mat4Tmp2[2] = f3;
        this.mat4Tmp2[3] = f4;
        int n = intBuffer.position();
        this.mat4Tmp2[0] = (this.mat4Tmp2[0] - (float)intBuffer.get(0 + n)) / (float)intBuffer.get(2 + n);
        this.mat4Tmp2[1] = (this.mat4Tmp2[1] - (float)intBuffer.get(1 + n)) / (float)intBuffer.get(3 + n);
        this.mat4Tmp2[2] = (this.mat4Tmp2[2] - f5) / (f6 - f5);
        this.mat4Tmp2[0] = this.mat4Tmp2[0] * 2.0f - 1.0f;
        this.mat4Tmp2[1] = this.mat4Tmp2[1] * 2.0f - 1.0f;
        this.mat4Tmp2[2] = this.mat4Tmp2[2] * 2.0f - 1.0f;
        FloatUtil.multMatrixVec(this.mat4Tmp1, 0, this.mat4Tmp2, 0, this.mat4Tmp2, 4);
        if (this.mat4Tmp2[7] == 0.0f) {
            return false;
        }
        int n2 = floatBuffer3.position();
        floatBuffer3.put(0 + n2, this.mat4Tmp2[4]);
        floatBuffer3.put(1 + n2, this.mat4Tmp2[5]);
        floatBuffer3.put(2 + n2, this.mat4Tmp2[6]);
        floatBuffer3.put(3 + n2, this.mat4Tmp2[7]);
        return true;
    }

    public void gluPickMatrix(GLMatrixFunc gLMatrixFunc, float f, float f2, float f3, float f4, IntBuffer intBuffer) {
        if (f3 <= 0.0f || f4 <= 0.0f) {
            return;
        }
        int n = intBuffer.position();
        gLMatrixFunc.glTranslatef(((float)intBuffer.get(2 + n) - 2.0f * (f - (float)intBuffer.get(0 + n))) / f3, ((float)intBuffer.get(3 + n) - 2.0f * (f2 - (float)intBuffer.get(1 + n))) / f4, 0.0f);
        gLMatrixFunc.glScalef((float)intBuffer.get(2) / f3, (float)intBuffer.get(3) / f4, 1.0f);
    }

    public void gluPickMatrix(GLMatrixFunc gLMatrixFunc, float f, float f2, float f3, float f4, int[] nArray, int n) {
        if (null != FloatUtil.makePick(this.mat4Tmp1, f, f2, f3, f4, nArray, n, this.mat4Tmp2)) {
            gLMatrixFunc.glMultMatrixf(this.mat4Tmp1, 0);
        }
    }
}

