/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.text.handlers;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.jkiss.dbeaver.ui.ICommentsSupport;
import org.jkiss.dbeaver.ui.editors.text.handlers.AbstractCommentHandler;
import org.jkiss.utils.Pair;

public final class ToggleMultiLineCommentHandler
extends AbstractCommentHandler {
    @Override
    protected void processAction(ISelectionProvider selectionProvider, ICommentsSupport commentsSupport, IDocument document, ITextSelection selection) throws BadLocationException {
        Pair comment = commentsSupport.getMultiLineComments();
        if (comment == null) {
            return;
        }
        int selOffset = selection.getOffset();
        int selLength = selection.getLength();
        DocumentRewriteSession rewriteSession = null;
        if (document instanceof IDocumentExtension4) {
            rewriteSession = ((IDocumentExtension4)document).startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
        }
        String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
        String selText = selection.getText();
        boolean isMultiLine = selection.getStartLine() != selection.getEndLine() || selText.contains(lineDelimiter);
        String testText = selText.trim();
        if (testText.startsWith((String)comment.getFirst()) && testText.endsWith((String)comment.getSecond())) {
            int startPos = selText.indexOf((String)comment.getFirst()) + ((String)comment.getFirst()).length();
            while (lineDelimiter.indexOf(selText.charAt(startPos)) != -1) {
                ++startPos;
            }
            int endPos = selText.lastIndexOf((String)comment.getSecond());
            while (lineDelimiter.indexOf(selText.charAt(endPos)) != -1) {
                --endPos;
            }
            String newSel = selText.substring(startPos, endPos);
            document.replace(selection.getOffset(), selection.getLength(), newSel);
            selLength -= selText.length() - newSel.length();
        } else if (isMultiLine) {
            int endOffset = selOffset + selLength;
            boolean firstAtBegin = document.getLineOffset(selection.getStartLine()) == selOffset;
            boolean secondAtBegin = document.getLineOffset(document.getLineOfOffset(endOffset)) == endOffset;
            boolean useLineFeeds = firstAtBegin && secondAtBegin;
            document.replace(selection.getOffset() + selection.getLength(), 0, (String)comment.getSecond() + (useLineFeeds ? lineDelimiter : ""));
            document.replace(selection.getOffset(), 0, (String)comment.getFirst() + (useLineFeeds ? lineDelimiter : ""));
            selLength += ((String)comment.getFirst()).length() + ((String)comment.getSecond()).length() + (useLineFeeds ? lineDelimiter.length() * 2 : 0);
        } else {
            document.replace(selection.getOffset(), selection.getLength(), (String)comment.getFirst() + selText + (String)comment.getSecond());
            selLength += ((String)comment.getFirst()).length() + ((String)comment.getSecond()).length();
        }
        if (rewriteSession != null) {
            ((IDocumentExtension4)document).stopRewriteSession(rewriteSession);
        }
        if (selLength > 0) {
            selectionProvider.setSelection((ISelection)new TextSelection(selOffset, selLength));
        }
    }
}

