/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.rcp;

import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPAdaptable;
import org.jkiss.dbeaver.model.DBPExternalFileManager;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.app.DBPResourceHandlerDescriptor;
import org.jkiss.dbeaver.model.app.DBPResourceTypeDescriptor;
import org.jkiss.dbeaver.model.app.DBPWorkspaceDesktop;
import org.jkiss.dbeaver.model.rcp.DesktopProjectImpl;
import org.jkiss.dbeaver.model.rcp.EclipseWorkspaceImpl;
import org.jkiss.dbeaver.model.rcp.RCPProject;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.registry.ResourceHandlerDescriptor;
import org.jkiss.dbeaver.registry.ResourceTypeDescriptor;
import org.jkiss.dbeaver.registry.ResourceTypeRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DesktopWorkspaceImpl
extends EclipseWorkspaceImpl
implements DBPWorkspaceDesktop,
DBPExternalFileManager {
    private static final Log log = Log.getLog(DesktopWorkspaceImpl.class);
    private static final String EXT_FILES_PROPS_STORE = "dbeaver-external-files.data";
    private final Map<String, Map<String, Object>> externalFileProperties = new HashMap<String, Map<String, Object>>();
    private final AbstractJob externalFileSaver = new WorkspaceFilesMetadataJob();
    private final List<ResourceHandlerDescriptor> handlerDescriptors = new ArrayList<ResourceHandlerDescriptor>();
    private DBPResourceHandler defaultHandler;

    public DesktopWorkspaceImpl(@NotNull DBPPlatform platform, @NotNull IWorkspace eclipseWorkspace) {
        super(platform, eclipseWorkspace);
        this.loadExtensions(Platform.getExtensionRegistry());
        this.loadExternalFileProperties();
    }

    private void loadExtensions(@NotNull IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.resourceHandler");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            ResourceHandlerDescriptor handlerDescriptor = new ResourceHandlerDescriptor(ext);
            this.handlerDescriptors.add(handlerDescriptor);
            if (handlerDescriptor.isDefault()) {
                this.defaultHandler = handlerDescriptor.getHandler();
            }
            ++n2;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        for (ResourceHandlerDescriptor handlerDescriptor : this.handlerDescriptors) {
            handlerDescriptor.dispose();
        }
        this.handlerDescriptors.clear();
    }

    private DBPResourceHandler getResourceHandler(DBPResourceTypeDescriptor resourceType) {
        for (ResourceHandlerDescriptor rhd : this.handlerDescriptors) {
            if (!rhd.getTypeId().equals(resourceType.getId())) continue;
            return rhd.getHandler();
        }
        return null;
    }

    @Override
    public DBPResourceHandler getResourceHandler(@Nullable IResource resource) {
        if (DBWorkbench.getPlatform().getApplication().isExclusiveMode()) {
            return null;
        }
        if (resource == null || resource.isHidden() || resource.isPhantom()) {
            return null;
        }
        if (resource.getParent() instanceof IProject && resource.getName().startsWith(".dbeaver-data-sources")) {
            return null;
        }
        DBPResourceHandler handler = null;
        for (ResourceHandlerDescriptor rhd : this.handlerDescriptors) {
            if (!rhd.canHandle(resource)) continue;
            handler = rhd.getHandler();
            break;
        }
        if (handler == null && resource instanceof IFolder) {
            IProject eclipseProject = resource.getProject();
            DesktopProjectImpl project = (DesktopProjectImpl)this.projects.get(eclipseProject);
            IPath relativePath = resource.getFullPath().makeRelativeTo(project.getRootResource().getFullPath());
            while (relativePath.segmentCount() > 0) {
                String folderPath = relativePath.toString();
                ResourceTypeDescriptor resType = ResourceTypeRegistry.getInstance().getResourceTypeByRootPath((DBPProject)project, folderPath);
                if (resType != null) {
                    handler = this.getResourceHandler((DBPResourceTypeDescriptor)resType);
                }
                relativePath = relativePath.removeLastSegments(1);
            }
        }
        if (handler == null) {
            handler = this.getDefaultResourceHandler();
        }
        return handler;
    }

    @Override
    @NotNull
    public DBPResourceHandler getDefaultResourceHandler() {
        return this.defaultHandler;
    }

    @Override
    @NotNull
    public DBPResourceHandlerDescriptor[] getAllResourceHandlers() {
        return this.handlerDescriptors.toArray(new DBPResourceHandlerDescriptor[0]);
    }

    @Nullable
    public DBPImage getResourceIcon(DBPAdaptable resourceAdapter) {
        IResource resource = (IResource)resourceAdapter.getAdapter(IResource.class);
        if (resource != null) {
            return this.defaultHandler.getResourceIcon(resource);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IFolder getResourceDefaultRoot(@NotNull DBPProject project, @NotNull Class<? extends DBPResourceHandler> handlerType, boolean forceCreate) {
        void rcpProject;
        if (!(project instanceof RCPProject)) {
            return null;
        }
        RCPProject rCPProject = (RCPProject)project;
        for (ResourceHandlerDescriptor rhd : this.handlerDescriptors) {
            DBPResourceHandler handler = rhd.getHandler();
            if (handler == null || handler.getClass() != handlerType) continue;
            DBPResourceTypeDescriptor resourceType = rhd.getResourceType();
            if (resourceType == null) {
                return null;
            }
            String defaultRoot = resourceType.getDefaultRoot(project);
            if (defaultRoot == null) {
                return null;
            }
            Path defaultRootPath = new Path(defaultRoot);
            IContainer rootResource = rcpProject.getRootResource();
            if (rootResource == null) {
                rootResource = rcpProject.getEclipseProject();
            }
            if (rootResource == null) {
                throw new IllegalStateException("Project " + project.getName() + " doesn't have resource root");
            }
            IFolder realFolder = rootResource.getFolder((IPath)defaultRootPath);
            if (forceCreate && !realFolder.exists()) {
                try {
                    realFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    log.error((Object)("Can not create '" + resourceType.getName() + "' root folder '" + realFolder.getName() + "'"), (Throwable)e);
                    return realFolder;
                }
            }
            return realFolder;
        }
        return rcpProject.getEclipseProject().getFolder("Resources");
    }

    @Override
    public IFolder getResourceDefaultRoot(@NotNull DBPProject project, @NotNull DBPResourceHandlerDescriptor rhd, boolean forceCreate) {
        RCPProject rcpProject;
        if (!(project instanceof RCPProject) || (rcpProject = (RCPProject)project).getRootResource() == null) {
            return null;
        }
        DBPResourceTypeDescriptor resourceType = rhd.getResourceType();
        if (resourceType == null) {
            return null;
        }
        String defaultRoot = resourceType.getDefaultRoot(project);
        if (defaultRoot == null) {
            return null;
        }
        IFolder realFolder = rcpProject.getRootResource().getFolder((IPath)new Path(defaultRoot));
        if (forceCreate && !realFolder.exists()) {
            try {
                realFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                log.error((Object)("Can't create '" + resourceType.getName() + "' root folder '" + realFolder.getName() + "'"), (Throwable)e);
                return realFolder;
            }
        }
        return realFolder;
    }

    @Override
    public void refreshWorkspaceContents(@NotNull DBRProgressMonitor monitor) {
        block9: {
            try {
                IWorkspaceRoot root = this.getEclipseWorkspace().getRoot();
                root.refreshLocal(1, monitor.getNestedMonitor());
                File workspaceLocation = root.getLocation().toFile();
                if (!workspaceLocation.exists()) {
                    return;
                }
                IProject[] iProjectArray = root.getProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    File projectDir = project.getLocation().toFile();
                    if (!projectDir.exists()) {
                        monitor.subTask("Removing unexistent project '" + project.getName() + "'");
                        project.delete(false, true, monitor.getNestedMonitor());
                    }
                    ++n2;
                }
                Object[] wsFiles = workspaceLocation.listFiles();
                if (ArrayUtils.isEmpty((Object[])wsFiles)) break block9;
                monitor.beginTask("Refreshing workspace contents", wsFiles.length);
                Object[] objectArray = wsFiles;
                int n3 = wsFiles.length;
                n = 0;
                while (n < n3) {
                    String projectName;
                    IProject project;
                    File projectConfig;
                    Object wsFile = objectArray[n];
                    if (((File)wsFile).isDirectory() && !((File)wsFile).isHidden() && !((File)wsFile).getName().startsWith(".") && (projectConfig = new File((File)wsFile, ".project")).exists() && !(project = root.getProject(projectName = ((File)wsFile).getName())).exists()) {
                        try {
                            monitor.subTask("Adding project '" + projectName + "'");
                            project.create(monitor.getNestedMonitor());
                        }
                        catch (CoreException coreException) {
                            log.error((Object)("Error adding project '" + projectName + "' to workspace"));
                        }
                    }
                    ++n;
                }
            }
            catch (Throwable e) {
                log.error((Object)"Error refreshing workspace contents", e);
            }
        }
    }

    @Override
    @NotNull
    public DBPProject createProject(@NotNull String name, @Nullable String description) throws DBException {
        IProject project = null;
        try {
            project = this.getEclipseWorkspace().getRoot().getProject(name);
            NullProgressMonitor monitor = new NullProgressMonitor();
            if (project.exists()) {
                project.create((IProgressMonitor)monitor);
            }
            IProjectDescription pDescription = this.getEclipseWorkspace().newProjectDescription(project.getName());
            if (!CommonUtils.isEmpty((String)description)) {
                pDescription.setComment(description);
            }
            pDescription.setNatureIds(new String[]{"org.jkiss.dbeaver.DBeaverNature"});
            project.setDescription(pDescription, (IProgressMonitor)monitor);
            project.open((IProgressMonitor)monitor);
        }
        catch (Exception e) {
            throw new DBException("Error creating Eclipse project", (Throwable)e);
        }
        return this.getProject(project);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void deleteProject(@NotNull DBPProject project, boolean deleteContents) throws DBException {
        void rcpProject;
        if (!(project instanceof RCPProject)) {
            throw new DBException("Project '" + project.getName() + "' is not an RCP project");
        }
        RCPProject rCPProject = (RCPProject)project;
        if (project == this.activeProject) {
            throw new DBException("You cannot delete active project");
        }
        IProject eclipseProject = rcpProject.getEclipseProject();
        if (eclipseProject == null) {
            throw new DBException("Project '" + project.getName() + "' is not an Eclipse project");
        }
        if (project.isUseSecretStorage()) {
            DBSSecretController secretController = DBSSecretController.getProjectSecretController((DBPProject)project);
            secretController.deleteProjectSecrets(project.getId());
        }
        try {
            eclipseProject.delete(deleteContents, true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            throw new DBException("Error deleting Eclipse project '" + project.getName() + "'", (Throwable)e);
        }
    }

    @Override
    protected void reloadWorkspace(DBRProgressMonitor monitor) {
        this.refreshWorkspaceContents(monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Map<String, Object> getFileProperties(File file) {
        Map<String, Map<String, Object>> map = this.externalFileProperties;
        synchronized (map) {
            return this.externalFileProperties.get(file.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object getFileProperty(File file, String property) {
        Map<String, Map<String, Object>> map = this.externalFileProperties;
        synchronized (map) {
            Map<String, Object> fileProps = this.externalFileProperties.get(file.getAbsolutePath());
            return fileProps == null ? null : fileProps.get(property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFileProperty(File file, String property, Object value) {
        Map<String, Map<String, Object>> map = this.externalFileProperties;
        synchronized (map) {
            String filePath = file.getAbsolutePath();
            Map<String, Object> fileProps = this.externalFileProperties.get(filePath);
            if (fileProps == null) {
                fileProps = new HashMap<String, Object>();
                this.externalFileProperties.put(filePath, fileProps);
            }
            if (value == null) {
                fileProps.remove(property);
            } else {
                fileProps.put(property, value);
            }
        }
        this.saveExternalFileProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Map<String, Map<String, Object>> getAllFiles() {
        Map<String, Map<String, Object>> map = this.externalFileProperties;
        synchronized (map) {
            return new LinkedHashMap<String, Map<String, Object>>(this.externalFileProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExternalFileProperties() {
        Map<String, Map<String, Object>> map = this.externalFileProperties;
        synchronized (map) {
            this.externalFileProperties.clear();
            java.nio.file.Path propsFile = GeneralUtils.getMetadataFolder((java.nio.file.Path)this.getAbsolutePath()).resolve(EXT_FILES_PROPS_STORE);
            if (Files.exists(propsFile, new LinkOption[0])) {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (InputStream is = Files.newInputStream(propsFile, new OpenOption[0]);){
                        Throwable throwable2 = null;
                        Object var7_11 = null;
                        try (ObjectInputStream ois = new ObjectInputStream(is);){
                            Object object = ois.readObject();
                            if (object instanceof Map) {
                                this.externalFileProperties.putAll((Map)object);
                            } else {
                                log.error((Object)("Bad external files properties data format: " + String.valueOf(object)));
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Error saving external files properties", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveExternalFileProperties() {
        Map<String, Map<String, Object>> map = this.externalFileProperties;
        synchronized (map) {
            this.externalFileSaver.schedule(100L);
        }
    }

    private class WorkspaceFilesMetadataJob
    extends AbstractJob {
        public WorkspaceFilesMetadataJob() {
            super("External files metadata saver");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        protected IStatus run(@NotNull DBRProgressMonitor monitor) {
            Map<String, Map<String, Object>> map = DesktopWorkspaceImpl.this.externalFileProperties;
            synchronized (map) {
                java.nio.file.Path propsFile = GeneralUtils.getMetadataFolder((java.nio.file.Path)DesktopWorkspaceImpl.this.getAbsolutePath()).resolve(DesktopWorkspaceImpl.EXT_FILES_PROPS_STORE);
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (OutputStream os = Files.newOutputStream(propsFile, new OpenOption[0]);){
                        Throwable throwable2 = null;
                        Object var8_12 = null;
                        try (ObjectOutputStream oos = new ObjectOutputStream(os);){
                            oos.writeObject(DesktopWorkspaceImpl.this.externalFileProperties);
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Error saving external files properties", (Throwable)e);
                }
            }
            return Status.OK_STATUS;
        }
    }
}

