/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream;

import java.io.IOException;
import java.io.OutputStream;
import org.jkiss.code.NotNull;

public class StatOutputStream
extends OutputStream {
    private final OutputStream stream;
    private long bytesWritten = 0L;

    public StatOutputStream(OutputStream stream) {
        this.stream = stream;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    @Override
    public void write(int b) throws IOException {
        this.stream.write(b);
        ++this.bytesWritten;
    }

    @Override
    public void write(@NotNull byte[] b) throws IOException {
        this.stream.write(b);
        this.bytesWritten += (long)b.length;
    }

    @Override
    public void write(@NotNull byte[] b, int off, int len) throws IOException {
        this.stream.write(b, off, len);
        this.bytesWritten += (long)len;
    }

    @Override
    public void flush() throws IOException {
        this.stream.flush();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

