/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.fs.lock;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;

public class FileLock
implements AutoCloseable {
    private static final Log log = Log.getLog(FileLock.class);
    private final Path lockFilePath;

    public FileLock(@NotNull Path lockFilePath) {
        this.lockFilePath = lockFilePath;
    }

    public void unlock() {
        block2: {
            try {
                Files.deleteIfExists(this.lockFilePath);
            }
            catch (IOException e) {
                log.error("Failed to unlock file: " + String.valueOf(this.lockFilePath), e);
                if (!Files.exists(this.lockFilePath, new LinkOption[0])) break block2;
                this.unlock();
            }
        }
    }

    protected Path getLockFilePath() {
        return this.lockFilePath;
    }

    @Override
    public void close() {
        this.unlock();
    }
}

