/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.project;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.tools.project.ProjectImportData;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class ProjectImportWizardPageFile
extends WizardPage {
    private final ProjectImportData importData;
    private String curFolder;
    private Table projectsTable;

    protected ProjectImportWizardPageFile(ProjectImportData importData) {
        super(CoreMessages.dialog_project_import_wizard_file_name);
        this.importData = importData;
        this.setTitle(CoreMessages.dialog_project_import_wizard_file_title);
        this.setDescription(CoreMessages.dialog_project_import_wizard_file_description);
    }

    public boolean isPageComplete() {
        return this.importData.isProjectsSelected(this);
    }

    public void createControl(Composite parent) {
        Composite placeholder = UIUtils.createPlaceholder((Composite)parent, (int)1);
        Group configGroup = UIUtils.createControlGroup((Composite)placeholder, (String)CoreMessages.dialog_project_import_wizard_file_group_input, (int)3, (int)768, (int)0);
        final Text fileNameText = UIUtils.createLabelText((Composite)configGroup, (String)CoreMessages.dialog_project_import_wizard_file_label_file, null);
        fileNameText.addModifyListener(e -> {
            String fileName = fileNameText.getText();
            if (CommonUtils.isEmpty((String)fileName)) {
                this.importData.setImportFile(null);
                this.clearArchive();
            } else {
                this.importData.setImportFile(new File(fileName));
                this.loadArchive();
            }
            this.updateState();
        });
        Button openFolder = new Button((Composite)configGroup, 8);
        openFolder.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.OPEN));
        openFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(ProjectImportWizardPageFile.this.getShell(), 4100);
                fd.setText(CoreMessages.dialog_project_import_wizard_file_dialog_export_archive_text);
                fd.setFilterPath(ProjectImportWizardPageFile.this.curFolder);
                String[] filterExt = new String[]{"*.dbp", "*"};
                fd.setFilterExtensions(filterExt);
                String selected = fd.open();
                if (selected != null) {
                    ProjectImportWizardPageFile.this.curFolder = fd.getFilterPath();
                    fileNameText.setText(selected);
                }
            }
        });
        final Button importDriverCheck = UIUtils.createCheckbox((Composite)configGroup, (String)CoreMessages.dialog_project_import_wizard_file_checkbox_import_libraries, (boolean)true);
        importDriverCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectImportWizardPageFile.this.importData.setImportDriverLibraries(importDriverCheck.getSelection());
            }
        });
        GridData gd = new GridData(32);
        gd.horizontalSpan = 3;
        importDriverCheck.setLayoutData((Object)gd);
        Group projectsGroup = UIUtils.createControlGroup((Composite)placeholder, (String)CoreMessages.dialog_project_import_wizard_file_group_projects, (int)1, (int)1808, (int)0);
        this.projectsTable = new Table((Composite)projectsGroup, 67618);
        this.projectsTable.setHeaderVisible(true);
        this.projectsTable.setLinesVisible(true);
        gd = new GridData(1808);
        this.projectsTable.setLayoutData((Object)gd);
        this.projectsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectImportWizardPageFile.this.updateProjectsSelection();
                ProjectImportWizardPageFile.this.updateState();
            }
        });
        UIUtils.createTableColumn((Table)this.projectsTable, (int)16384, (String)CoreMessages.dialog_project_import_wizard_file_column_source_name);
        UIUtils.createTableColumn((Table)this.projectsTable, (int)16384, (String)CoreMessages.dialog_project_import_wizard_file_column_target_name);
        final TableEditor tableEditor = new TableEditor(this.projectsTable);
        tableEditor.horizontalAlignment = 16384;
        tableEditor.verticalAlignment = 128;
        tableEditor.grabHorizontal = true;
        this.projectsTable.addMouseListener((MouseListener)new MouseAdapter(){

            private void disposeOldEditor() {
                Control oldEditor = tableEditor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
            }

            public void mouseUp(MouseEvent e) {
                this.disposeOldEditor();
                TableItem item = ProjectImportWizardPageFile.this.projectsTable.getItem(new Point(e.x, e.y));
                if (item == null) {
                    return;
                }
                this.showEditor(item);
            }

            private void showEditor(TableItem item) {
                Text text = new Text((Composite)ProjectImportWizardPageFile.this.projectsTable, 2048);
                text.setText(item.getText(1));
                text.addModifyListener(e -> {
                    Text text1 = (Text)tableEditor.getEditor();
                    item.setText(1, text1.getText());
                    ProjectImportWizardPageFile.this.updateProjectsSelection();
                    ProjectImportWizardPageFile.this.updateState();
                });
                text.selectAll();
                text.setFocus();
                tableEditor.setEditor((Control)text, item, 1);
            }
        });
        UIUtils.packColumns((Table)this.projectsTable);
        this.setControl((Control)placeholder);
    }

    private boolean updateProjectsSelection() {
        this.importData.clearProjectNameMap();
        boolean failed = false;
        TableItem[] tableItemArray = this.projectsTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            boolean validItem = this.checkProjectItem(item);
            if (!validItem && item.getChecked()) {
                failed = true;
            }
            ++n2;
        }
        if (!failed) {
            boolean hasChecked = false;
            TableItem[] tableItemArray2 = this.projectsTable.getItems();
            int n3 = tableItemArray2.length;
            n = 0;
            while (n < n3) {
                TableItem item = tableItemArray2[n];
                if (item.getChecked()) {
                    this.importData.addProjectName(item.getText(0), item.getText(1));
                    hasChecked = true;
                }
                ++n;
            }
            if (hasChecked) {
                this.setMessage(CoreMessages.dialog_project_import_wizard_file_message_ready, 1);
            } else {
                this.setMessage(CoreMessages.dialog_project_import_wizard_file_message_choose_project, 1);
            }
        }
        return !failed;
    }

    private boolean checkProjectItem(TableItem item) {
        String projectName = item.getText(1);
        IProject project = DBPPlatformDesktop.getInstance().getWorkspace().getEclipseWorkspace().getRoot().getProject(projectName);
        if (!project.isAccessible()) {
            item.setForeground(1, null);
            return true;
        }
        if (item.getChecked()) {
            this.setMessage(NLS.bind((String)CoreMessages.dialog_project_import_wizard_file_message_project_exists, (Object)projectName), 3);
        }
        item.setForeground(1, this.projectsTable.getDisplay().getSystemColor(3));
        return false;
    }

    private void updateState() {
        this.getContainer().updateButtons();
    }

    private boolean loadArchive() {
        if (this.importData.isFileSpecified(this)) {
            if (this.importData.getMetaTree() != null) {
                return true;
            }
            this.clearArchive();
            if (this.importData.loadArchiveMeta(this)) {
                Document metaTree = this.importData.getMetaTree();
                Element projectsElement = XMLUtils.getChildElement((Element)metaTree.getDocumentElement(), (String)"projects");
                if (projectsElement == null) {
                    this.setMessage(CoreMessages.dialog_project_import_wizard_file_message_cannt_find_projects, 3);
                } else {
                    this.projectsTable.removeAll();
                    for (Element projectElement : XMLUtils.getChildElementList((Element)projectsElement, (String)"project")) {
                        String projectName = projectElement.getAttribute("name");
                        TableItem item = new TableItem(this.projectsTable, 0);
                        item.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.PROJECT));
                        item.setText(0, projectName);
                        item.setText(1, projectName);
                    }
                    UIUtils.packColumns((Table)this.projectsTable);
                    this.updateProjectsSelection();
                    return true;
                }
            }
            return false;
        }
        this.clearArchive();
        return false;
    }

    private void clearArchive() {
        this.projectsTable.removeAll();
    }
}

