/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetPage;
import org.eclipse.ui.internal.registry.WorkingSetDescriptor;
import org.eclipse.ui.internal.registry.WorkingSetRegistryReader;

public class WorkingSetRegistry
implements IExtensionChangeHandler {
    private static final String DEFAULT_PAGE_ID = "org.eclipse.ui.resourceWorkingSetPage";
    private final HashMap<String, WorkingSetDescriptor> workingSetDescriptors = new HashMap();

    public WorkingSetRegistry() {
        IExtensionTracker tracker = PlatformUI.getWorkbench().getExtensionTracker();
        tracker.registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)this.getExtensionPointFilter()));
    }

    private IExtensionPoint getExtensionPointFilter() {
        return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "workingSets");
    }

    public void addWorkingSetDescriptor(WorkingSetDescriptor descriptor) {
        Assert.isTrue((!this.workingSetDescriptors.containsValue(descriptor) ? 1 : 0) != 0, (String)"working set descriptor already registered");
        IExtensionTracker tracker = PlatformUI.getWorkbench().getExtensionTracker();
        tracker.registerObject(descriptor.getConfigurationElement().getDeclaringExtension(), (Object)descriptor, 2);
        this.workingSetDescriptors.put(descriptor.getId(), descriptor);
    }

    public IWorkingSetPage getDefaultWorkingSetPage() {
        WorkingSetDescriptor descriptor = this.workingSetDescriptors.get(DEFAULT_PAGE_ID);
        if (descriptor != null) {
            return descriptor.createWorkingSetPage();
        }
        return null;
    }

    public WorkingSetDescriptor getWorkingSetDescriptor(String pageId) {
        return this.workingSetDescriptors.get(pageId);
    }

    public WorkingSetDescriptor[] getWorkingSetDescriptors() {
        return this.workingSetDescriptors.values().toArray(new WorkingSetDescriptor[this.workingSetDescriptors.size()]);
    }

    public WorkingSetDescriptor[] getNewPageWorkingSetDescriptors() {
        Collection<WorkingSetDescriptor> descriptors = this.workingSetDescriptors.values();
        ArrayList<WorkingSetDescriptor> result = new ArrayList<WorkingSetDescriptor>(descriptors.size());
        for (WorkingSetDescriptor descriptor : descriptors) {
            if (descriptor.getPageClassName() == null) continue;
            result.add(descriptor);
        }
        return result.toArray(new WorkingSetDescriptor[result.size()]);
    }

    public boolean hasNewPageWorkingSetDescriptor() {
        Collection<WorkingSetDescriptor> descriptors = this.workingSetDescriptors.values();
        for (WorkingSetDescriptor descriptor : descriptors) {
            if (descriptor.getPageClassName() == null) continue;
            return true;
        }
        return false;
    }

    public List<WorkingSetDescriptor> getUpdaterDescriptorsForNamespace(String namespace) {
        if (namespace == null) {
            return Collections.emptyList();
        }
        ArrayList<WorkingSetDescriptor> result = new ArrayList<WorkingSetDescriptor>();
        for (WorkingSetDescriptor descriptor : this.workingSetDescriptors.values()) {
            if (!namespace.equals(descriptor.getUpdaterNamespace())) continue;
            result.add(descriptor);
        }
        return result;
    }

    public WorkingSetDescriptor[] getElementAdapterDescriptorsForNamespace(String namespace) {
        if (namespace == null) {
            return new WorkingSetDescriptor[0];
        }
        Collection<WorkingSetDescriptor> descriptors = this.workingSetDescriptors.values();
        ArrayList<WorkingSetDescriptor> result = new ArrayList<WorkingSetDescriptor>();
        for (WorkingSetDescriptor descriptor : descriptors) {
            if (!namespace.equals(descriptor.getDeclaringNamespace())) continue;
            result.add(descriptor);
        }
        return result.toArray(new WorkingSetDescriptor[result.size()]);
    }

    public IWorkingSetPage getWorkingSetPage(String pageId) {
        WorkingSetDescriptor descriptor = this.workingSetDescriptors.get(pageId);
        if (descriptor == null) {
            return null;
        }
        return descriptor.createWorkingSetPage();
    }

    public void load() {
        WorkingSetRegistryReader reader = new WorkingSetRegistryReader();
        reader.readWorkingSets(Platform.getExtensionRegistry(), this);
    }

    public void addExtension(IExtensionTracker tracker, IExtension extension) {
        WorkingSetRegistryReader reader = new WorkingSetRegistryReader(this);
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            reader.readElement(element);
            ++n2;
        }
    }

    public void removeExtension(IExtension extension, Object[] objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof WorkingSetDescriptor) {
                WorkingSetDescriptor desc = (WorkingSetDescriptor)object;
                this.workingSetDescriptors.remove(desc.getId());
            }
            ++n2;
        }
    }
}

