/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

import java.sql.ResultSet;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.generic.model.GenericTrigger;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;

public abstract class AltibaseTrigger<OWNER extends DBSObject>
extends GenericTrigger<DBSObject>
implements DBPSystemObject,
DBPScriptObject {
    protected boolean isEnable;
    protected String eventTime;
    protected String eventType;
    protected String granularity;
    protected int updateColumnCount;
    protected int refRowCount;
    protected String dmlStmtType;
    protected String dmlTableSchema;
    protected String dmlTableName;

    public AltibaseTrigger(OWNER container, String name, String description, JDBCResultSet dbResult) {
        super(container, name, description);
        this.isEnable = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"IS_ENABLE") == 1;
        this.eventTime = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"EVENT_TIME");
        this.eventType = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"EVENT_TYPE");
        this.granularity = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"GRANULARITY");
        this.updateColumnCount = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"UPDATE_COLUMN_CNT");
        this.refRowCount = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"REF_ROW_CNT");
        this.dmlStmtType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DML_STMT_TYPE");
        this.dmlTableSchema = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DMLTABLE_SCHEMA");
        this.dmlTableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DMLTABLE_NAME");
    }

    public boolean isSystem() {
        return false;
    }

    @Property(viewable=true, order=4)
    public DBSTable getTable() {
        return (DBSTable)this.getParentObject();
    }

    @Property(viewable=true, order=5)
    public boolean isEnabled() {
        return this.isEnable;
    }

    @Property(viewable=true, order=6)
    public String getEventTime() {
        return this.eventTime;
    }

    @Property(viewable=true, order=7)
    public String getEventType() {
        return this.eventType;
    }

    @Property(viewable=true, order=8)
    public int getUpdateColumnCount() {
        return this.updateColumnCount;
    }

    @Property(viewable=true, order=9)
    public String getGranularity() {
        return this.granularity;
    }

    @Property(viewable=true, order=10)
    public String getTargetTable() {
        return this.dmlTableSchema == null || this.dmlTableName == null ? "" : this.dmlTableSchema + "." + this.dmlTableName;
    }

    @Property(viewable=true, order=11)
    public String getDmlType() {
        return this.dmlStmtType;
    }

    @Property(viewable=false, hidden=true, order=100)
    public String getDescription() {
        return null;
    }

    @Nullable
    public String getSource() {
        return this.source;
    }
}

