/*
 * Decompiled with CFR 0.152.
 */
package proguard.gui.splash;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;

final class OverrideGraphics2D
extends Graphics2D {
    private final Graphics2D graphics;
    private Color overrideColor;
    private Font overrideFont;
    private Paint overridePaint;
    private Stroke overrideStroke;
    private Color overrideXORMode;
    private Color color;
    private Font font;
    private Paint paint;
    private Stroke stroke;

    public OverrideGraphics2D(Graphics2D graphics) {
        this.graphics = graphics;
        this.color = graphics.getColor();
        this.font = graphics.getFont();
        this.paint = graphics.getPaint();
        this.stroke = graphics.getStroke();
    }

    public void setOverrideColor(Color color) {
        this.overrideColor = color;
        this.graphics.setColor(color != null ? color : this.color);
    }

    public void setOverrideFont(Font font) {
        this.overrideFont = font;
        this.graphics.setFont(font != null ? font : this.font);
    }

    public void setOverridePaint(Paint paint) {
        this.overridePaint = paint;
        this.graphics.setPaint(paint != null ? paint : this.paint);
    }

    public void setOverrideStroke(Stroke stroke) {
        this.overrideStroke = stroke;
        this.graphics.setStroke(stroke != null ? stroke : this.stroke);
    }

    public void setOverrideXORMode(Color color) {
        this.overrideXORMode = color;
        if (color != null) {
            this.graphics.setXORMode(color);
        } else {
            this.graphics.setPaintMode();
        }
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
        if (this.overrideColor == null) {
            this.graphics.setColor(color);
        }
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
        if (this.overrideFont == null) {
            this.graphics.setFont(font);
        }
    }

    @Override
    public void setPaint(Paint paint) {
        this.paint = paint;
        if (this.overridePaint == null) {
            this.graphics.setPaint(paint);
        }
    }

    @Override
    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
        if (this.overrideStroke == null) {
            this.graphics.setStroke(stroke);
        }
    }

    @Override
    public void setXORMode(Color color) {
        if (this.overrideXORMode == null) {
            this.graphics.setXORMode(color);
        }
    }

    @Override
    public void setPaintMode() {
        if (this.overrideXORMode == null) {
            this.graphics.setPaintMode();
        }
    }

    @Override
    public Color getColor() {
        return this.overrideColor != null ? this.color : this.graphics.getColor();
    }

    @Override
    public Font getFont() {
        return this.overrideFont != null ? this.font : this.graphics.getFont();
    }

    @Override
    public Paint getPaint() {
        return this.overridePaint != null ? this.paint : this.graphics.getPaint();
    }

    @Override
    public Stroke getStroke() {
        return this.overrideStroke != null ? this.stroke : this.graphics.getStroke();
    }

    @Override
    public Graphics create() {
        OverrideGraphics2D g = new OverrideGraphics2D((Graphics2D)this.graphics.create());
        g.setOverrideColor(this.overrideColor);
        g.setOverrideFont(this.overrideFont);
        g.setOverridePaint(this.overridePaint);
        g.setOverrideStroke(this.overrideStroke);
        return g;
    }

    @Override
    public Graphics create(int x, int y, int width, int height) {
        OverrideGraphics2D g = new OverrideGraphics2D((Graphics2D)this.graphics.create(x, y, width, height));
        g.setOverrideColor(this.overrideColor);
        g.setOverrideFont(this.overrideFont);
        g.setOverridePaint(this.overridePaint);
        g.setOverrideStroke(this.overrideStroke);
        return g;
    }

    public void addRenderingHints(Map hints) {
        this.graphics.addRenderingHints(hints);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        this.graphics.clearRect(x, y, width, height);
    }

    @Override
    public void clip(Shape s) {
        this.graphics.clip(s);
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.graphics.clipRect(x, y, width, height);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.graphics.copyArea(x, y, width, height, dx, dy);
    }

    @Override
    public void dispose() {
        this.graphics.dispose();
    }

    @Override
    public void draw(Shape s) {
        this.graphics.draw(s);
    }

    @Override
    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        this.graphics.draw3DRect(x, y, width, height, raised);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.graphics.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
        this.graphics.drawBytes(data, offset, length, x, y);
    }

    @Override
    public void drawChars(char[] data, int offset, int length, int x, int y) {
        this.graphics.drawChars(data, offset, length, x, y);
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        this.graphics.drawGlyphVector(g, x, y);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return this.graphics.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.graphics.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return this.graphics.drawImage(img, x, y, width, height, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.graphics.drawImage(img, x, y, width, height, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.graphics.drawImage(img, x, y, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.graphics.drawImage(img, x, y, observer);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return this.graphics.drawImage(img, xform, obs);
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        this.graphics.drawImage(img, op, x, y);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.graphics.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.graphics.drawOval(x, y, width, height);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.graphics.drawPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    public void drawPolygon(Polygon p) {
        this.graphics.drawPolygon(p);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.graphics.drawPolyline(xPoints, yPoints, nPoints);
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        this.graphics.drawRect(x, y, width, height);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.graphics.drawRenderableImage(img, xform);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        this.graphics.drawRenderedImage(img, xform);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.graphics.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void drawString(String s, float x, float y) {
        this.graphics.drawString(s, x, y);
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.graphics.drawString(str, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.graphics.drawString(iterator, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.graphics.drawString(iterator, x, y);
    }

    public boolean equals(Object obj) {
        return this.graphics.equals(obj);
    }

    @Override
    public void fill(Shape s) {
        this.graphics.fill(s);
    }

    @Override
    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        this.graphics.fill3DRect(x, y, width, height, raised);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.graphics.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.graphics.fillOval(x, y, width, height);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.graphics.fillPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    public void fillPolygon(Polygon p) {
        this.graphics.fillPolygon(p);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.graphics.fillRect(x, y, width, height);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.graphics.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public Color getBackground() {
        return this.graphics.getBackground();
    }

    @Override
    public Shape getClip() {
        return this.graphics.getClip();
    }

    @Override
    public Rectangle getClipBounds() {
        return this.graphics.getClipBounds();
    }

    @Override
    public Rectangle getClipBounds(Rectangle r) {
        return this.graphics.getClipBounds(r);
    }

    @Override
    public Rectangle getClipRect() {
        return this.graphics.getClipRect();
    }

    @Override
    public Composite getComposite() {
        return this.graphics.getComposite();
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.graphics.getDeviceConfiguration();
    }

    @Override
    public FontMetrics getFontMetrics() {
        return this.graphics.getFontMetrics();
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return this.graphics.getFontMetrics(f);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.graphics.getFontRenderContext();
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.graphics.getRenderingHint(hintKey);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.graphics.getRenderingHints();
    }

    @Override
    public AffineTransform getTransform() {
        return this.graphics.getTransform();
    }

    public int hashCode() {
        return this.graphics.hashCode();
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return this.graphics.hit(rect, s, onStroke);
    }

    @Override
    public boolean hitClip(int x, int y, int width, int height) {
        return this.graphics.hitClip(x, y, width, height);
    }

    @Override
    public void rotate(double theta) {
        this.graphics.rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.graphics.rotate(theta, x, y);
    }

    @Override
    public void scale(double sx, double sy) {
        this.graphics.scale(sx, sy);
    }

    @Override
    public void setBackground(Color color) {
        this.graphics.setBackground(color);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.graphics.setClip(x, y, width, height);
    }

    @Override
    public void setClip(Shape clip) {
        this.graphics.setClip(clip);
    }

    @Override
    public void setComposite(Composite comp) {
        this.graphics.setComposite(comp);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.graphics.setRenderingHint(hintKey, hintValue);
    }

    public void setRenderingHints(Map hints) {
        this.graphics.setRenderingHints(hints);
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        this.graphics.setTransform(Tx);
    }

    @Override
    public void shear(double shx, double shy) {
        this.graphics.shear(shx, shy);
    }

    @Override
    public String toString() {
        return this.graphics.toString();
    }

    @Override
    public void transform(AffineTransform Tx) {
        this.graphics.transform(Tx);
    }

    @Override
    public void translate(double tx, double ty) {
        this.graphics.translate(tx, ty);
    }

    @Override
    public void translate(int x, int y) {
        this.graphics.translate(x, y);
    }
}

