﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iotanalytics/IoTAnalytics_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace IoTAnalytics {
namespace Model {

/**
 * <p>The activity that determines the source of the messages to be
 * processed.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ChannelActivity">AWS
 * API Reference</a></p>
 */
class ChannelActivity {
 public:
  AWS_IOTANALYTICS_API ChannelActivity() = default;
  AWS_IOTANALYTICS_API ChannelActivity(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTANALYTICS_API ChannelActivity& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTANALYTICS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the channel activity.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  ChannelActivity& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the channel from which the messages are processed.</p>
   */
  inline const Aws::String& GetChannelName() const { return m_channelName; }
  inline bool ChannelNameHasBeenSet() const { return m_channelNameHasBeenSet; }
  template <typename ChannelNameT = Aws::String>
  void SetChannelName(ChannelNameT&& value) {
    m_channelNameHasBeenSet = true;
    m_channelName = std::forward<ChannelNameT>(value);
  }
  template <typename ChannelNameT = Aws::String>
  ChannelActivity& WithChannelName(ChannelNameT&& value) {
    SetChannelName(std::forward<ChannelNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The next activity in the pipeline.</p>
   */
  inline const Aws::String& GetNext() const { return m_next; }
  inline bool NextHasBeenSet() const { return m_nextHasBeenSet; }
  template <typename NextT = Aws::String>
  void SetNext(NextT&& value) {
    m_nextHasBeenSet = true;
    m_next = std::forward<NextT>(value);
  }
  template <typename NextT = Aws::String>
  ChannelActivity& WithNext(NextT&& value) {
    SetNext(std::forward<NextT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;

  Aws::String m_channelName;

  Aws::String m_next;
  bool m_nameHasBeenSet = false;
  bool m_channelNameHasBeenSet = false;
  bool m_nextHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTAnalytics
}  // namespace Aws
