﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/fis/FIS_EXPORTS.h>
#include <aws/fis/model/ExperimentTemplateTargetInputFilter.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace FIS {
namespace Model {

/**
 * <p>Specifies a target for an experiment. You must specify at least one Amazon
 * Resource Name (ARN) or at least one resource tag. You cannot specify both ARNs
 * and tags.</p> <p>For more information, see <a
 * href="https://docs.aws.amazon.com/fis/latest/userguide/targets.html">Targets</a>
 * in the <i>Fault Injection Service User Guide</i>.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/CreateExperimentTemplateTargetInput">AWS
 * API Reference</a></p>
 */
class CreateExperimentTemplateTargetInput {
 public:
  AWS_FIS_API CreateExperimentTemplateTargetInput() = default;
  AWS_FIS_API CreateExperimentTemplateTargetInput(Aws::Utils::Json::JsonView jsonValue);
  AWS_FIS_API CreateExperimentTemplateTargetInput& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_FIS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The resource type. The resource type must be supported for the specified
   * action.</p>
   */
  inline const Aws::String& GetResourceType() const { return m_resourceType; }
  inline bool ResourceTypeHasBeenSet() const { return m_resourceTypeHasBeenSet; }
  template <typename ResourceTypeT = Aws::String>
  void SetResourceType(ResourceTypeT&& value) {
    m_resourceTypeHasBeenSet = true;
    m_resourceType = std::forward<ResourceTypeT>(value);
  }
  template <typename ResourceTypeT = Aws::String>
  CreateExperimentTemplateTargetInput& WithResourceType(ResourceTypeT&& value) {
    SetResourceType(std::forward<ResourceTypeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Names (ARNs) of the resources.</p>
   */
  inline const Aws::Vector<Aws::String>& GetResourceArns() const { return m_resourceArns; }
  inline bool ResourceArnsHasBeenSet() const { return m_resourceArnsHasBeenSet; }
  template <typename ResourceArnsT = Aws::Vector<Aws::String>>
  void SetResourceArns(ResourceArnsT&& value) {
    m_resourceArnsHasBeenSet = true;
    m_resourceArns = std::forward<ResourceArnsT>(value);
  }
  template <typename ResourceArnsT = Aws::Vector<Aws::String>>
  CreateExperimentTemplateTargetInput& WithResourceArns(ResourceArnsT&& value) {
    SetResourceArns(std::forward<ResourceArnsT>(value));
    return *this;
  }
  template <typename ResourceArnsT = Aws::String>
  CreateExperimentTemplateTargetInput& AddResourceArns(ResourceArnsT&& value) {
    m_resourceArnsHasBeenSet = true;
    m_resourceArns.emplace_back(std::forward<ResourceArnsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The tags for the target resources.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetResourceTags() const { return m_resourceTags; }
  inline bool ResourceTagsHasBeenSet() const { return m_resourceTagsHasBeenSet; }
  template <typename ResourceTagsT = Aws::Map<Aws::String, Aws::String>>
  void SetResourceTags(ResourceTagsT&& value) {
    m_resourceTagsHasBeenSet = true;
    m_resourceTags = std::forward<ResourceTagsT>(value);
  }
  template <typename ResourceTagsT = Aws::Map<Aws::String, Aws::String>>
  CreateExperimentTemplateTargetInput& WithResourceTags(ResourceTagsT&& value) {
    SetResourceTags(std::forward<ResourceTagsT>(value));
    return *this;
  }
  template <typename ResourceTagsKeyT = Aws::String, typename ResourceTagsValueT = Aws::String>
  CreateExperimentTemplateTargetInput& AddResourceTags(ResourceTagsKeyT&& key, ResourceTagsValueT&& value) {
    m_resourceTagsHasBeenSet = true;
    m_resourceTags.emplace(std::forward<ResourceTagsKeyT>(key), std::forward<ResourceTagsValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The filters to apply to identify target resources using specific
   * attributes.</p>
   */
  inline const Aws::Vector<ExperimentTemplateTargetInputFilter>& GetFilters() const { return m_filters; }
  inline bool FiltersHasBeenSet() const { return m_filtersHasBeenSet; }
  template <typename FiltersT = Aws::Vector<ExperimentTemplateTargetInputFilter>>
  void SetFilters(FiltersT&& value) {
    m_filtersHasBeenSet = true;
    m_filters = std::forward<FiltersT>(value);
  }
  template <typename FiltersT = Aws::Vector<ExperimentTemplateTargetInputFilter>>
  CreateExperimentTemplateTargetInput& WithFilters(FiltersT&& value) {
    SetFilters(std::forward<FiltersT>(value));
    return *this;
  }
  template <typename FiltersT = ExperimentTemplateTargetInputFilter>
  CreateExperimentTemplateTargetInput& AddFilters(FiltersT&& value) {
    m_filtersHasBeenSet = true;
    m_filters.emplace_back(std::forward<FiltersT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Scopes the identified resources to a specific count of the resources at
   * random, or a percentage of the resources. All identified resources are included
   * in the target.</p> <ul> <li> <p>ALL - Run the action on all identified targets.
   * This is the default.</p> </li> <li> <p>COUNT(n) - Run the action on the
   * specified number of targets, chosen from the identified targets at random. For
   * example, COUNT(1) selects one of the targets.</p> </li> <li> <p>PERCENT(n) - Run
   * the action on the specified percentage of targets, chosen from the identified
   * targets at random. For example, PERCENT(25) selects 25% of the targets.</p>
   * </li> </ul>
   */
  inline const Aws::String& GetSelectionMode() const { return m_selectionMode; }
  inline bool SelectionModeHasBeenSet() const { return m_selectionModeHasBeenSet; }
  template <typename SelectionModeT = Aws::String>
  void SetSelectionMode(SelectionModeT&& value) {
    m_selectionModeHasBeenSet = true;
    m_selectionMode = std::forward<SelectionModeT>(value);
  }
  template <typename SelectionModeT = Aws::String>
  CreateExperimentTemplateTargetInput& WithSelectionMode(SelectionModeT&& value) {
    SetSelectionMode(std::forward<SelectionModeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The resource type parameters.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetParameters() const { return m_parameters; }
  inline bool ParametersHasBeenSet() const { return m_parametersHasBeenSet; }
  template <typename ParametersT = Aws::Map<Aws::String, Aws::String>>
  void SetParameters(ParametersT&& value) {
    m_parametersHasBeenSet = true;
    m_parameters = std::forward<ParametersT>(value);
  }
  template <typename ParametersT = Aws::Map<Aws::String, Aws::String>>
  CreateExperimentTemplateTargetInput& WithParameters(ParametersT&& value) {
    SetParameters(std::forward<ParametersT>(value));
    return *this;
  }
  template <typename ParametersKeyT = Aws::String, typename ParametersValueT = Aws::String>
  CreateExperimentTemplateTargetInput& AddParameters(ParametersKeyT&& key, ParametersValueT&& value) {
    m_parametersHasBeenSet = true;
    m_parameters.emplace(std::forward<ParametersKeyT>(key), std::forward<ParametersValueT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_resourceType;

  Aws::Vector<Aws::String> m_resourceArns;

  Aws::Map<Aws::String, Aws::String> m_resourceTags;

  Aws::Vector<ExperimentTemplateTargetInputFilter> m_filters;

  Aws::String m_selectionMode;

  Aws::Map<Aws::String, Aws::String> m_parameters;
  bool m_resourceTypeHasBeenSet = false;
  bool m_resourceArnsHasBeenSet = false;
  bool m_resourceTagsHasBeenSet = false;
  bool m_filtersHasBeenSet = false;
  bool m_selectionModeHasBeenSet = false;
  bool m_parametersHasBeenSet = false;
};

}  // namespace Model
}  // namespace FIS
}  // namespace Aws
