﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/autoscaling/AutoScalingRequest.h>
#include <aws/autoscaling/AutoScaling_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace AutoScaling {
namespace Model {

/**
 */
class TerminateInstanceInAutoScalingGroupRequest : public AutoScalingRequest {
 public:
  AWS_AUTOSCALING_API TerminateInstanceInAutoScalingGroupRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "TerminateInstanceInAutoScalingGroup"; }

  AWS_AUTOSCALING_API Aws::String SerializePayload() const override;

 protected:
  AWS_AUTOSCALING_API void DumpBodyToUrl(Aws::Http::URI& uri) const override;

 public:
  ///@{
  /**
   * <p>The ID of the instance.</p>
   */
  inline const Aws::String& GetInstanceId() const { return m_instanceId; }
  inline bool InstanceIdHasBeenSet() const { return m_instanceIdHasBeenSet; }
  template <typename InstanceIdT = Aws::String>
  void SetInstanceId(InstanceIdT&& value) {
    m_instanceIdHasBeenSet = true;
    m_instanceId = std::forward<InstanceIdT>(value);
  }
  template <typename InstanceIdT = Aws::String>
  TerminateInstanceInAutoScalingGroupRequest& WithInstanceId(InstanceIdT&& value) {
    SetInstanceId(std::forward<InstanceIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Indicates whether terminating the instance also decrements the size of the
   * Auto Scaling group.</p>
   */
  inline bool GetShouldDecrementDesiredCapacity() const { return m_shouldDecrementDesiredCapacity; }
  inline bool ShouldDecrementDesiredCapacityHasBeenSet() const { return m_shouldDecrementDesiredCapacityHasBeenSet; }
  inline void SetShouldDecrementDesiredCapacity(bool value) {
    m_shouldDecrementDesiredCapacityHasBeenSet = true;
    m_shouldDecrementDesiredCapacity = value;
  }
  inline TerminateInstanceInAutoScalingGroupRequest& WithShouldDecrementDesiredCapacity(bool value) {
    SetShouldDecrementDesiredCapacity(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_instanceId;

  bool m_shouldDecrementDesiredCapacity{false};
  bool m_instanceIdHasBeenSet = false;
  bool m_shouldDecrementDesiredCapacityHasBeenSet = false;
};

}  // namespace Model
}  // namespace AutoScaling
}  // namespace Aws
