/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import java.time.Instant;
import javax.annotation.Nonnull;
import net.shibboleth.shared.xml.AttributeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.common.AbstractSAMLObjectMarshaller;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.w3c.dom.Element;

public abstract class StatusResponseTypeMarshaller
extends AbstractSAMLObjectMarshaller {
    @Override
    protected void marshallAttributes(@Nonnull XMLObject xmlObject, @Nonnull Element domElement) throws MarshallingException {
        Instant i;
        StatusResponseType sr = (StatusResponseType)xmlObject;
        SAMLVersion version = sr.getVersion();
        if (version != null) {
            domElement.setAttributeNS(null, "Version", version.toString());
        }
        if (sr.getID() != null) {
            domElement.setAttributeNS(null, "ID", sr.getID());
        }
        if (sr.getInResponseTo() != null) {
            domElement.setAttributeNS(null, "InResponseTo", sr.getInResponseTo());
        }
        if ((i = sr.getIssueInstant()) != null) {
            AttributeSupport.appendDateTimeAttribute(domElement, StatusResponseType.ISSUE_INSTANT_ATTRIB_QNAME, i);
        }
        if (sr.getDestination() != null) {
            domElement.setAttributeNS(null, "Destination", sr.getDestination());
        }
        if (sr.getConsent() != null) {
            domElement.setAttributeNS(null, "Consent", sr.getConsent());
        }
    }

    @Override
    protected void marshallAttributeIDness(@Nonnull XMLObject xmlObject, @Nonnull Element domElement) throws MarshallingException {
        XMLObjectSupport.marshallAttributeIDness(null, "ID", domElement, true);
    }
}

