/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.telemetry;

import java.util.List;
import java.util.Optional;
import org.opensearch.plugins.TelemetryPlugin;
import org.opensearch.telemetry.Telemetry;
import org.opensearch.telemetry.TelemetrySettings;

public class TelemetryModule {
    private Telemetry telemetry;

    public TelemetryModule(List<TelemetryPlugin> telemetryPlugins, TelemetrySettings telemetrySettings) {
        for (TelemetryPlugin telemetryPlugin : telemetryPlugins) {
            Optional<Telemetry> telemetry = telemetryPlugin.getTelemetry(telemetrySettings);
            if (!telemetry.isPresent()) continue;
            this.registerTelemetry(telemetry.get());
        }
    }

    public Optional<Telemetry> getTelemetry() {
        return Optional.ofNullable(this.telemetry);
    }

    private void registerTelemetry(Telemetry factory) {
        if (this.telemetry != null) {
            throw new IllegalArgumentException("Cannot register more than one telemetry");
        }
        this.telemetry = factory;
    }
}

