/*******************************************************************************
* Copyright (C) 2023 Intel Corporation
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

#ifdef BASIC_PROFILING

#include <iostream>
#include <iomanip>
#include <fstream>
#include "VeryBasicProfiler.hpp"
#include "mytimer.hpp"


#ifdef HPCG_NO_MPI
VeryBasicProfiler::VeryBasicProfiler() {
    size_ = 1;
    rank_ = 0;
}
#else
VeryBasicProfiler::VeryBasicProfiler(MPI_Comm comm) {
    MPI_Comm_size(comm, &size_);
    MPI_Comm_rank(comm, &rank_);
}
#endif

void VeryBasicProfiler::begin(const std::string& name) {
    names_.push_back(name);
    begin_end_.push_back(0);
    timestamps_.push_back(mytimer());
}

void VeryBasicProfiler::end(const std::string& name) {
    names_.push_back(name);
    begin_end_.push_back(1);
    timestamps_.push_back(mytimer());
}

void VeryBasicProfiler::Clear() {
    names_.clear();
    begin_end_.clear();
    timestamps_.clear();
}

void VeryBasicProfiler::Write(const std::string& filename) {
    int endrank = std::min(size_, 4);
    for (int i = 0; i < endrank; i++) {
        if (rank_ == i) {
            std::ofstream out;
            if (rank_ == 0) {
                out.open(filename.c_str());
                out << "[\n";
            }
            else {
                out.open(filename.c_str(), std::ios_base::app);
            }
            out << std::setprecision(16);

            for (size_t k = 0; k < names_.size(); k++) {
                out << "  {\"name\": \"" << names_[k] << "\", ";
                out << "\"cat\": \"none\", \"ph\": ";
                if (begin_end_[k] == 0) {
                    out << "\"B\", ";
                }
                else {
                    out << "\"E\", ";
                }
                out << "\"pid\": " << rank_ << ", \"tid\": 0, ";
                if (k == names_.size() - 1 && rank_ == endrank - 1) {
                    // chrome:://tracing uses microseconds, mytimer() uses seconds
                    out << "\"ts\": " << timestamps_[k] * 1.e+6 << "}" << std::endl;
                }
                else {
                    out << "\"ts\": " << timestamps_[k] * 1.e+6 << "}," << std::endl;
                }
            }
            if (rank_ == endrank - 1) {
                out << "]" << std::endl;
            }
        }
#ifndef HPCG_NO_MPI
        MPI_Barrier(MPI_COMM_WORLD);
#endif
    }
}

#endif
