/*
 * Copyright (C) 2020 Intel Corporation
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them
 * is governed by the express license under which they were provided to you ("License"). Unless
 * the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
 * or transmit this software or the related documents without Intel's prior written permission.
 *
 * This software and the related documents are provided as is, with no express or implied
 * warranties, other than those that are expressly stated in the License.
*/

__kernel void SimpleAdd3(__global float *pA, __global float *pB, __global float *pC, __local float *pD)
{
    const int id = get_global_id(0);
    const int lid = get_local_id(0);

    int base = id * 16;

    for (unsigned i = 0; i < 16; i++)
    {
        pD[i] = pA[base + i] + pB[base + i] + pC[base + i];
    }
}
