/*******************************************************************************
 * Copyright 2016 Intel Corporation.
 *
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them is governed by
 * the express license under which they were provided to you ('License'). Unless the License provides otherwise,
 * you may not use, modify, copy, publish, distribute, disclose or transmit this software or the related
 * documents without Intel's prior written permission.
 * This software and the related documents are provided as is, with no express or implied warranties, other than
 * those that are expressly stated in the License.
 *******************************************************************************/

#if !defined(__IPP_RESIZE_IWPP__)
  #define __IPP_RESIZE_IWPP__

  #include <math.h>
  #include <memory>

  #include "ipp/iw++/iw.hpp"
  #include "iw_resize_base.h"

class ResizeIWPP : public ResizeBase
{
public:
    ResizeIWPP(ParallelInterface parallel = PARALLEL_NONE)
    {
        m_className = "ResizeIW++";
        SetParallelInterface(parallel);
    }

    Status Init(Image &src, Image &dst, IppiInterpolationType interpolation)
    {
        IppDataType dataType = ImageFormatToIpp(src.m_sampleFormat);
        ipp::IwiSize srcSize(ImageSizeToIpp(src.m_size));
        ipp::IwiSize dstSize(ImageSizeToIpp(dst.m_size));

        try {
            m_resize.InitAlloc(srcSize, dstSize, dataType, src.m_samples, interpolation, ipp::IwiResizeParams(), ippBorderRepl);
        } catch (const ipp::IwException &ex) {
            CHECK_STATUS_PRINT_AC(ex.m_status, "IwiResize::InitAlloc()", iwGetStatusString(ex.m_status), return STS_ERR_FAILED);
        }

        return STS_OK;
    }

    Status Run(Image &src, Image &dst, Rect roi)
    {
        try {
            ipp::IwiImage iwSrc = ImageToIwImage(src);
            ipp::IwiImage iwDst = ImageToIwImage(dst);

            m_resize(iwSrc, iwDst, ippBorderRepl, ipp::IwiRoi((IwSize)roi.x, (IwSize)roi.y, (IwSize)roi.width, (IwSize)roi.height));
        } catch (const ipp::IwException &ex) {
            CHECK_STATUS_PRINT_AC(ex.m_status, "IwiResize()", iwGetStatusString(ex.m_status), return STS_ERR_FAILED);
        }

        return STS_OK;
    }

protected:
    ipp::IwiResize m_resize;
};

#endif
