/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import mpi.Allocable;
import mpi.AllocablePool;
import mpi.Datatype;
import mpi.MPIJHelper;

public class Aint
implements Allocable {
    private long handle;

    public Aint() {
        this.init();
        AllocablePool.add(this);
    }

    public long getHandle() {
        return this.handle;
    }

    public int getLongValue() {
        return this.getLongValue(this.handle);
    }

    private native int getLongValue(long var1);

    void setHandle(long l) {
        this.handle = l;
    }

    private native void init();

    @Override
    public void free() {
        AllocablePool.remove(this);
        this.jniFree();
    }

    public native void jniFree();

    public static int extent(Datatype datatype, Aint aint) {
        long l = MPIJHelper.getDatatypeId(datatype);
        return Aint.MPI_Type_extent(l, datatype.isCustom(), aint.getHandle());
    }

    private static native int MPI_Type_extent(long var0, boolean var2, long var3);

    public static void getExtent(Datatype datatype, Aint aint, Aint aint2) {
        long l = MPIJHelper.getDatatypeId(datatype);
        Aint.MPI_Type_get_extent(l, datatype.isCustom(), aint.getHandle(), aint2.getHandle());
    }

    private static native void MPI_Type_get_extent(long var0, boolean var2, long var3, long var5);

    public static void address(long l, Aint aint) {
        Aint.MPI_Address(l, aint.getHandle());
    }

    private static native void MPI_Address(long var0, long var2);

    public static void getAddress(long l, Aint aint) {
        Aint.MPI_Get_address(l, aint.getHandle());
    }

    private static native void MPI_Get_address(long var0, long var2);

    public static void getTrueExtent(Datatype datatype, Aint aint, Aint aint2) {
        long l = MPIJHelper.getDatatypeId(datatype);
        Aint.MPI_Type_get_extent(l, datatype.isCustom(), aint.getHandle(), aint2.getHandle());
    }

    private static native void MPI_Type_get_true_extent(long var0, boolean var2, long var3, long var5);

    public static void getContents(Datatype datatype, int n, int n2, int n3, int[] nArray, Aint[] aintArray, Datatype[] datatypeArray) {
        int n4;
        long l = MPIJHelper.getDatatypeId(datatype);
        long[] lArray = new long[aintArray.length];
        long[] lArray2 = new long[datatypeArray.length];
        Aint.MPI_Type_get_contents(l, datatype.isCustom(), n, n2, n3, nArray, lArray, lArray2);
        for (n4 = 0; n4 < lArray.length; ++n4) {
            aintArray[n4].setHandle(lArray[n4]);
        }
        for (n4 = 0; n4 < lArray2.length; ++n4) {
            datatypeArray[n4].setHandle(lArray2[n4]);
        }
    }

    private static native void MPI_Type_get_contents(long var0, boolean var2, int var3, int var4, int var5, int[] var6, long[] var7, long[] var8);
}

