﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/workspaces-instances/WorkspacesInstances_EXPORTS.h>
#include <aws/workspaces-instances/model/EbsBlockDevice.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace WorkspacesInstances {
namespace Model {

/**
 * <p>Defines device mapping for WorkSpace Instance storage.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/BlockDeviceMappingRequest">AWS
 * API Reference</a></p>
 */
class BlockDeviceMappingRequest {
 public:
  AWS_WORKSPACESINSTANCES_API BlockDeviceMappingRequest() = default;
  AWS_WORKSPACESINSTANCES_API BlockDeviceMappingRequest(Aws::Utils::Json::JsonView jsonValue);
  AWS_WORKSPACESINSTANCES_API BlockDeviceMappingRequest& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_WORKSPACESINSTANCES_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Name of the device for storage mapping.</p>
   */
  inline const Aws::String& GetDeviceName() const { return m_deviceName; }
  inline bool DeviceNameHasBeenSet() const { return m_deviceNameHasBeenSet; }
  template <typename DeviceNameT = Aws::String>
  void SetDeviceName(DeviceNameT&& value) {
    m_deviceNameHasBeenSet = true;
    m_deviceName = std::forward<DeviceNameT>(value);
  }
  template <typename DeviceNameT = Aws::String>
  BlockDeviceMappingRequest& WithDeviceName(DeviceNameT&& value) {
    SetDeviceName(std::forward<DeviceNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>EBS volume configuration for the device.</p>
   */
  inline const EbsBlockDevice& GetEbs() const { return m_ebs; }
  inline bool EbsHasBeenSet() const { return m_ebsHasBeenSet; }
  template <typename EbsT = EbsBlockDevice>
  void SetEbs(EbsT&& value) {
    m_ebsHasBeenSet = true;
    m_ebs = std::forward<EbsT>(value);
  }
  template <typename EbsT = EbsBlockDevice>
  BlockDeviceMappingRequest& WithEbs(EbsT&& value) {
    SetEbs(std::forward<EbsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Indicates device should not be mapped.</p>
   */
  inline const Aws::String& GetNoDevice() const { return m_noDevice; }
  inline bool NoDeviceHasBeenSet() const { return m_noDeviceHasBeenSet; }
  template <typename NoDeviceT = Aws::String>
  void SetNoDevice(NoDeviceT&& value) {
    m_noDeviceHasBeenSet = true;
    m_noDevice = std::forward<NoDeviceT>(value);
  }
  template <typename NoDeviceT = Aws::String>
  BlockDeviceMappingRequest& WithNoDevice(NoDeviceT&& value) {
    SetNoDevice(std::forward<NoDeviceT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Virtual device name for ephemeral storage.</p>
   */
  inline const Aws::String& GetVirtualName() const { return m_virtualName; }
  inline bool VirtualNameHasBeenSet() const { return m_virtualNameHasBeenSet; }
  template <typename VirtualNameT = Aws::String>
  void SetVirtualName(VirtualNameT&& value) {
    m_virtualNameHasBeenSet = true;
    m_virtualName = std::forward<VirtualNameT>(value);
  }
  template <typename VirtualNameT = Aws::String>
  BlockDeviceMappingRequest& WithVirtualName(VirtualNameT&& value) {
    SetVirtualName(std::forward<VirtualNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_deviceName;
  bool m_deviceNameHasBeenSet = false;

  EbsBlockDevice m_ebs;
  bool m_ebsHasBeenSet = false;

  Aws::String m_noDevice;
  bool m_noDeviceHasBeenSet = false;

  Aws::String m_virtualName;
  bool m_virtualNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace WorkspacesInstances
}  // namespace Aws
