/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.sessions;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Session;
import org.zaproxy.zap.extension.sessions.ExtensionSessionManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.session.AbstractSessionManagementMethodOptionsPanel;
import org.zaproxy.zap.session.SessionManagementMethod;
import org.zaproxy.zap.session.SessionManagementMethodType;
import org.zaproxy.zap.utils.FontUtils;
import org.zaproxy.zap.utils.ZapHtmlLabel;
import org.zaproxy.zap.view.AbstractContextPropertiesPanel;
import org.zaproxy.zap.view.LayoutHelper;

public class ContextSessionManagementPanel
extends AbstractContextPropertiesPanel {
    private static final String PANEL_NAME = Constant.messages.getString("sessionmanagement.panel.title");
    private static final String CONFIG_NOT_NEEDED = Constant.messages.getString("sessionmanagement.panel.label.noConfigPanel");
    private static final Logger LOGGER = LogManager.getLogger(ContextSessionManagementPanel.class);
    private static final long serialVersionUID = 6125457981814742851L;
    private ExtensionSessionManagement extension;
    private JComboBox<SessionManagementMethodType> sessionManagementMethodsComboBox;
    private SessionManagementMethod selectedMethod;
    private SessionManagementMethodType shownMethodType;
    private AbstractSessionManagementMethodOptionsPanel shownConfigPanel;
    private JPanel configContainerPanel;

    public ContextSessionManagementPanel(ExtensionSessionManagement extension, Context context) {
        super(context.getId());
        this.extension = extension;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName(this.getContextId() + ": " + PANEL_NAME);
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.add((Component)new ZapHtmlLabel(Constant.messages.getString("sessionmanagement.panel.label.description")), LayoutHelper.getGBC(0, 0, 1, 1.0));
        this.add((Component)new JLabel(Constant.messages.getString("sessionmanagement.panel.label.typeSelect")), LayoutHelper.getGBC(0, 1, 1, 1.0, new Insets(20, 0, 5, 5)));
        this.add(this.getSessionManagementMethodsComboBox(), LayoutHelper.getGBC(0, 2, 1, 1.0));
        this.add((Component)this.getConfigContainerPanel(), LayoutHelper.getGBC(0, 3, 1, 1.0, new Insets(10, 0, 10, 0)));
        this.add((Component)new JLabel(), LayoutHelper.getGBC(0, 99, 1, 1.0, 1.0));
    }

    private void changeMethodConfigPanel(SessionManagementMethodType newMethodType) {
        if (newMethodType == null) {
            this.getConfigContainerPanel().removeAll();
            this.getConfigContainerPanel().setVisible(false);
            this.shownMethodType = null;
            this.shownConfigPanel = null;
            return;
        }
        if (this.shownMethodType != null && newMethodType.getClass().equals(this.shownMethodType.getClass())) {
            return;
        }
        LOGGER.debug("Creating new panel for configuring: {}", (Object)newMethodType.getName());
        this.getConfigContainerPanel().removeAll();
        if (newMethodType.hasOptionsPanel()) {
            this.shownConfigPanel = newMethodType.buildOptionsPanel(this.getUISharedContext());
            this.getConfigContainerPanel().add((Component)this.shownConfigPanel, "Center");
        } else {
            this.shownConfigPanel = null;
            this.getConfigContainerPanel().add((Component)new ZapHtmlLabel("<html><p>" + CONFIG_NOT_NEEDED + "</p></html>"), "Center");
        }
        this.shownMethodType = newMethodType;
        this.getConfigContainerPanel().setVisible(true);
        this.getConfigContainerPanel().revalidate();
    }

    protected JComboBox<SessionManagementMethodType> getSessionManagementMethodsComboBox() {
        if (this.sessionManagementMethodsComboBox == null) {
            Vector<SessionManagementMethodType> methods = new Vector<SessionManagementMethodType>(this.extension.getSessionManagementMethodTypes());
            this.sessionManagementMethodsComboBox = new JComboBox<SessionManagementMethodType>(methods);
            this.sessionManagementMethodsComboBox.setSelectedItem(null);
            this.sessionManagementMethodsComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        LOGGER.debug("Selected new Session Management type: {}", e.getItem());
                        SessionManagementMethodType type = (SessionManagementMethodType)e.getItem();
                        if (ContextSessionManagementPanel.this.selectedMethod == null || !type.isTypeForMethod(ContextSessionManagementPanel.this.selectedMethod)) {
                            ContextSessionManagementPanel.this.selectedMethod = type.createSessionManagementMethod(ContextSessionManagementPanel.this.getContextId());
                        }
                        ContextSessionManagementPanel.this.changeMethodConfigPanel(type);
                        if (type.hasOptionsPanel()) {
                            ContextSessionManagementPanel.this.shownConfigPanel.bindMethod(ContextSessionManagementPanel.this.selectedMethod);
                        }
                    }
                }
            });
        }
        return this.sessionManagementMethodsComboBox;
    }

    private JPanel getConfigContainerPanel() {
        if (this.configContainerPanel == null) {
            this.configContainerPanel = new JPanel(new BorderLayout());
            this.configContainerPanel.setBorder(BorderFactory.createTitledBorder(null, Constant.messages.getString("sessionmanagement.panel.config.title"), 0, 0, FontUtils.getFont(FontUtils.Size.standard)));
        }
        return this.configContainerPanel;
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.contexts";
    }

    @Override
    public void initContextData(Session session, Context uiSharedContext) {
        this.selectedMethod = uiSharedContext.getSessionManagementMethod();
        LOGGER.debug("Initializing configuration panel for session management method: {}  for context {}", (Object)this.selectedMethod, (Object)uiSharedContext.getName());
        if (this.selectedMethod != null) {
            if (this.shownMethodType != null && this.shownMethodType.isTypeForMethod(this.selectedMethod)) {
                if (this.shownMethodType.hasOptionsPanel()) {
                    this.shownConfigPanel.bindMethod(this.selectedMethod);
                }
                return;
            }
            for (SessionManagementMethodType type : this.extension.getSessionManagementMethodTypes()) {
                if (!type.isTypeForMethod(this.selectedMethod)) continue;
                this.getSessionManagementMethodsComboBox().setSelectedItem(type);
                break;
            }
        }
    }

    @Override
    public void validateContextData(Session session) throws IllegalStateException {
        if (this.selectedMethod == null) {
            throw new IllegalStateException("A valid session management method has to be selected for Context " + this.getUISharedContext().getName());
        }
        if (this.shownConfigPanel != null) {
            this.shownConfigPanel.validateFields();
        }
    }

    @Override
    public void saveContextData(Session session) throws Exception {
        if (this.shownConfigPanel != null) {
            this.shownConfigPanel.saveMethod();
        }
        session.getContext(this.getContextId()).setSessionManagementMethod(this.selectedMethod);
    }

    @Override
    public void saveTemporaryContextData(Context uiSharedContext) {
        if (this.shownConfigPanel != null) {
            this.shownConfigPanel.saveMethod();
        }
        uiSharedContext.setSessionManagementMethod(this.selectedMethod);
    }
}

