# Interface methods for submodule: vnl_matrix
from typing import Union, Any
# additional imports
from .support.template_class import itkTemplate as _itkTemplate



# Interface methods for class: vnl_matrix
class vnl_matrixProxy():
	def size(self) -> int:
		""""""
		...

	def rows(self) -> int:
		""""""
		...

	def cols(self) -> int:
		""""""
		...

	def columns(self) -> int:
		""""""
		...

	@overload
	def put(self, r: int, c: int, arg2) -> None:
		""""""
		...

	@overload
	def put(self, r: int, c: int, arg2: float) -> None:
		""""""
		...

	@overload
	def put(self, r: int, c: int, arg2: int) -> None:
		""""""
		...

	@overload
	def get(self, r: int, c: int):
		""""""
		...

	@overload
	def get(self, r: int, c: int) -> float:
		""""""
		...

	@overload
	def get(self, r: int, c: int) -> int:
		""""""
		...

	@overload
	def __call__(self, r: int, c: int):
		""""""
		...

	@overload
	def __call__(self, r: int, c: int) -> float:
		""""""
		...

	@overload
	def __call__(self, r: int, c: int) -> int:
		""""""
		...

	@overload
	def fill(self, arg0) -> vnl_matrix:
		""""""
		...

	@overload
	def fill(self, arg0: float) -> vnl_matrix:
		""""""
		...

	@overload
	def fill(self, arg0: int) -> vnl_matrix:
		""""""
		...

	@overload
	def fill_diagonal(self, arg0) -> vnl_matrix:
		""""""
		...

	@overload
	def fill_diagonal(self, arg0: float) -> vnl_matrix:
		""""""
		...

	@overload
	def fill_diagonal(self, arg0: int) -> vnl_matrix:
		""""""
		...

	def set_diagonal(self, arg0: vnl_vector) -> vnl_matrix:
		""""""
		...

	def copy_in(self, arg0) -> vnl_matrix:
		""""""
		...

	def set(self, d) -> vnl_matrix:
		""""""
		...

	def copy_out(self, arg0) -> None:
		""""""
		...

	def transpose(self) -> vnl_matrix:
		""""""
		...

	def conjugate_transpose(self) -> vnl_matrix:
		""""""
		...

	def update(self, arg0: vnl_matrix, top: int = 0, left: int = 0) -> vnl_matrix:
		""""""
		...

	@overload
	def set_column(self, i: int, v) -> vnl_matrix:
		""""""
		...

	@overload
	def set_column(self, i: int, value) -> vnl_matrix:
		""""""
		...

	@overload
	def set_column(self, j: int, v: vnl_vector) -> vnl_matrix:
		""""""
		...

	@overload
	def set_column(self, i: int, value: float) -> vnl_matrix:
		""""""
		...

	@overload
	def set_column(self, i: int, value: int) -> vnl_matrix:
		""""""
		...

	def set_columns(self, starting_column: int, M: vnl_matrix) -> vnl_matrix:
		""""""
		...

	@overload
	def set_row(self, i: int, v) -> vnl_matrix:
		""""""
		...

	@overload
	def set_row(self, i: int, value) -> vnl_matrix:
		""""""
		...

	@overload
	def set_row(self, i: int, arg1: vnl_vector) -> vnl_matrix:
		""""""
		...

	@overload
	def set_row(self, i: int, value: float) -> vnl_matrix:
		""""""
		...

	@overload
	def set_row(self, i: int, value: int) -> vnl_matrix:
		""""""
		...

	@overload
	def extract(self, r: int, c: int, top: int = 0, left: int = 0) -> vnl_matrix:
		""""""
		...

	@overload
	def extract(self, sub_matrix: vnl_matrix, top: int = 0, left: int = 0) -> None:
		""""""
		...

	def get_row(self, r: int) -> vnl_vector:
		""""""
		...

	def get_column(self, c: int) -> vnl_vector:
		""""""
		...

	def get_rows(self, i: vnl_vector) -> vnl_matrix:
		""""""
		...

	def get_columns(self, i: vnl_vector) -> vnl_matrix:
		""""""
		...

	def get_n_rows(self, rowstart: int, n: int) -> vnl_matrix:
		""""""
		...

	def get_n_columns(self, colstart: int, n: int) -> vnl_matrix:
		""""""
		...

	def get_diagonal(self) -> vnl_vector:
		""""""
		...

	def flatten_row_major(self) -> vnl_vector:
		""""""
		...

	def flatten_column_major(self) -> vnl_vector:
		""""""
		...

	def set_identity(self) -> vnl_matrix:
		""""""
		...

	def inplace_transpose(self) -> vnl_matrix:
		""""""
		...

	def flipud(self) -> vnl_matrix:
		""""""
		...

	def fliplr(self) -> vnl_matrix:
		""""""
		...

	def normalize_rows(self) -> vnl_matrix:
		""""""
		...

	def normalize_columns(self) -> vnl_matrix:
		""""""
		...

	@overload
	def scale_row(self, row: int, value) -> vnl_matrix:
		""""""
		...

	@overload
	def scale_row(self, row: int, value: float) -> vnl_matrix:
		""""""
		...

	@overload
	def scale_row(self, row: int, value: int) -> vnl_matrix:
		""""""
		...

	@overload
	def scale_column(self, col: int, value) -> vnl_matrix:
		""""""
		...

	@overload
	def scale_column(self, col: int, value: float) -> vnl_matrix:
		""""""
		...

	@overload
	def scale_column(self, col: int, value: int) -> vnl_matrix:
		""""""
		...

	def swap(self, that: vnl_matrix) -> None:
		""""""
		...

	@overload
	def array_one_norm(self) -> float:
		""""""
		...

	@overload
	def array_one_norm(self) -> int:
		""""""
		...

	@overload
	def array_two_norm(self) -> float:
		""""""
		...

	@overload
	def array_two_norm(self) -> int:
		""""""
		...

	@overload
	def array_inf_norm(self) -> float:
		""""""
		...

	@overload
	def array_inf_norm(self) -> int:
		""""""
		...

	@overload
	def absolute_value_sum(self) -> float:
		""""""
		...

	@overload
	def absolute_value_sum(self) -> int:
		""""""
		...

	@overload
	def absolute_value_max(self) -> float:
		""""""
		...

	@overload
	def absolute_value_max(self) -> int:
		""""""
		...

	@overload
	def operator_one_norm(self) -> float:
		""""""
		...

	@overload
	def operator_one_norm(self) -> int:
		""""""
		...

	@overload
	def operator_inf_norm(self) -> float:
		""""""
		...

	@overload
	def operator_inf_norm(self) -> int:
		""""""
		...

	@overload
	def frobenius_norm(self) -> float:
		""""""
		...

	@overload
	def frobenius_norm(self) -> int:
		""""""
		...

	@overload
	def fro_norm(self) -> float:
		""""""
		...

	@overload
	def fro_norm(self) -> int:
		""""""
		...

	@overload
	def rms(self) -> float:
		""""""
		...

	@overload
	def rms(self) -> int:
		""""""
		...

	@overload
	def min_value(self):
		""""""
		...

	@overload
	def min_value(self) -> float:
		""""""
		...

	@overload
	def min_value(self) -> int:
		""""""
		...

	@overload
	def max_value(self):
		""""""
		...

	@overload
	def max_value(self) -> float:
		""""""
		...

	@overload
	def max_value(self) -> int:
		""""""
		...

	def arg_min(self) -> int:
		""""""
		...

	def arg_max(self) -> int:
		""""""
		...

	@overload
	def mean(self):
		""""""
		...

	@overload
	def mean(self) -> float:
		""""""
		...

	@overload
	def mean(self) -> int:
		""""""
		...

	def empty(self) -> bool:
		""""""
		...

	@overload
	def is_identity(self) -> bool:
		""""""
		...

	@overload
	def is_identity(self, tol: float) -> bool:
		""""""
		...

	@overload
	def is_zero(self) -> bool:
		""""""
		...

	@overload
	def is_zero(self, tol: float) -> bool:
		""""""
		...

	def is_equal(self, rhs: vnl_matrix, tol: float) -> bool:
		""""""
		...

	def is_finite(self) -> bool:
		""""""
		...

	def has_nans(self) -> bool:
		""""""
		...

	def assert_size(self, r: int, c: int) -> None:
		""""""
		...

	def assert_finite(self) -> None:
		""""""
		...

	@staticmethod
	def read(s) -> vnl_matrix:
		""""""
		...

	def read_ascii(self, s) -> bool:
		""""""
		...

	def data_block(self):
		""""""
		...

	def data_array(self):
		""""""
		...

	def begin(self):
		""""""
		...

	def end(self):
		""""""
		...

	def operator_eq(self, rhs: vnl_matrix) -> bool:
		""""""
		...

	def print(self, os) -> None:
		""""""
		...

	def clear(self) -> None:
		""""""
		...

	def set_size(self, r: int, c: int) -> bool:
		""""""
		...

