/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.core.common.bytes;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.bytes.CompositeBytesReference;
import org.opensearch.core.common.bytes.PagedBytesReference;
import org.opensearch.core.common.io.stream.BytesStream;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.util.ByteArray;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="1.0.0")
public interface BytesReference
extends Comparable<BytesReference>,
ToXContentFragment {
    public static BytesReference bytes(XContentBuilder xContentBuilder) {
        OutputStream stream;
        xContentBuilder.close();
        OutputStream outputStream = stream = xContentBuilder.getOutputStream();
        Objects.requireNonNull(outputStream);
        OutputStream outputStream2 = outputStream;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ByteArrayOutputStream.class}, (Object)outputStream2, n)) {
            case 0 -> {
                ByteArrayOutputStream baos = (ByteArrayOutputStream)outputStream2;
                yield new BytesArray(baos.toByteArray());
            }
            default -> ((BytesStream)stream).bytes();
        };
    }

    public static byte[] toBytes(BytesReference reference) {
        BytesRef bytesRef = reference.toBytesRef();
        if (bytesRef.offset == 0 && bytesRef.length == bytesRef.bytes.length) {
            return bytesRef.bytes;
        }
        return ArrayUtil.copyOfSubArray((byte[])bytesRef.bytes, (int)bytesRef.offset, (int)(bytesRef.offset + bytesRef.length));
    }

    public static byte[] toBytesWithoutCompact(BytesReference reference) {
        BytesRef bytesRef = reference.toBytesRef();
        return bytesRef.bytes;
    }

    public static ByteBuffer[] toByteBuffers(BytesReference reference) {
        BytesRefIterator byteRefIterator = reference.iterator();
        try {
            BytesRef r;
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
            while ((r = byteRefIterator.next()) != null) {
                buffers.add(ByteBuffer.wrap(r.bytes, r.offset, r.length));
            }
            return buffers.toArray(new ByteBuffer[0]);
        }
        catch (IOException e) {
            throw new AssertionError("won't happen", e);
        }
    }

    public static BytesReference fromByteBuffers(ByteBuffer[] buffers) {
        int bufferCount = buffers.length;
        if (bufferCount == 0) {
            return BytesArray.EMPTY;
        }
        if (bufferCount == 1) {
            return BytesReference.fromByteBuffer(buffers[0]);
        }
        BytesReference[] references = new BytesReference[bufferCount];
        for (int i = 0; i < bufferCount; ++i) {
            references[i] = BytesReference.fromByteBuffer(buffers[i]);
        }
        return CompositeBytesReference.of(references);
    }

    public static BytesReference fromByteBuffer(ByteBuffer buffer) {
        if (buffer.hasArray()) {
            return new BytesArray(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        }
        byte[] array = new byte[buffer.remaining()];
        buffer.asReadOnlyBuffer().get(array, 0, buffer.remaining());
        return new BytesArray(array);
    }

    public static BytesReference fromByteArray(ByteArray byteArray, int length) {
        if (length == 0) {
            return BytesArray.EMPTY;
        }
        if (byteArray.hasArray()) {
            return new BytesArray(byteArray.array(), 0, length);
        }
        return new PagedBytesReference(byteArray, 0, length);
    }

    public byte get(int var1);

    default public int getInt(int index) {
        return (this.get(index) & 0xFF) << 24 | (this.get(index + 1) & 0xFF) << 16 | (this.get(index + 2) & 0xFF) << 8 | this.get(index + 3) & 0xFF;
    }

    public int indexOf(byte var1, int var2);

    public int length();

    public BytesReference slice(int var1, int var2);

    public long ramBytesUsed();

    public StreamInput streamInput() throws IOException;

    public void writeTo(OutputStream var1) throws IOException;

    public String utf8ToString();

    public BytesRef toBytesRef();

    public BytesRefIterator iterator();
}

