---
stage: GitLab Delivery
group: Operate
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: GitLabのリリースおよびメンテナンスポリシー
description: バージョンのサポート、リリースケイデンス、バックポートポリシー。
---

Delivery Groupは、メンテナンスポリシーのオーナーであり、リクエストされた更新をすべて承認する必要があります。これは、当社のDRIモデルに従ったもので、お客様に対して予測可能性を提供するために導入されています。

GitLabには、バージョン命名規則、およびメジャー、マイナー、パッチリリースのリリース頻度を管理する厳格なポリシーがあります。新しいリリースは、[GitLabブログ](https://about.gitlab.com/releases/categories/releases/)で発表されます。

現在のポリシーは次のとおりです。

- バグ修正のバックポートは、常に**現在の安定版リリースのみ**に対して行います。下記の[パッチリリース](#patch-releases)を参照してください。
- セキュリティ修正のバックポートは、**現在の安定版リリースに加えて、過去2回の月次リリース**に対して行います。状況によっては（下記の[パッチリリース](#patch-releases)に概要を記載）、セキュリティの脆弱性への対応が、バックポートなしで、現在の安定版リリースのみ、または通常の月次リリースプロセスで行われる場合があります。

まれに、リリースマネージャーが例外として、過去2回以上の月次リリースにバックポートすることがあります。詳細については、[古いリリースへのバックポート](#backporting-to-older-releases)を参照してください。

## バージョニング {#versioning}

GitLabは、リリースに[セマンティックバージョニング](https://semver.org/)`(Major).(Minor).(Patch)`を使用しています。

たとえば、GitLabバージョン13.10.6の場合: 

- `13`はメジャーバージョンを表します。メジャーリリースは13.0.0でしたが、13.0と呼ばれることがよくあります。
- `10`はマイナーバージョンを表します。マイナーリリースは13.10.0でしたが、13.10と呼ばれることがよくあります。
- `6`はパッチ番号を表します。

バージョン番号のどの部分も、複数の桁に増やすことができます（例：13.10.11）。

次のテーブルに、バージョンタイプとそのリリースケイデンスを示します。

| バージョンタイプ | 説明 | ケイデンス |
|:-------------|:------------|:--------|
| メジャー        | 大幅な変更の場合、または下位互換性のない変更がパブリックAPIに導入された場合。 | 年1回。次のメジャーリリースはGitLab 18.0で、2025年5月15日に予定されています。GitLabは、デフォルトでは、毎年5月に[メジャーリリースをスケジュール](https://about.gitlab.com/releases/)しています。 |
| マイナー        | 新しい下位互換性のある機能がパブリックAPIに導入された場合、マイナー機能が導入された場合、または一連のより小さな機能がロールアウトされた場合。 | 毎月、各月の第3木曜日にスケジュールされています。 |
| パッチ        | 正しくない動作を修正する下位互換性のあるバグ修正の場合。[パッチリリース](#patch-releases)を参照してください。 | 月2回、月次のマイナーリリースの前週の水曜日と翌週の水曜日にスケジュールされています。 |

<!-- Do not edit the following section without consulting the Technical Writing team -->

<!-- vale gitlab_base.CurrentStatus = NO -->

## メンテナンスバージョン {#maintained-versions}

以下のGitLabのリリースバージョンは現在メンテナンスされています。

{{< maintained-versions >}}

<!-- vale gitlab_base.CurrentStatus = YES -->

<!-- END -->

{{< alert type="note" >}}

今後のパッチリリースのメンテナンスバージョンを確認したい**GitLabチームメンバー**は「[**Release Versions**](https://dashboards.gitlab.net/goto/h228fPEHR?orgId=1)」を参照してください。参照先は「Patch Release Information」セクションにあります。内部Grafanaダッシュボード「[delivery: Release Information](https://dashboards.gitlab.net/goto/6zeLfPENR?orgId=1)」内です。アクティブな月次リリース日がアクティブなパッチリリース日よりも前の場合、上記のメンテナンスバージョンのリストとは異なります。

**バグ修正のバックポートは現在の（最初の）バージョンに対してメンテナンスされ、セキュリティ修正のバックポートはすべてのバージョンに対してメンテナンスされます**。

{{< /alert >}}

## アップグレードの推奨事項 {#upgrade-recommendations}

最も安全で機能豊富なGitLabエクスペリエンスにアップグレードできるように、[最新の安定版リリース](https://about.gitlab.com/releases/categories/releases/)を実行することをすべてのユーザーに推奨します。最新の安定版リリースを確実に実行できるように、アップデートプロセスを信頼性の高いものにするための取り組みを続けています。

月次リリースサイクルに従うことができない場合は、考慮すべき点がいくつかあります。バージョン間で安全にアップグレードするには、[アップグレードパスガイド](../update/upgrade_paths.md)に従ってください。

Linuxパッケージのバージョン固有の変更ドキュメントは、以下で入手できます。

- [GitLab 17](../update/versions/gitlab_17_changes.md)
- [GitLab 16](../update/versions/gitlab_16_changes.md)
- [GitLab 15](../update/versions/gitlab_15_changes.md)

Linuxパッケージをローカルにダウンロードし、[手動でインストール](../update/package/_index.md#by-using-a-downloaded-package)するための手順が用意されています。

[LinuxパッケージにバンドルされたPostgreSQLをアップグレードする](https://docs.gitlab.com/omnibus/settings/database.html#upgrade-packaged-postgresql-server)手順ガイドは、別途文書化されています。

## メジャーバージョンをアップグレードする {#upgrading-major-versions}

下位互換性のない変更と移行は、メジャーバージョンで行われます。詳細については、[GitLabアップグレードプランを作成する](../update/plan_your_upgrade.md)を参照してください。

## パッチリリース {#patch-releases}

パッチリリースには、GitLabの現在の安定版リリースの**バグ修正**、および現在の安定版リリースに加えて、過去2回の月次リリースへの**セキュリティ修正**が含まれます。

これらのポリシーが実施されている理由は次のとおりです。

1. GitLabにはCommunityおよびEnterpriseのディストリビューションがあり、ソフトウェアのテスト/リリースに2倍の作業量が必要です。
1. 古いリリースへのバックポートは、開発、品質管理、およびサポートコストが高くなります。
1. バージョンを並行してサポートすると、段階的なアップグレードが避けられ、時間の経過とともに複雑さが増し、すべてのユーザーにとってアップグレードが難しくなります。GitLabには、段階的なアップグレード（およびインストール）を可能な限り簡単にするための専任のチームがあります。
1. GitLabアプリケーションで行われた変更の数は多く、古いリリースへのバックポートは一層複雑になっています。多くの場合、バックポートは新しい変更が行うのと同じレビュープロセスを経る必要があります。
1. 古いリリースでテストに合格することを保証することは、場合によってはかなりの課題であり、そのため非常に時間がかかります。

[セマンティックバージョニング](https://semver.org/)を破ることになるため、パッチリリースに新機能を含めることはできません。[セマンティックバージョニング](https://semver.org/)を破ると、さまざまな内部要件（たとえば、組織のコンプライアンス、新機能の検証など）を順守する必要があるユーザーに次の影響があります。

1. パッチバージョンに含まれるバグ修正を活用するために、迅速にアップグレードできない。
1. パッチバージョンに含まれるセキュリティ修正を活用するために、迅速にアップグレードできない。
1. 安定したGitLabバージョンだけでなく、すべてのパッチバージョンの広範なテストが要求される。

非常に深刻なセキュリティイシューについては、セキュリティ修正をさらに以前のGitLabリリースバージョンにバックポートした[前例](https://about.gitlab.com/releases/2016/05/02/cve-2016-4340-patches/)があります。この決定は、個々のケースに基づいて行われます。

状況によっては、バックポートなしで、アクティブな最新の安定版リリースのみを更新することにより、通常の月次リリースプロセスを使用して脆弱性に対処することを選択する場合があります。この決定に影響を与える要因には、悪用される可能性が非常に低いこと、脆弱性の影響が低いこと、セキュリティ修正の複雑さ、および安定性に対する最終的なリスクなどがあります。重大度が高く、クリティカルなセキュリティイシューには常に、パッチリリースで対応します。

### 古いリリースへのバックポート {#backporting-to-older-releases}

複数の安定版リリースへのバックポートは、通常、[セキュリティ修正](#patch-releases)のために行われます。ただし、バグの重大度によっては、複数の安定版リリースにバグ修正をバックポートする場合があります。

変更のバックポートを実行するかどうかの決定は、[現在のリリースマネージャー](https://about.gitlab.com/community/release-managers/)の裁量で行われ、次の**すべて**の要素に基づきます。

1. バグの推定重大度: 現在の重大度の定義に基づく、ユーザーへの最大の影響度。
1. バグの推定優先度: 前述の推定重大度に基づく、影響を受けるすべてのユーザーに対する即時的な影響。
1. データ損失および/またはセキュリティ漏洩が発生する可能性。
1. ユーザーが現在の安定版バージョンにアップグレードできないため、1つ以上の戦略的アカウントに影響を与える可能性。

前述のリストにある項目の**すべての要素**が満たされた場合、現在の安定版リリース、および過去2回の月次リリースに対してバックポートリリースを作成できます。まれに、リリースマネージャーが例外として、過去2回以上の月次リリースをバックポートすることがあります。たとえば、`13.0.0`で発生した重大なバグの修正を含む`13.2.1`をリリースする場合、修正を新しい`13.0.x`および`13.1.x`パッチリリースにバックポートできます。

重大度3以下のリクエストは自動的に拒否されます。

複数の安定版リリースへのバックポートを考慮するようリクエストするには、[リリース/タスク](https://gitlab.com/gitlab-org/release/tasks/-/issues/new?issuable_template=Backporting-request)イシュートラッカーでイシューを提起してください。

## 詳細情報 {#more-information}

次のドキュメントも参照してください。

- リリース手順を説明した[リリースドキュメント](https://gitlab.com/gitlab-org/release/docs)
- 開発ドキュメントの非推奨ガイドライン。
- [責任ある開示ポリシー](https://about.gitlab.com/security/disclosure/)
