﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/resourcegroupstaggingapi/ResourceGroupsTaggingAPI_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ResourceGroupsTaggingAPI {
namespace Model {
class GetTagValuesResult {
 public:
  AWS_RESOURCEGROUPSTAGGINGAPI_API GetTagValuesResult() = default;
  AWS_RESOURCEGROUPSTAGGINGAPI_API GetTagValuesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_RESOURCEGROUPSTAGGINGAPI_API GetTagValuesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A string that indicates that there is more data available than this response
   * contains. To receive the next part of the response, specify this response value
   * as the <code>PaginationToken</code> value in the request for the next page.</p>
   */
  inline const Aws::String& GetPaginationToken() const { return m_paginationToken; }
  template <typename PaginationTokenT = Aws::String>
  void SetPaginationToken(PaginationTokenT&& value) {
    m_paginationTokenHasBeenSet = true;
    m_paginationToken = std::forward<PaginationTokenT>(value);
  }
  template <typename PaginationTokenT = Aws::String>
  GetTagValuesResult& WithPaginationToken(PaginationTokenT&& value) {
    SetPaginationToken(std::forward<PaginationTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of all tag values for the specified key currently used in the
   * specified Amazon Web Services Region for the calling account.</p>
   */
  inline const Aws::Vector<Aws::String>& GetTagValues() const { return m_tagValues; }
  template <typename TagValuesT = Aws::Vector<Aws::String>>
  void SetTagValues(TagValuesT&& value) {
    m_tagValuesHasBeenSet = true;
    m_tagValues = std::forward<TagValuesT>(value);
  }
  template <typename TagValuesT = Aws::Vector<Aws::String>>
  GetTagValuesResult& WithTagValues(TagValuesT&& value) {
    SetTagValues(std::forward<TagValuesT>(value));
    return *this;
  }
  template <typename TagValuesT = Aws::String>
  GetTagValuesResult& AddTagValues(TagValuesT&& value) {
    m_tagValuesHasBeenSet = true;
    m_tagValues.emplace_back(std::forward<TagValuesT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetTagValuesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_paginationToken;

  Aws::Vector<Aws::String> m_tagValues;

  Aws::String m_requestId;
  bool m_paginationTokenHasBeenSet = false;
  bool m_tagValuesHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ResourceGroupsTaggingAPI
}  // namespace Aws
