﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/quicksight/QuickSight_EXPORTS.h>
#include <aws/quicksight/model/ResourceStatus.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace QuickSight {
namespace Model {
class CreateDashboardResult {
 public:
  AWS_QUICKSIGHT_API CreateDashboardResult() = default;
  AWS_QUICKSIGHT_API CreateDashboardResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_QUICKSIGHT_API CreateDashboardResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The ARN of the dashboard.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  CreateDashboardResult& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the dashboard, including the version number of the first version
   * that is created.</p>
   */
  inline const Aws::String& GetVersionArn() const { return m_versionArn; }
  template <typename VersionArnT = Aws::String>
  void SetVersionArn(VersionArnT&& value) {
    m_versionArnHasBeenSet = true;
    m_versionArn = std::forward<VersionArnT>(value);
  }
  template <typename VersionArnT = Aws::String>
  CreateDashboardResult& WithVersionArn(VersionArnT&& value) {
    SetVersionArn(std::forward<VersionArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID for the dashboard.</p>
   */
  inline const Aws::String& GetDashboardId() const { return m_dashboardId; }
  template <typename DashboardIdT = Aws::String>
  void SetDashboardId(DashboardIdT&& value) {
    m_dashboardIdHasBeenSet = true;
    m_dashboardId = std::forward<DashboardIdT>(value);
  }
  template <typename DashboardIdT = Aws::String>
  CreateDashboardResult& WithDashboardId(DashboardIdT&& value) {
    SetDashboardId(std::forward<DashboardIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the dashboard creation request.</p>
   */
  inline ResourceStatus GetCreationStatus() const { return m_creationStatus; }
  inline void SetCreationStatus(ResourceStatus value) {
    m_creationStatusHasBeenSet = true;
    m_creationStatus = value;
  }
  inline CreateDashboardResult& WithCreationStatus(ResourceStatus value) {
    SetCreationStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The HTTP status of the request.</p>
   */
  inline int GetStatus() const { return m_status; }
  inline void SetStatus(int value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline CreateDashboardResult& WithStatus(int value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateDashboardResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_arn;

  Aws::String m_versionArn;

  Aws::String m_dashboardId;

  ResourceStatus m_creationStatus{ResourceStatus::NOT_SET};

  int m_status{0};

  Aws::String m_requestId;
  bool m_arnHasBeenSet = false;
  bool m_versionArnHasBeenSet = false;
  bool m_dashboardIdHasBeenSet = false;
  bool m_creationStatusHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace QuickSight
}  // namespace Aws
