/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.http.netty4;

import java.io.Closeable;
import java.io.IOException;
import org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.core.common.transport.BoundTransportAddress;
import org.opensearch.http.AbstractHttpServerTransport;
import org.opensearch.http.HttpInfo;
import org.opensearch.http.HttpServerTransport;
import org.opensearch.http.HttpStats;

public class Netty4CompositeHttpServerTransport
extends AbstractLifecycleComponent
implements HttpServerTransport {
    private final AbstractHttpServerTransport[] transports;

    public Netty4CompositeHttpServerTransport(AbstractHttpServerTransport ... transports) {
        if (transports == null || transports.length == 0) {
            throw new IllegalArgumentException("At least one transport must be provided");
        }
        this.transports = transports;
    }

    public BoundTransportAddress boundAddress() {
        return this.transports[0].boundAddress();
    }

    public HttpInfo info() {
        return this.transports[0].info();
    }

    public HttpStats stats() {
        long serverOpen = 0L;
        long totalOpen = 0L;
        for (AbstractHttpServerTransport transport : this.transports) {
            HttpStats stats = transport.stats();
            serverOpen += stats.getServerOpen();
            totalOpen += stats.getTotalOpen();
        }
        return new HttpStats.Builder().serverOpen(serverOpen).totalOpen(totalOpen).build();
    }

    protected void doStart() {
        for (AbstractHttpServerTransport transport : this.transports) {
            transport.start();
        }
    }

    protected void doStop() {
        for (AbstractHttpServerTransport transport : this.transports) {
            transport.stop();
        }
    }

    protected void doClose() throws IOException {
        for (AbstractHttpServerTransport transport : this.transports) {
            IOUtils.closeWhileHandlingException((Closeable)transport);
        }
    }
}

