/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeListNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserConflictsNodeKt;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserResolvedConflictsNodeKt;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.platform.vcs.changes.ChangesUtil;
import com.intellij.util.ui.tree.TreeUtil;
import javax.swing.JTree;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ChangesViewTreeStateStrategy
implements ChangesTree.TreeStateStrategy<MyState> {
    @Override
    @NotNull
    public MyState saveState(@NotNull ChangesTree tree) {
        if (tree == null) {
            ChangesViewTreeStateStrategy.$$$reportNull$$$0(0);
        }
        ChangesBrowserNode<?> oldRoot = tree.getRoot();
        TreeState state = TreeState.createOn((JTree)((Object)tree), oldRoot);
        state.setScrollToSelection(false);
        return new MyState(state, oldRoot.getFileCount());
    }

    @Override
    public void restoreState(@NotNull ChangesTree tree, @NotNull MyState state, boolean scrollToSelection) {
        if (tree == null) {
            ChangesViewTreeStateStrategy.$$$reportNull$$$0(1);
        }
        if (state == null) {
            ChangesViewTreeStateStrategy.$$$reportNull$$$0(2);
        }
        ChangesBrowserNode<?> newRoot = tree.getRoot();
        state.treeState.applyTo((JTree)((Object)tree), newRoot);
        ChangesViewTreeStateStrategy.initTreeStateIfNeeded((ChangesListView)tree, newRoot, state.oldFileCount);
    }

    private static void initTreeStateIfNeeded(@NotNull ChangesListView view, @NotNull ChangesBrowserNode<?> newRoot, int oldFileCount) {
        ChangesBrowserNode<?> defaultListNode;
        ChangesBrowserNode<?> firstMergeNode;
        if (view == null) {
            ChangesViewTreeStateStrategy.$$$reportNull$$$0(3);
        }
        if (newRoot == null) {
            ChangesViewTreeStateStrategy.$$$reportNull$$$0(4);
        }
        if ((firstMergeNode = ChangesViewTreeStateStrategy.getFirstMergeConflictNode(view)) != null) {
            TreeUtil.selectNode((JTree)((Object)view), firstMergeNode);
        }
        if ((defaultListNode = ChangesViewTreeStateStrategy.getDefaultChangelistNode(newRoot)) == null) {
            return;
        }
        if (view.getSelectionCount() == 0) {
            TreeUtil.selectNode((JTree)((Object)view), defaultListNode);
        }
        if (oldFileCount == 0 && TreeUtil.collectExpandedPaths((JTree)((Object)view)).isEmpty()) {
            view.expandSafe(defaultListNode);
        }
    }

    @Nullable
    private static ChangesBrowserNode<?> getDefaultChangelistNode(@NotNull ChangesBrowserNode<?> root) {
        if (root == null) {
            ChangesViewTreeStateStrategy.$$$reportNull$$$0(5);
        }
        return (ChangesBrowserNode)root.iterateNodeChildren().filter(ChangesBrowserChangeListNode.class).find(node -> {
            ChangeList list = (ChangeList)node.getUserObject();
            return list instanceof LocalChangeList && ((LocalChangeList)list).isDefault();
        });
    }

    @Nullable
    private static ChangesBrowserNode<?> getFirstMergeConflictNode(@NotNull ChangesListView view) {
        ChangesBrowserNode<?> conflictNode;
        if (view == null) {
            ChangesViewTreeStateStrategy.$$$reportNull$$$0(6);
        }
        if ((conflictNode = ChangesViewTreeStateStrategy.getFirstConflictNode(view)) != null) {
            return conflictNode;
        }
        ChangesBrowserNode<?> resolvedConflictNode = ChangesViewTreeStateStrategy.getFirstResolvedConflictNode(view);
        if (resolvedConflictNode != null) {
            return resolvedConflictNode;
        }
        return null;
    }

    @Nullable
    private static ChangesBrowserNode<?> getFirstConflictNode(@NotNull ChangesListView view) {
        if (view == null) {
            ChangesViewTreeStateStrategy.$$$reportNull$$$0(7);
        }
        return (ChangesBrowserNode)VcsTreeModelData.allUnderTag((JTree)((Object)view), ChangesBrowserConflictsNodeKt.CONFLICTS_NODE_TAG).iterateRawNodes().filter(ChangesBrowserChangeNode.class).find(node -> ChangesUtil.isMergeConflict((Change)((Change)node.getUserObject())));
    }

    @Nullable
    private static ChangesBrowserNode<?> getFirstResolvedConflictNode(@NotNull ChangesListView view) {
        if (view == null) {
            ChangesViewTreeStateStrategy.$$$reportNull$$$0(8);
        }
        return (ChangesBrowserNode)VcsTreeModelData.allUnderTag((JTree)((Object)view), ChangesBrowserResolvedConflictsNodeKt.RESOLVED_CONFLICTS_NODE_TAG).iterateRawNodes().filter(ChangesBrowserChangeNode.class).find(node -> ChangesUtil.isMergeConflict((Change)((Change)node.getUserObject())));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRoot";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewTreeStateStrategy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "saveState";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreState";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "initTreeStateIfNeeded";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getDefaultChangelistNode";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getFirstMergeConflictNode";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getFirstConflictNode";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getFirstResolvedConflictNode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public record MyState(@NotNull TreeState treeState, int oldFileCount) {
        @NotNull
        private final TreeState treeState;

        public MyState(@NotNull TreeState treeState, int oldFileCount) {
            if (treeState == null) {
                MyState.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public TreeState treeState() {
            TreeState treeState = this.treeState;
            if (treeState == null) {
                MyState.$$$reportNull$$$0(1);
            }
            return treeState;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "treeState";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangesViewTreeStateStrategy$MyState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewTreeStateStrategy$MyState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "treeState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

