/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.ASCIIPropertyListParser;
import com.dd.plist.ASCIIPropertyListWriter;
import com.dd.plist.BinaryPropertyListParser;
import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.ByteOrderMarkReader;
import com.dd.plist.NSArray;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListConverter;
import com.dd.plist.PropertyListFormatException;
import com.dd.plist.XMLPropertyListParser;
import com.dd.plist.XMLPropertyListWriter;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.Objects;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class PropertyListParser {
    private static final int TYPE_XML = 0;
    private static final int TYPE_BINARY = 1;
    private static final int TYPE_ASCII = 2;
    private static final int TYPE_ERROR_BLANK = 10;
    private static final int TYPE_ERROR_UNKNOWN = 11;
    private static final int READ_BUFFER_LENGTH = 4096;

    protected PropertyListParser() {
    }

    private static int determineType(String dataBeginning) {
        if ((dataBeginning = dataBeginning.trim()).length() == 0) {
            return 10;
        }
        if (dataBeginning.startsWith("bplist")) {
            return 1;
        }
        if (dataBeginning.startsWith("(") || dataBeginning.startsWith("{") || dataBeginning.startsWith("/")) {
            return 2;
        }
        if (dataBeginning.startsWith("<")) {
            return 0;
        }
        return 11;
    }

    private static int determineType(InputStream is, int offset) throws IOException {
        int b;
        int index = offset;
        int readLimit = index + 1024;
        if (is.markSupported()) {
            is.mark(readLimit);
        }
        is.skip(offset);
        ByteOrderMarkReader bomReader = new ByteOrderMarkReader();
        boolean bom = true;
        do {
            if (++index <= readLimit) continue;
            is.reset();
            return PropertyListParser.determineType(is, readLimit);
        } while ((b = is.read()) != -1 && (b == 32 || b == 9 || b == 13 || b == 10 || b == 12 || (bom &= bomReader.readByte(b))));
        if (b == -1) {
            return 10;
        }
        String charset = bomReader.getDetectedCharset();
        if (charset == null) {
            charset = "UTF-8";
        }
        byte[] magicBytes = new byte[8];
        magicBytes[0] = (byte)b;
        int read = is.read(magicBytes, 1, 7);
        if (read == -1) {
            return 11;
        }
        int type = PropertyListParser.determineType(new String(magicBytes, 0, read, Charset.forName(charset)));
        if (is.markSupported()) {
            is.reset();
        }
        return type;
    }

    protected static byte[] readAll(InputStream in) throws IOException {
        int read;
        Objects.requireNonNull(in, "The specified input stream is null");
        ByteArrayOutputStream outputStream2 = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((read = in.read(buf, 0, 4096)) != -1) {
            outputStream2.write(buf, 0, read);
        }
        return outputStream2.toByteArray();
    }

    public static NSObject parse(String filePath) throws ParserConfigurationException, ParseException, SAXException, PropertyListFormatException, IOException {
        return PropertyListParser.parse(FileSystems.getDefault().getPath(filePath, new String[0]));
    }

    public static NSObject parse(File f) throws IOException, PropertyListFormatException, ParseException, ParserConfigurationException, SAXException {
        return PropertyListParser.parse(f.toPath());
    }

    public static NSObject parse(Path path) throws IOException, PropertyListFormatException, ParseException, ParserConfigurationException, SAXException {
        try (InputStream fileInputStream = Files.newInputStream(path, new OpenOption[0]);){
            NSObject nSObject = PropertyListParser.parse(fileInputStream);
            return nSObject;
        }
    }

    public static NSObject parse(byte[] bytes) throws IOException, PropertyListFormatException, ParseException, ParserConfigurationException, SAXException {
        return PropertyListParser.parse(new ByteArrayInputStream(bytes));
    }

    public static NSObject parse(InputStream is) throws IOException, PropertyListFormatException, ParseException, ParserConfigurationException, SAXException {
        if (!is.markSupported()) {
            is = new BufferedInputStream(is);
        }
        switch (PropertyListParser.determineType(is, 0)) {
            case 1: {
                return BinaryPropertyListParser.parse(is);
            }
            case 0: {
                return XMLPropertyListParser.parse(is);
            }
            case 2: {
                return ASCIIPropertyListParser.parse(is);
            }
            case 10: {
                return null;
            }
        }
        throw new PropertyListFormatException("The given data is not a property list of a supported format.");
    }

    @Deprecated
    public static void saveAsXML(NSObject root, File out) throws IOException {
        XMLPropertyListWriter.write(root, out);
    }

    @Deprecated
    public static void saveAsXML(NSObject root, OutputStream out) throws IOException {
        XMLPropertyListWriter.write(root, out);
    }

    @Deprecated
    public static void convertToXml(File in, File out) throws ParserConfigurationException, ParseException, SAXException, PropertyListFormatException, IOException {
        PropertyListConverter.convertToXml(in, out);
    }

    public static void saveAsBinary(NSObject root, File out) throws IOException {
        BinaryPropertyListWriter.write(root, out, true);
    }

    @Deprecated
    public static void saveAsBinary(NSObject root, OutputStream out) throws IOException {
        BinaryPropertyListWriter.write(root, out);
    }

    @Deprecated
    public static void convertToBinary(File in, File out) throws IOException, ParserConfigurationException, ParseException, SAXException, PropertyListFormatException {
        PropertyListConverter.convertToBinary(in, out);
    }

    @Deprecated
    public static void saveAsASCII(NSDictionary root, File out) throws IOException {
        ASCIIPropertyListWriter.write(root, out);
    }

    @Deprecated
    public static void saveAsASCII(NSArray root, File out) throws IOException {
        ASCIIPropertyListWriter.write(root, out);
    }

    @Deprecated
    public static void convertToASCII(File in, File out) throws ParserConfigurationException, ParseException, SAXException, PropertyListFormatException, IOException {
        PropertyListConverter.convertToASCII(in, out);
    }

    @Deprecated
    public static void saveAsGnuStepASCII(NSDictionary root, File out) throws IOException {
        ASCIIPropertyListWriter.writeGnuStep(root, out);
    }

    @Deprecated
    public static void saveAsGnuStepASCII(NSArray root, File out) throws IOException {
        ASCIIPropertyListWriter.writeGnuStep(root, out);
    }

    @Deprecated
    public static void convertToGnuStepASCII(File in, File out) throws ParserConfigurationException, ParseException, SAXException, PropertyListFormatException, IOException {
        PropertyListConverter.convertToGnuStepASCII(in, out);
    }
}

