/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transfer;

import java.io.IOException;
import java.io.InputStream;
import org.gradle.api.resources.ResourceException;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ResourceExceptions;
import org.gradle.internal.resource.transfer.ExternalResourceAccessor;
import org.gradle.internal.resource.transfer.ExternalResourceReadResponse;
import org.jspecify.annotations.Nullable;

public abstract class AbstractExternalResourceAccessor
implements ExternalResourceAccessor {
    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> @Nullable T withContent(ExternalResourceName location, boolean revalidate, ExternalResource.ContentAndMetadataAction<T> action) throws ResourceException {
        ExternalResourceReadResponse response = this.openResource(location, revalidate);
        if (response == null) {
            return null;
        }
        try (InputStream inputStream = response.openStream();){
            T t;
            block15: {
                ExternalResourceReadResponse responseCloser = response;
                try {
                    t = action.execute(inputStream, responseCloser.getMetaData());
                    if (responseCloser == null) break block15;
                }
                catch (Throwable throwable) {
                    if (responseCloser != null) {
                        try {
                            responseCloser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                responseCloser.close();
            }
            return t;
        }
        catch (IOException e) {
            throw ResourceExceptions.getFailed(location.getUri(), e);
        }
    }

    protected abstract @Nullable ExternalResourceReadResponse openResource(ExternalResourceName var1, boolean var2) throws ResourceException;
}

